/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import java.util.Optional;
import org.apache.james.jmap.JMAPConfiguration;
import org.apache.james.jmap.Version;
import org.apache.james.util.Port;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Java6Assertions;
import org.junit.jupiter.api.Test;

class JMAPConfigurationTest {
    public static final boolean ENABLED = true;
    public static final boolean DISABLED = false;

    JMAPConfigurationTest() {
    }

    @Test
    void buildShouldThrowWhenEnableIsMissing() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JMAPConfiguration.builder().build()).isInstanceOf(IllegalStateException.class)).hasMessage("You should specify if JMAP server should be started");
    }

    @Test
    void buildShouldWorkWhenRandomPort() {
        JMAPConfiguration expectedJMAPConfiguration = new JMAPConfiguration(true, Optional.empty(), true, true, Version.DRAFT, Optional.empty());
        JMAPConfiguration jmapConfiguration = JMAPConfiguration.builder().enable().randomPort().enableEmailQueryView().build();
        Java6Assertions.assertThat((Object)jmapConfiguration).isEqualToComparingFieldByField((Object)expectedJMAPConfiguration);
    }

    @Test
    void buildShouldWorkWhenFixedPort() {
        JMAPConfiguration expectedJMAPConfiguration = new JMAPConfiguration(true, Optional.of(Port.of((int)80)), true, true, Version.DRAFT, Optional.empty());
        JMAPConfiguration jmapConfiguration = JMAPConfiguration.builder().enable().port(Port.of((int)80)).enableEmailQueryView().enableUserProvisioning().build();
        Java6Assertions.assertThat((Object)jmapConfiguration).isEqualToComparingFieldByField((Object)expectedJMAPConfiguration);
    }

    @Test
    void buildShouldWorkWhenDisabled() {
        JMAPConfiguration expectedJMAPConfiguration = new JMAPConfiguration(false, Optional.empty(), false, false, Version.DRAFT, Optional.empty());
        JMAPConfiguration jmapConfiguration = JMAPConfiguration.builder().disable().disableEmailQueryView().disableUserProvisioning().build();
        Java6Assertions.assertThat((Object)jmapConfiguration).isEqualToComparingFieldByField((Object)expectedJMAPConfiguration);
    }
}

