/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import org.apache.james.jmap.UriMatcher;
import org.assertj.core.api.Java6Assertions;
import org.junit.jupiter.api.Test;

class FixedUriMatcherTest {
    FixedUriMatcherTest() {
    }

    @Test
    void fixedMatcherShouldReturnTrueWhenUriHaveNoQueryCharacterAndMatchWithPath() {
        UriMatcher.Fixed testee = new UriMatcher.Fixed("path");
        Java6Assertions.assertThat((boolean)testee.matches("path")).isTrue();
    }

    @Test
    void fixedMatcherShouldReturnTrueWhenUriHaveAQueryParamAndTheRestIsMatchWithPath() {
        UriMatcher.Fixed testee = new UriMatcher.Fixed("path");
        Java6Assertions.assertThat((boolean)testee.matches("path?param1=somevalue")).isTrue();
    }

    @Test
    void fixedMatcherShouldReturnTrueWhenUriHaveManyQueryParamsAndTheRestIsMatchWithPath() {
        UriMatcher.Fixed testee = new UriMatcher.Fixed("path");
        Java6Assertions.assertThat((boolean)testee.matches("path?param1=1&param2=2")).isTrue();
    }

    @Test
    void fixedMatcherShouldReturnFalseWhenNotMatchingUri() {
        UriMatcher.Fixed testee = new UriMatcher.Fixed("path");
        Java6Assertions.assertThat((boolean)testee.matches("anotherPath")).isFalse();
    }
}

