/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.utils.PackageName;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PackageNameTest {
    PackageNameTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(PackageName.class).verify();
    }

    @Test
    void ofShouldThrowWhenNull() {
        Assertions.assertThatThrownBy(() -> PackageName.of(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void ofShouldThrowWhenEmpty() {
        Assertions.assertThatThrownBy(() -> PackageName.of((String)"")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void getNameShouldReturnSuppliedValue() {
        String name = "org.apache.MyClass";
        Assertions.assertThat((String)PackageName.of((String)name).getName()).isEqualTo(name);
    }

    @Test
    void ofShouldThrowWhenStartingDot() {
        Assertions.assertThatThrownBy(() -> PackageName.of((String)".org.apache.MyClass")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void ofShouldSanitizeEndingDot() {
        Assertions.assertThat((String)PackageName.of((String)"org.apache.MyClass.").getName()).isEqualTo("org.apache.MyClass");
    }

    @Test
    void ofShouldThrowWhenDoubleDot() {
        Assertions.assertThatThrownBy(() -> PackageName.of((String)"org.apache..MyClass")).isInstanceOf(IllegalArgumentException.class);
    }
}

