/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import java.util.stream.Stream;
import org.apache.james.utils.ClassName;
import org.apache.james.utils.FullyQualifiedClassName;
import org.apache.james.utils.NamingScheme;
import org.apache.james.utils.PackageName;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class NamingSchemeTest {
    public static final String PACKAGE = "org.apache.james";
    public static final NamingScheme.OptionalPackagePrefix PACKAGE_PREFIX = new NamingScheme.OptionalPackagePrefix(PackageName.of((String)"org.apache.james"));

    NamingSchemeTest() {
    }

    @Nested
    class OptionalPackagePrefixTest {
        OptionalPackagePrefixTest() {
        }

        @Test
        void asFullyQualifiedShouldPromoteNameToFullyQualifiedClass() {
            String name = "org.MyClass";
            ClassName className = new ClassName(name);
            Assertions.assertThat((Stream)PACKAGE_PREFIX.toFullyQualifiedClassNames(className)).containsExactly((Object[])new FullyQualifiedClassName[]{new FullyQualifiedClassName("org.MyClass"), new FullyQualifiedClassName("org.apache.james.org.MyClass")});
        }

        @Test
        void asFullyQualifiedShouldPromoteNameToFullyQualifiedClassWhenNoPackagePart() {
            String name = "MyClass";
            ClassName className = new ClassName(name);
            Assertions.assertThat((Stream)PACKAGE_PREFIX.toFullyQualifiedClassNames(className)).containsExactly((Object[])new FullyQualifiedClassName[]{new FullyQualifiedClassName("MyClass"), new FullyQualifiedClassName("org.apache.james.MyClass")});
        }
    }

    @Nested
    class IdentityTest {
        IdentityTest() {
        }

        @Test
        void asFullyQualifiedShouldPromoteNameToFullyQualifiedClass() {
            String name = "org.MyClass";
            ClassName className = new ClassName(name);
            Assertions.assertThat((Stream)NamingScheme.IDENTITY.toFullyQualifiedClassNames(className)).containsExactly((Object[])new FullyQualifiedClassName[]{new FullyQualifiedClassName(name)});
        }

        @Test
        void asFullyQualifiedShouldPromoteNameToFullyQualifiedClassWhenNoPackagePart() {
            String name = "MyClass";
            ClassName className = new ClassName(name);
            Assertions.assertThat((Stream)NamingScheme.IDENTITY.toFullyQualifiedClassNames(className)).containsExactly((Object[])new FullyQualifiedClassName[]{new FullyQualifiedClassName(name)});
        }
    }
}

