/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import java.util.List;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.utils.ClassName;
import org.apache.james.utils.ExtensionConfiguration;
import org.apache.james.utils.PropertiesProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExtensionConfigurationTest {
    @Test
    void shouldReturnEmptyWhenNoField() throws Exception {
        Configuration configuration = this.getConfiguration("extensions-none");
        Assertions.assertThat((List)ExtensionConfiguration.from((Configuration)configuration).getAdditionalGuiceModulesForExtensions()).isEmpty();
    }

    @Test
    void shouldReturnEmptyWhenEmptyField() throws Exception {
        Configuration configuration = this.getConfiguration("extensions-empty");
        Assertions.assertThat((List)ExtensionConfiguration.from((Configuration)configuration).getAdditionalGuiceModulesForExtensions()).isEmpty();
    }

    @Test
    void shouldReturnOneRoutes() throws Exception {
        Configuration configuration = this.getConfiguration("extensions-one");
        Assertions.assertThat((List)ExtensionConfiguration.from((Configuration)configuration).getAdditionalGuiceModulesForExtensions()).containsOnly((Object[])new ClassName[]{new ClassName("org.apache.custom.extensions.CustomExtension")});
    }

    @Test
    void shouldReturnSeveralRoutes() throws Exception {
        Configuration configuration = this.getConfiguration("extensions-two");
        Assertions.assertThat((List)ExtensionConfiguration.from((Configuration)configuration).getAdditionalGuiceModulesForExtensions()).containsOnly((Object[])new ClassName[]{new ClassName("org.apache.custom.extensions.CustomExtension"), new ClassName("org.apache.custom.extension.AnotherCustomExtension")});
    }

    private Configuration getConfiguration(String name) throws Exception {
        return PropertiesProvider.forTesting().getConfiguration(name);
    }
}

