/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dnsservice.dnsjava;

import com.google.common.io.Resources;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.james.dnsservice.dnsjava.DNSJavaService;
import org.apache.james.dnsservice.dnsjava.ZoneCacheLookupRecordsAnswer;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.server.core.configuration.FileConfigurationProvider;
import org.assertj.core.api.AbstractUrlAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Cache;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.Zone;

class DNSJavaServiceTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(DNSJavaServiceTest.class);
    private TestableDNSServer dnsServer;
    private static final byte[] DNS_SERVER_CONFIG = "<dnsserver><autodiscover>true</autodiscover><authoritative>false</authoritative></dnsserver>".getBytes();
    private Cache defaultCache;
    private Resolver defaultResolver;
    private List<Name> defaultSearchPaths;
    private Cache mockedCache;

    DNSJavaServiceTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.dnsServer = new TestableDNSServer();
        this.dnsServer.configure((HierarchicalConfiguration)FileConfigurationProvider.getConfig((InputStream)new ByteArrayInputStream(DNS_SERVER_CONFIG)));
        this.dnsServer.init();
        this.defaultCache = Lookup.getDefaultCache((int)1);
        this.defaultResolver = Lookup.getDefaultResolver();
        this.defaultSearchPaths = Lookup.getDefaultSearchPath();
        Lookup.setDefaultCache(null, (int)1);
        Lookup.setDefaultResolver(null);
        Lookup.setDefaultSearchPath((Name[])new Name[0]);
        this.dnsServer.setResolver(null);
        this.mockedCache = (Cache)Mockito.mock(Cache.class);
    }

    @AfterEach
    void tearDown() {
        this.dnsServer.setCache(null);
        this.dnsServer = null;
        Lookup.setDefaultCache((Cache)this.defaultCache, (int)1);
        Lookup.setDefaultResolver((Resolver)this.defaultResolver);
        Lookup.setDefaultSearchPath(this.defaultSearchPaths);
    }

    @Test
    void testNoMX() throws Exception {
        ((Cache)Mockito.doAnswer((Answer)new ZoneCacheLookupRecordsAnswer(DNSJavaServiceTest.loadZone("dnstest.com."))).when((Object)this.mockedCache)).lookupRecords((Name)ArgumentMatchers.any(Name.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        this.dnsServer.setCache(this.mockedCache);
        Collection records = this.dnsServer.findMXRecords("nomx.dnstest.com.");
        Assertions.assertThat((int)records.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)records.iterator().next())).isEqualTo("nomx.dnstest.com.");
    }

    @Test
    void testBadMX() throws Exception {
        ((Cache)Mockito.doAnswer((Answer)new ZoneCacheLookupRecordsAnswer(DNSJavaServiceTest.loadZone("dnstest.com."))).when((Object)this.mockedCache)).lookupRecords((Name)ArgumentMatchers.any(Name.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        this.dnsServer.setCache(this.mockedCache);
        Collection records = this.dnsServer.findMXRecords("badmx.dnstest.com.");
        Assertions.assertThat((int)records.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)records.iterator().next())).isEqualTo("badhost.dnstest.com.");
    }

    @Test
    void testINARecords() throws Exception {
        ((Cache)Mockito.doAnswer((Answer)new ZoneCacheLookupRecordsAnswer(DNSJavaServiceTest.loadZone("pippo.com."))).when((Object)this.mockedCache)).lookupRecords((Name)ArgumentMatchers.any(Name.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        this.dnsServer.setCache(this.mockedCache);
        Collection records = this.dnsServer.findMXRecords("www.pippo.com.");
        Assertions.assertThat((int)records.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)records.iterator().next())).isEqualTo("pippo.com.inbound.mxlogic.net.");
    }

    @Test
    void testMXCatches() throws Exception {
        ((Cache)Mockito.doAnswer((Answer)new ZoneCacheLookupRecordsAnswer(DNSJavaServiceTest.loadZone("test-zone.com."))).when((Object)this.mockedCache)).lookupRecords((Name)ArgumentMatchers.any(Name.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        this.dnsServer.setCache(this.mockedCache);
        Collection res = this.dnsServer.findMXRecords("test-zone.com.");
        try {
            res.add("");
            Fail.fail((String)"MX Collection should not be modifiable");
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("Ignored error", (Throwable)e);
        }
        Assertions.assertThat((int)res.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)res.iterator().next())).isEqualTo("mail.test-zone.com.");
    }

    @Test
    void testTwoMXSamePrio() throws Exception {
        ((Cache)Mockito.doAnswer((Answer)new ZoneCacheLookupRecordsAnswer(DNSJavaServiceTest.loadZone("two-mx.sameprio."))).when((Object)this.mockedCache)).lookupRecords((Name)ArgumentMatchers.any(Name.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        this.dnsServer.setCache(this.mockedCache);
        Collection records = this.dnsServer.findMXRecords("two-mx.sameprio.");
        Assertions.assertThat((int)records.size()).isEqualTo(2);
        Assertions.assertThat((boolean)records.contains("mx1.two-mx.sameprio.")).isTrue();
        Assertions.assertThat((boolean)records.contains("mx2.two-mx.sameprio.")).isTrue();
    }

    @Test
    void testThreeMX() throws Exception {
        ((Cache)Mockito.doAnswer((Answer)new ZoneCacheLookupRecordsAnswer(DNSJavaServiceTest.loadZone("three-mx.bar."))).when((Object)this.mockedCache)).lookupRecords((Name)ArgumentMatchers.any(Name.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        this.dnsServer.setCache(this.mockedCache);
        ArrayList records = new ArrayList(this.dnsServer.findMXRecords("three-mx.bar."));
        Assertions.assertThat((int)records.size()).isEqualTo(3);
        Assertions.assertThat((boolean)records.contains("mx1.three-mx.bar.")).isTrue();
        Assertions.assertThat((boolean)records.contains("mx2.three-mx.bar.")).isTrue();
        Assertions.assertThat((String)((String)records.get(2))).isEqualTo("mx3.three-mx.bar.");
    }

    @Test
    void testTwoMXDifferentPrio() throws Exception {
        ((Cache)Mockito.doAnswer((Answer)new ZoneCacheLookupRecordsAnswer(DNSJavaServiceTest.loadZone("two-mx.differentprio."))).when((Object)this.mockedCache)).lookupRecords((Name)ArgumentMatchers.any(Name.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        this.dnsServer.setCache(this.mockedCache);
        Collection records = this.dnsServer.findMXRecords("two-mx.differentprio.");
        Assertions.assertThat((int)records.size()).isEqualTo(2);
        Assertions.assertThat((boolean)records.contains("mx1.two-mx.differentprio.")).isTrue();
        Assertions.assertThat((boolean)records.contains("mx2.two-mx.differentprio.")).isTrue();
    }

    @Test
    void testOneMX() throws Exception {
        ((Cache)Mockito.doAnswer((Answer)new ZoneCacheLookupRecordsAnswer(DNSJavaServiceTest.loadZone("one-mx.bar."))).when((Object)this.mockedCache)).lookupRecords((Name)ArgumentMatchers.any(Name.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        this.dnsServer.setCache(this.mockedCache);
        Collection records = this.dnsServer.findMXRecords("one-mx.bar.");
        Assertions.assertThat((int)records.size()).isEqualTo(1);
        Assertions.assertThat((boolean)records.contains("mx1.one-mx.bar.")).isTrue();
    }

    private static Zone loadZone(String zoneName) throws IOException {
        String zoneFilename = zoneName + "zone";
        URL zoneResource = Resources.getResource(DNSJavaServiceTest.class, (String)zoneFilename);
        ((AbstractUrlAssert)Assertions.assertThat((URL)zoneResource).withFailMessage("test resource for zone could not be loaded: " + zoneFilename, new Object[0])).isNotNull();
        return new Zone(Name.fromString((String)zoneName), zoneResource.getFile());
    }

    private final class TestableDNSServer
    extends DNSJavaService {
        public TestableDNSServer() {
            super((MetricFactory)new RecordingMetricFactory());
        }

        public void setResolver(Resolver r) {
            this.resolver = r;
        }

        public void setCache(Cache c) {
            this.cache = c;
        }
    }
}

