/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core.filesystem;

import org.apache.james.server.core.filesystem.SimpleUrl;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleUrlTest {
    @Test
    public void simplifyPathShouldThrowOnNull() {
        Assertions.assertThatThrownBy(() -> SimpleUrl.simplifyPath(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void simplifyPathShouldReturnEmptyOnEmptyArray() {
        String actual = SimpleUrl.simplifyPath((String)"");
        Assertions.assertThat((String)actual).isEmpty();
    }

    @Test
    public void simplifyPathShoudReturnEmptyWhenSimplifyingCurrentDir() {
        String actual = SimpleUrl.simplifyPath((String)"./bar/.././foo/..");
        Assertions.assertThat((String)actual).isEmpty();
    }

    @Test
    public void simplifyPathShoudReturnSimplifiedDirectory() {
        String actual = SimpleUrl.simplifyPath((String)"../foo/../bar/./baz");
        Assertions.assertThat((String)actual).isEqualTo("../bar/baz");
    }

    @Test
    public void simplifiedShouldReturnEmptyWhenEmptyInput() {
        Assertions.assertThat((String)new SimpleUrl("").getSimplified()).isEmpty();
    }

    @Test
    public void simplifiedShouldThrowWhenNullInput() {
        Assertions.assertThatThrownBy(() -> new SimpleUrl(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void simplifiedShouldReturnInputValueWhenProtocolOnlyInput() {
        Assertions.assertThat((String)new SimpleUrl("file:").getSimplified()).isEqualTo("file:");
    }

    @Test
    public void simplifiedShouldReturnInputValueWhenRelativePath() {
        Assertions.assertThat((String)new SimpleUrl("abcd/ef/gh").getSimplified()).isEqualTo("abcd/ef/gh");
    }

    @Test
    public void simplifiedShouldReturnInputValueWhenAbsolutePath() {
        Assertions.assertThat((String)new SimpleUrl("/abcd/ef/gh").getSimplified()).isEqualTo("/abcd/ef/gh");
    }

    @Test
    public void simplifiedShouldReturnInputValueWhenHttpUrl() {
        Assertions.assertThat((String)new SimpleUrl("http://example.com/ef/gh").getSimplified()).isEqualTo("http://example.com/ef/gh");
    }

    @Test
    public void simplifiedShouldReturnInputValueWhenPathContainsColumn() {
        Assertions.assertThat((String)new SimpleUrl("ab/cd:ef/gh").getSimplified()).isEqualTo("ab/cd:ef/gh");
    }

    @Test
    public void simplifiedShouldCollapseComplexePathWhenContainingParentDirElement() {
        Assertions.assertThat((String)new SimpleUrl("file:///home/user/./foo/../.bar/baz").getSimplified()).isEqualTo("file:///home/user/.bar/baz");
    }

    @Test
    public void simplifiedShouldCollapseComplexePathWhenContainingParentDirElementInRelativePath() {
        Assertions.assertThat((String)new SimpleUrl("file://../.././foo/../.bar/baz").getSimplified()).isEqualTo("file://../../.bar/baz");
    }

    @Test
    public void simplifiedShouldCollapseComplexePathWhenContainingParentDirElementWithoutDoubleSlashes() {
        Assertions.assertThat((String)new SimpleUrl("file:/home/user/./foo/../.bar/baz").getSimplified()).isEqualTo("file:/home/user/.bar/baz");
    }

    @Test
    public void simplifiedShouldCollapseComplexePathWhenContainingParentDirElementInRelativePathWithoutDoubleSlashes() {
        Assertions.assertThat((String)new SimpleUrl("file:../.././foo/../.bar/baz").getSimplified()).isEqualTo("file:../../.bar/baz");
    }

    @Test
    public void simplifiedShouldReplaceASingleWindowSeperatorByASlash() {
        Assertions.assertThat((String)new SimpleUrl("\\").getSimplified()).isEqualTo("/");
    }

    @Test
    public void simplifiedShouldReplaceAllWindowsSeperatorBySlashes() {
        Assertions.assertThat((String)new SimpleUrl("file:c:\\\\programs\\run.exe").getSimplified()).isEqualTo("file:c://programs/run.exe");
    }
}

