/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core.configuration;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.server.core.MissingArgumentException;
import org.apache.james.server.core.configuration.Configuration;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

class BasicConfigurationTest {
    BasicConfigurationTest() {
    }

    @Test
    void configurationPathShouldMatchBeanContract() {
        EqualsVerifier.forClass(Configuration.ConfigurationPath.class).verify();
    }

    @Test
    void buildShouldThrowWhenWorkingDirectoryIsMissing() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Configuration.builder().build()).isInstanceOf(MissingArgumentException.class)).hasMessage("Server needs a working.directory env entry");
    }

    @Test
    void useWorkingDirectoryEnvPropertyShouldThrowWhenEnvVariableIsUnspecified() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Configuration.builder().useWorkingDirectoryEnvProperty()).isInstanceOf(MissingArgumentException.class)).hasMessage("Server needs a working.directory env entry");
    }

    @Test
    void buildShouldReturnConfigurationWithSuppliedValues() {
        Configuration.Basic configuration = Configuration.builder().workingDirectory("/path").configurationPath(new Configuration.ConfigurationPath("file://myconf/")).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(configuration.directories().getRootDirectory()).isEqualTo("/path");
            softly.assertThat(configuration.configurationPath().asString()).isEqualTo("file://myconf/");
        });
    }

    @Test
    void buildShouldReturnConfigurationWithClassPathConfigurationPathWhenSpecified() {
        Configuration.Basic configuration = Configuration.builder().workingDirectory("/path").configurationFromClasspath().build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(configuration.directories().getRootDirectory()).isEqualTo("/path");
            softly.assertThat(configuration.configurationPath().asString()).isEqualTo("classpath:");
        });
    }

    @Test
    void configurationPathShouldDefaultToFileConf() {
        Configuration.Basic configuration = Configuration.builder().workingDirectory("/path").build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(configuration.directories().getRootDirectory()).isEqualTo("/path");
            softly.assertThat(configuration.configurationPath().asString()).isEqualTo("file://conf/");
        });
    }

    @Test
    void useWorkingDirectoryEnvPropertyShouldReadSystemProperty() {
        try {
            System.setProperty("working.directory", "/path");
            Configuration.Basic configuration = Configuration.builder().useWorkingDirectoryEnvProperty().build();
            Assertions.assertThat((String)configuration.directories().getRootDirectory()).isEqualTo("/path");
        }
        finally {
            System.clearProperty("working.directory");
        }
    }

    @Test
    void getConfDirectoryShouldReturnConfFolderOfRootDir() {
        try {
            System.setProperty("working.directory", "/path");
            Configuration.Basic configuration = Configuration.builder().useWorkingDirectoryEnvProperty().build();
            Assertions.assertThat((String)configuration.directories().getConfDirectory()).isEqualTo("/path/conf/");
        }
        finally {
            System.clearProperty("working.directory");
        }
    }
}

