/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import jakarta.mail.BodyPart;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.util.MimeMessageUtil;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.Test;

public class MimeMessageTest {
    protected MimeMessage getSimpleMessage() throws Exception {
        return MimeMessageBuilder.mimeMessageBuilder().addHeader("Date", "Tue, 16 Jan 2018 09:56:01 +0700 (ICT)").setSubject("test").setText("test body", "text/plain; charset=us-ascii").build();
    }

    protected String getSimpleMessageCleanedSource() {
        return "Subject: test\r\nMIME-Version: 1.0\r\nDate: Tue, 16 Jan 2018 09:56:01 +0700 (ICT)\r\nContent-Type: text/plain; charset=us-ascii\r\nContent-Transfer-Encoding: 7bit\r\n\r\ntest body";
    }

    protected MimeMessage getMessageWithBadReturnPath() throws Exception {
        return MimeMessageBuilder.mimeMessageBuilder().addHeader("Date", "Tue, 16 Jan 2018 09:56:01 +0700 (ICT)").setSubject("test").addHeader("Return-Path", "<mybadreturn@example.com>").setText("test body").build();
    }

    protected String getMessageWithBadReturnPathSource() {
        return "Subject: test\r\nReturn-Path: <mybadreturn@example.com>\r\nMIME-Version: 1.0\r\nDate: Tue, 16 Jan 2018 09:56:01 +0700 (ICT)\r\nContent-Type: text/plain; charset=us-ascii\r\nContent-Transfer-Encoding: 7bit\r\n\r\ntest body";
    }

    protected String getSimpleMessageCleanedSourceHeaderExpected() {
        return "X-Test: foo\r\n" + this.getSimpleMessageCleanedSource();
    }

    @Test
    public void testSimpleMessage() throws Exception {
        MimeMessage m = this.getSimpleMessage();
        Assertions.assertThat((String)this.getCleanedMessageSource(m)).isEqualTo(this.getSimpleMessageCleanedSource());
        LifecycleUtil.dispose((Object)m);
    }

    protected MimeMessage getMultipartMessage() throws Exception {
        MimeMessage mmCreated = MimeMessageUtil.defaultMimeMessage();
        mmCreated.setSubject("test");
        mmCreated.addHeader("Date", "Tue, 16 Jan 2018 09:56:01 +0700 (ICT)");
        MimeMultipart mm = new MimeMultipart("alternative");
        mm.addBodyPart((BodyPart)new MimeBodyPart(new InternetHeaders((InputStream)new ByteArrayInputStream("X-header: test1\r\nContent-Type: text/plain; charset=Cp1252\r\n".getBytes())), "first part \u00f2\u00e0\u00f9".getBytes()));
        mm.addBodyPart((BodyPart)new MimeBodyPart(new InternetHeaders((InputStream)new ByteArrayInputStream("X-header: test2\r\nContent-Type: text/plain; charset=Cp1252\r\nContent-Transfer-Encoding: quoted-printable\r\n".getBytes())), "second part =E8=E8".getBytes()));
        mmCreated.setContent((Multipart)mm);
        mmCreated.saveChanges();
        return mmCreated;
    }

    protected String getMultipartMessageSource() {
        return "Date: Tue, 16 Jan 2018 09:56:01 +0700 (ICT)\r\nSubject: test\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative; \r\n\tboundary=\"----=_Part_0_XXXXXXXXXXX.XXXXXXXXXXX\"\r\n\r\n------=_Part_0_XXXXXXXXXXX.XXXXXXXXXXX\r\nX-header: test1\r\nContent-Type: text/plain; charset=Cp1252\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\nfirst part =E8\r\n------=_Part_0_XXXXXXXXXXX.XXXXXXXXXXX\r\nX-header: test2\r\nContent-Type: text/plain; charset=Cp1252\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\nsecond part =E8=E8\r\n------=_Part_0_XXXXXXXXXXX.XXXXXXXXXXX--\r\n";
    }

    protected String getMultipartMessageExpected1() {
        return "Subject: test\r\nMIME-Version: 1.0\r\nDate: Tue, 16 Jan 2018 09:56:01 +0700 (ICT)\r\nContent-Type: multipart/alternative; \r\n\tboundary=\"----=_Part_0_XXXXXXXXXXX.XXXXXXXXXXX\"\r\n\r\n------=_Part_0_XXXXXXXXXXX.XXXXXXXXXXX\r\nX-header: test1\r\nContent-Type: text/plain; charset=Cp1252\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\ntest=80\r\n------=_Part_0_XXXXXXXXXXX.XXXXXXXXXXX\r\nX-header: test2\r\nContent-Type: text/plain; charset=Cp1252\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\nsecond part =E8=E8\r\n------=_Part_0_XXXXXXXXXXX.XXXXXXXXXXX--\r\n";
    }

    protected String getMultipartMessageExpected2() {
        return "Subject: test\r\nMIME-Version: 1.0\r\nDate: Tue, 16 Jan 2018 09:56:01 +0700 (ICT)\r\nContent-Type: multipart/alternative; \r\n\tboundary=\"----=_Part_0_XXXXXXXXXXX.XXXXXXXXXXX\"\r\n\r\n------=_Part_0_XXXXXXXXXXX.XXXXXXXXXXX\r\nX-header: test1\r\nContent-Type: text/plain; charset=Cp1252\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\ntest=80\r\n------=_Part_0_XXXXXXXXXXX.XXXXXXXXXXX\r\nX-header: test2\r\nContent-Type: text/plain; charset=Cp1252\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\nsecond part =E8=E8\r\n------=_Part_0_XXXXXXXXXXX.XXXXXXXXXXX\r\nSubject: test3\r\n\r\nthird part\r\n------=_Part_0_XXXXXXXXXXX.XXXXXXXXXXX--\r\n";
    }

    protected String getMultipartMessageExpected3() {
        return "Subject: test\r\nMIME-Version: 1.0\r\nDate: Tue, 16 Jan 2018 09:56:01 +0700 (ICT)\r\nContent-Type: binary/octet-stream\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\nmynewco=F2=E0=F9ntent=80=E0!";
    }

    @Test
    public void testMultipartMessageChanges() throws Exception {
        MimeMessage mm = this.getMultipartMessage();
        MimeMultipart content1 = (MimeMultipart)mm.getContent();
        BodyPart b1 = content1.getBodyPart(0);
        b1.setContent((Object)"test\u20ac", "text/plain; charset=Cp1252");
        mm.setContent((Object)content1, mm.getContentType());
        mm.saveChanges();
        Assertions.assertThat((String)this.getCleanedMessageSource(mm)).isEqualTo(this.getMultipartMessageExpected1());
        MimeMultipart content2 = (MimeMultipart)mm.getContent();
        content2.addBodyPart((BodyPart)new MimeBodyPart(new InternetHeaders((InputStream)new ByteArrayInputStream("Subject: test3\r\n".getBytes())), "third part".getBytes()));
        mm.setContent((Object)content2, mm.getContentType());
        mm.saveChanges();
        Assertions.assertThat((String)this.getCleanedMessageSource(mm)).isEqualTo(this.getMultipartMessageExpected2());
        mm.setContent((Object)"mynewco\u00f2\u00e0\u00f9ntent\u20ac\u00e0!", "text/plain; charset=cp1252");
        mm.setHeader("Content-Type", "binary/octet-stream");
        mm.saveChanges();
        Assertions.assertThat((String)this.getCleanedMessageSource(mm)).isEqualTo(this.getMultipartMessageExpected3());
        LifecycleUtil.dispose((Object)mm);
    }

    protected String getMissingEncodingAddHeaderSource() {
        return "Subject: test\r\n\r\nTest\u00e0\r\n";
    }

    protected String getCleanedMessageSource(MimeMessage mm) throws Exception {
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        mm.writeTo((OutputStream)out2, new String[]{"Message-ID"});
        String res = out2.toString();
        int p = res.indexOf("\r\n\r\n");
        if (p > 0) {
            String head = res.substring(0, p);
            Object[] str = head.split("\r\n");
            Arrays.sort(str);
            StringBuilder outputHead = new StringBuilder();
            for (int i = str.length - 1; i >= 0; --i) {
                outputHead.append((String)str[i]);
                outputHead.append("\r\n");
            }
            outputHead.append(res.substring(p + 2));
            res = outputHead.toString();
        }
        res = res.replaceAll("----=_Part_\\d*_\\d+\\.\\d+", "----=_Part_\\0_XXXXXXXXXXX.XXXXXXXXXXX");
        return res;
    }

    protected MimeMessage getMissingEncodingMessage() throws Exception {
        MimeMessage mmCreated = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        mmCreated.setSubject("test");
        MimeMultipart mm = new MimeMultipart("alternative");
        mm.addBodyPart((BodyPart)new MimeBodyPart(new InternetHeaders((InputStream)new ByteArrayInputStream("X-header: test2\r\nContent-Type: text/plain; charset=Cp1252\r\nContent-Transfer-Encoding: quoted-printable\r\n".getBytes())), "second part =E8=E8".getBytes()));
        mmCreated.setContent((Multipart)mm);
        mmCreated.saveChanges();
        return mmCreated;
    }

    protected String getMissingEncodingMessageSource() {
        return "Subject: test\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative; \r\n\tboundary=\"----=_Part_0_XXXXXXXXXXX.XXXXXXXXXXX\"\r\n\r\n------=_Part_0_XXXXXXXXXXX.XXXXXXXXXXX\r\nX-header: test2\r\nContent-Type: text/plain; charset=Cp1252\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\nsecond part =E8=E8\r\n------=_Part_0_XXXXXXXXXXX.XXXXXXXXXXX--\r\n";
    }

    @Test
    public void testGetLineCount() throws Exception {
        MimeMessage mm = this.getMissingEncodingMessage();
        try {
            int count = mm.getLineCount();
            Assertions.assertThat((count == -1 || count == 7 ? 1 : 0) != 0).isTrue();
        }
        catch (Exception e) {
            Fail.fail((String)"Unexpected exception in getLineCount");
        }
        LifecycleUtil.dispose((Object)mm);
    }

    @Test
    public void testReturnPath() throws Exception {
        MimeMessage message = this.getSimpleMessage();
        Assertions.assertThat((Object[])message.getHeader("Return-Path")).isNull();
        LifecycleUtil.dispose((Object)message);
    }

    @Test
    public void testHeaderOrder() throws Exception {
        MimeMessage message = this.getSimpleMessage();
        message.setHeader("Return-Path", "<test@test.de>");
        Enumeration h = message.getAllHeaderLines();
        Assertions.assertThat((String)"Return-Path: <test@test.de>").isEqualTo((String)h.nextElement());
        LifecycleUtil.dispose((Object)message);
    }

    @Test
    public void testGeronimoIndexOutOfBounds() throws Exception {
        String message = "                  \r\nSubject: test\r\n\r\nBody\r\n";
        byte[] messageBytes = message.getBytes(StandardCharsets.US_ASCII);
        new MimeMessage(null, (InputStream)new ByteArrayInputStream(messageBytes));
    }
}

