/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.server.core.MimeMessageInputStreamSource;
import org.apache.james.util.io.ZeroedInputStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class MimeMessageInputStreamSourceTest {
    private static final int _1M = 0x100000;
    private static final int _10KB = 10240;
    private MimeMessageInputStreamSource testee;

    @AfterEach
    public void tearDown() {
        this.testee.dispose();
    }

    @Test
    public void streamWith1MBytesShouldBeReadable() throws MessagingException, IOException {
        this.testee = MimeMessageInputStreamSource.create((String)"myKey", (InputStream)new ZeroedInputStream(0x100000));
        Assertions.assertThat((InputStream)this.testee.getInputStream()).hasSameContentAs((InputStream)new ZeroedInputStream(0x100000));
    }

    @Test
    public void streamWith10KBytesShouldBeReadable() throws MessagingException, IOException {
        this.testee = MimeMessageInputStreamSource.create((String)"myKey", (InputStream)new ZeroedInputStream(10240));
        Assertions.assertThat((InputStream)this.testee.getInputStream()).hasSameContentAs((InputStream)new ZeroedInputStream(10240));
    }

    @Test
    public void streamWithVeryShortNameShouldWork() throws MessagingException, IOException {
        String veryShortName = "1";
        this.testee = MimeMessageInputStreamSource.create((String)veryShortName, (InputStream)new ZeroedInputStream(0x100000));
        Assertions.assertThat((InputStream)this.testee.getInputStream()).isNotNull();
    }
}

