/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BinaryOperator;
import java.util.stream.IntStream;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.server.core.MailImpl;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.ContractMailTest;
import org.apache.mailet.DsnParameters;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.MailUtil;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MailImplTest
extends ContractMailTest {
    private MimeMessage emptyMessage;

    public MailImpl newMail() {
        return MailImpl.builder().name("mail-id").build();
    }

    @BeforeEach
    void setup() throws Exception {
        this.emptyMessage = MimeMessageBuilder.mimeMessageBuilder().setText("").build();
    }

    @Test
    void mailImplShouldHaveSensibleInitialValues() throws Exception {
        MailImpl mail = this.newMail();
        Assertions.assertThat((String)mail.getName()).isEqualTo("mail-id");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)mail.hasAttributes()).describedAs("no initial attributes", new Object[0])).isFalse();
        ((AbstractStringAssert)Assertions.assertThat((String)mail.getErrorMessage()).describedAs("no initial error", new Object[0])).isNull();
        Assertions.assertThat((Date)mail.getLastUpdated()).isCloseTo(new Date(), TimeUnit.SECONDS.toMillis(2L));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)mail.getRecipients()).describedAs("no initial recipient", new Object[0])).isNullOrEmpty();
        ((AbstractStringAssert)Assertions.assertThat((String)mail.getRemoteAddr()).describedAs("initial remote address is localhost ip", new Object[0])).isEqualTo("127.0.0.1");
        ((AbstractStringAssert)Assertions.assertThat((String)mail.getRemoteHost()).describedAs("initial remote host is localhost", new Object[0])).isEqualTo("localhost");
        ((AbstractStringAssert)Assertions.assertThat((String)mail.getState()).describedAs("default initial state", new Object[0])).isEqualTo("root");
        Assertions.assertThat((Object)mail.getMessage()).isNull();
        Assertions.assertThat((Object)mail.getMaybeSender()).isEqualTo((Object)MaybeSender.nullSender());
    }

    @Test
    void mailImplShouldThrowWhenComputingSizeOnDefaultInstance() {
        MailImpl mail = this.newMail();
        Assertions.assertThatThrownBy(() -> ((MailImpl)mail).getMessageSize()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void mailImplConstructionShouldSetDefaultValuesOnUnspecifiedFields() throws Exception {
        MailImpl mail = MailImpl.builder().name(MailUtil.newId()).sender("sender@localhost").build();
        MailImpl expected = this.newMail();
        Assertions.assertThat((Object)mail).usingRecursiveComparison().ignoringFields(new String[]{"sender", "name", "recipients", "lastUpdated"}).isEqualTo((Object)expected);
        Assertions.assertThat((Date)mail.getLastUpdated()).isCloseTo(new Date(), TimeUnit.SECONDS.toMillis(2L));
    }

    @Test
    void mailImplConstructionShouldSetSpecifiedFields() throws Exception {
        String sender = "sender@localhost";
        String name = MailUtil.newId();
        MailImpl mail = MailImpl.builder().name(name).sender(sender).build();
        Assertions.assertThat((String)mail.getMaybeSender().get().asString()).isEqualTo(sender);
        Assertions.assertThat((String)mail.getName()).isEqualTo(name);
    }

    @Test
    void mailImplConstructionWithMimeMessageShouldSetSpecifiedFields() throws Exception {
        String name = MailUtil.newId();
        String sender = "sender@localhost";
        MailImpl expected = MailImpl.builder().name(name).sender(sender).build();
        MailImpl mail = MailImpl.builder().name(name).sender(sender).mimeMessage(this.emptyMessage).build();
        Assertions.assertThat((Object)mail).usingRecursiveComparison().ignoringFields(new String[]{"message", "lastUpdated"}).isEqualTo((Object)expected);
        Assertions.assertThat((Date)mail.getLastUpdated()).isCloseTo(new Date(), TimeUnit.SECONDS.toMillis(2L));
    }

    @Test
    void mailImplConstructionWithMimeMessageShouldNotOverwriteMessageId() throws Exception {
        MailImpl mail = MailImpl.builder().name(MailUtil.newId()).sender("sender@localhost").mimeMessage(this.emptyMessage).build();
        Assertions.assertThat((String)mail.getMessage().getMessageID()).isEqualTo(this.emptyMessage.getMessageID());
    }

    @Test
    void duplicateFactoryMethodShouldGenerateNewObjectWithSameValuesButName() throws Exception {
        String name = MailUtil.newId();
        PerRecipientHeaders perRecipientSpecificHeaders = new PerRecipientHeaders();
        PerRecipientHeaders.Header perRecipientHeader = PerRecipientHeaders.Header.builder().name("a").value("b").build();
        perRecipientSpecificHeaders.addHeaderForRecipient(perRecipientHeader, new MailAddress("a@b.c"));
        MailImpl mail = MailImpl.builder().name(name).sender("sender@localhost").mimeMessage(this.emptyMessage).addAllHeadersForRecipients(perRecipientSpecificHeaders).build();
        MailImpl duplicate = MailImpl.duplicate((Mail)mail);
        ((ObjectAssert)Assertions.assertThat((Object)duplicate).isNotSameAs((Object)mail)).usingRecursiveComparison().ignoringFields(new String[]{"message", "name"}).isEqualTo((Object)mail);
        Assertions.assertThat((String)duplicate.getName()).isNotEqualTo((Object)name);
        Assertions.assertThat((InputStream)duplicate.getMessage().getInputStream()).hasSameContentAs(mail.getMessage().getInputStream());
        Assertions.assertThat((Object)mail.getPerRecipientSpecificHeaders()).isEqualTo((Object)duplicate.getPerRecipientSpecificHeaders());
    }

    @Test
    void setAttributeShouldThrowOnNullAttributeName() {
        MailImpl mail = this.newMail();
        Assertions.assertThatThrownBy(() -> mail.setAttribute(null, (Serializable)((Object)"toto"))).isInstanceOf(NullPointerException.class);
    }

    @Test
    void deriveNewNameShouldThrowOnNull() {
        Assertions.assertThatThrownBy(() -> MailImpl.deriveNewName(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void deriveNewNameShouldGenerateNonEmptyStringOnEmpty() throws Exception {
        Assertions.assertThat((String)MailImpl.deriveNewName((String)"")).isNotEmpty();
    }

    @Test
    void deriveNewNameShouldNeverGenerateMoreThan86Characters() throws Exception {
        String longString = "mu1Eeseemu1Eeseemu1Eeseemu1Eeseemu1Eeseemu1Eeseemu1Eeseemu1Eeseemu1Eeseeseemu1Eesee";
        Assertions.assertThat((int)MailImpl.deriveNewName((String)longString).length()).isLessThan(86);
    }

    @Test
    void deriveNewNameShouldThrowWhenMoreThan8NestedCalls() {
        String called6Times = IntStream.range(0, 8).mapToObj(String::valueOf).reduce("average value ", (BinaryOperator<String>)Throwing.binaryOperator((left, right) -> MailImpl.deriveNewName((String)left)));
        Assertions.assertThatThrownBy(() -> MailImpl.deriveNewName((String)called6Times)).isInstanceOf(MessagingException.class);
    }

    @Test
    void deriveNewNameShouldThrowWhenMoreThan8NestedCallsAndSmallInitialValue() {
        String called6Times = IntStream.range(0, 8).mapToObj(String::valueOf).reduce("small", (BinaryOperator<String>)Throwing.binaryOperator((left, right) -> MailImpl.deriveNewName((String)left)));
        Assertions.assertThatThrownBy(() -> MailImpl.deriveNewName((String)called6Times)).isInstanceOf(MessagingException.class);
    }

    @Test
    void deriveNewNameShouldThrowWhenMoreThan8NestedCallsAndLongInitialValue() {
        String called6Times = IntStream.range(0, 8).mapToObj(String::valueOf).reduce("looooooonnnnnngggggggggggggggg", (BinaryOperator<String>)Throwing.binaryOperator((left, right) -> MailImpl.deriveNewName((String)left)));
        Assertions.assertThatThrownBy(() -> MailImpl.deriveNewName((String)called6Times)).isInstanceOf(MessagingException.class);
    }

    @Test
    void deriveNewNameShouldGenerateNotEqualsCurrentName() throws Exception {
        Assertions.assertThat((String)MailImpl.deriveNewName((String)"current")).isNotEqualTo((Object)"current");
    }

    @Test
    void getMaybeSenderShouldHandleNullSender() {
        Assertions.assertThat((Object)MailImpl.builder().name("mail-id").sender(MailAddress.nullSender()).build().getMaybeSender()).isEqualTo((Object)MaybeSender.nullSender());
    }

    @Test
    void getMaybeSenderShouldHandleNoSender() {
        Assertions.assertThat((Object)MailImpl.builder().name("mail-id").build().getMaybeSender()).isEqualTo((Object)MaybeSender.nullSender());
    }

    @Test
    void getMaybeSenderShouldHandleSender() {
        Assertions.assertThat((Object)MailImpl.builder().name("mail-id").sender(MailAddressFixture.SENDER).build().getMaybeSender()).isEqualTo((Object)MaybeSender.of((MailAddress)MailAddressFixture.SENDER));
    }

    @Test
    void hasSenderShouldReturnFalseWhenSenderIsNull() {
        Assertions.assertThat((boolean)MailImpl.builder().name("mail-id").sender(MailAddress.nullSender()).build().hasSender()).isFalse();
    }

    @Test
    void hasSenderShouldReturnFalseWhenSenderIsNotSpecified() {
        Assertions.assertThat((boolean)MailImpl.builder().name("mail-id").build().hasSender()).isFalse();
    }

    @Test
    void hasSenderShouldReturnTrueWhenSenderIsSpecified() {
        Assertions.assertThat((boolean)MailImpl.builder().name("mail-id").sender(MailAddressFixture.SENDER).build().hasSender()).isTrue();
    }

    @Test
    void builderShouldNotAllowNullName() {
        Assertions.assertThatThrownBy(() -> MailImpl.builder().name(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void builderShouldNotAllowEmptyName() {
        Assertions.assertThatThrownBy(() -> MailImpl.builder().name("")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void mailImplShouldNotAllowSettingNullName() {
        Assertions.assertThatThrownBy(() -> this.newMail().setName(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void mailImplShouldNotAllowSettingEmptyName() {
        Assertions.assertThatThrownBy(() -> this.newMail().setName("")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void mailImplShouldBeSerializable() throws Exception {
        MailImpl mail = MailImpl.builder().name("mail-id").sender(MailAddress.nullSender()).build();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(mail);
        objectOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object unserialized = objectInputStream.readObject();
        ((ObjectAssert)Assertions.assertThat((Object)unserialized).isInstanceOf(MailImpl.class)).usingRecursiveComparison().isEqualTo((Object)mail);
    }

    @Test
    void mailImplShouldBeSerializableWithOptionalAttribute() throws Exception {
        MailImpl mail = MailImpl.builder().name("mail-id").sender(MailAddress.nullSender()).addAttribute(AttributeName.of((String)"name").withValue(AttributeValue.of(Optional.empty()))).build();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(mail);
        objectOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object unserialized = objectInputStream.readObject();
        ((ObjectAssert)Assertions.assertThat((Object)unserialized).isInstanceOf(MailImpl.class)).usingRecursiveComparison().isEqualTo((Object)mail);
    }

    @Test
    void mailImplShouldBeSerializableWithCollectionAttribute() throws Exception {
        MailImpl mail = MailImpl.builder().name("mail-id").sender(MailAddress.nullSender()).addAttribute(AttributeName.of((String)"name").withValue(AttributeValue.of((Collection)ImmutableList.of((Object)AttributeValue.of((String)"a"))))).build();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(mail);
        objectOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object unserialized = objectInputStream.readObject();
        ((ObjectAssert)Assertions.assertThat((Object)unserialized).isInstanceOf(MailImpl.class)).usingRecursiveComparison().isEqualTo((Object)mail);
    }

    @Test
    void mailShouldPreserveDsnParameters() throws Exception {
        DsnParameters dsnParameters = (DsnParameters)DsnParameters.builder().envId(DsnParameters.EnvId.of((String)"434554-55445-33443")).ret(DsnParameters.Ret.FULL).addRcptParameter(new MailAddress("bob@apache.org"), DsnParameters.RecipientDsnParameters.of((MailAddress)new MailAddress("andy@apache.org"))).addRcptParameter(new MailAddress("cedric@apache.org"), DsnParameters.RecipientDsnParameters.of(EnumSet.of(DsnParameters.Notify.SUCCESS))).addRcptParameter(new MailAddress("domi@apache.org"), DsnParameters.RecipientDsnParameters.of(EnumSet.of(DsnParameters.Notify.FAILURE), (MailAddress)new MailAddress("eric@apache.org"))).build().get();
        MailImpl mail = MailImpl.builder().name("mail-id").build();
        mail.setDsnParameters(dsnParameters);
        Assertions.assertThat((Optional)mail.dsnParameters()).contains((Object)dsnParameters);
    }

    @Test
    void setDsnParametersShouldUpdateStoredValue() throws Exception {
        DsnParameters dsnParameters1 = (DsnParameters)DsnParameters.builder().envId(DsnParameters.EnvId.of((String)"434554-55445-33443")).ret(DsnParameters.Ret.FULL).addRcptParameter(new MailAddress("bob@apache.org"), DsnParameters.RecipientDsnParameters.of((MailAddress)new MailAddress("andy@apache.org"))).addRcptParameter(new MailAddress("cedric@apache.org"), DsnParameters.RecipientDsnParameters.of(EnumSet.of(DsnParameters.Notify.SUCCESS))).addRcptParameter(new MailAddress("domi@apache.org"), DsnParameters.RecipientDsnParameters.of(EnumSet.of(DsnParameters.Notify.FAILURE), (MailAddress)new MailAddress("eric@apache.org"))).build().get();
        DsnParameters dsnParameters2 = (DsnParameters)DsnParameters.builder().envId(DsnParameters.EnvId.of((String)"434554-55445-33434ee4")).addRcptParameter(new MailAddress("domi@apache.org"), DsnParameters.RecipientDsnParameters.of(EnumSet.of(DsnParameters.Notify.FAILURE), (MailAddress)new MailAddress("eric@apache.org"))).build().get();
        MailImpl mail = MailImpl.builder().name("mail-id").build();
        mail.setDsnParameters(dsnParameters1);
        mail.setDsnParameters(dsnParameters2);
        Assertions.assertThat((Optional)mail.dsnParameters()).contains((Object)dsnParameters2);
    }

    @Test
    void dsnParametersShouldBeEmptyByDefault() {
        MailImpl mail = MailImpl.builder().name("mail-id").build();
        Assertions.assertThat((Optional)mail.dsnParameters()).isEmpty();
    }
}

