/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import jakarta.mail.MessagingException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.james.server.core.MailHeaders;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class MailHeadersTest {
    @Test
    public void testHeadersOrder() throws MessagingException {
        MailHeaders header = new MailHeaders((InputStream)new ByteArrayInputStream("Subject: testsubject\r\n".getBytes()));
        header.setHeader("Return-Path", "<test@test>");
        header.setHeader("From", "<test2@test.de>");
        Enumeration h = header.getAllHeaderLines();
        Assertions.assertThat((String)"Return-Path: <test@test>").isEqualTo((String)h.nextElement());
        Assertions.assertThat((String)"From: <test2@test.de>").isEqualTo((String)h.nextElement());
        Assertions.assertThat((String)"Subject: testsubject").isEqualTo((String)h.nextElement());
    }
}

