/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.server.core.Envelope;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class EnvelopeTest {
    EnvelopeTest() {
    }

    @Test
    void fromMime4JMessageShouldParseAllHeaders() throws Exception {
        Message message = this.toMime4JMessage("From: bob@domain\r\nTo: alice@domain, cedric@domain\r\nCc: dave@domain\r\nBcc: edgard@domain\r\n");
        Envelope envelope = Envelope.fromMime4JMessage((Message)message);
        Assertions.assertThat((Object)envelope).isEqualTo((Object)new Envelope(MaybeSender.of((MailAddress)new MailAddress("bob@domain")), (Set)ImmutableSet.of((Object)new MailAddress("alice@domain"), (Object)new MailAddress("cedric@domain"), (Object)new MailAddress("dave@domain"), (Object)new MailAddress("edgard@domain"))));
    }

    @Test
    void fromMime4JMessageShouldParseFoldedHeaders() throws Exception {
        Message message = this.toMime4JMessage("From: bob@domain\r\nTo: alice@domain,\r\n cedric@domain\r\nCc: dave@domain\r\nBcc: edgard@domain\r\n");
        Envelope envelope = Envelope.fromMime4JMessage((Message)message);
        Assertions.assertThat((Object)envelope).isEqualTo((Object)new Envelope(MaybeSender.of((MailAddress)new MailAddress("bob@domain")), (Set)ImmutableSet.of((Object)new MailAddress("alice@domain"), (Object)new MailAddress("cedric@domain"), (Object)new MailAddress("dave@domain"), (Object)new MailAddress("edgard@domain"))));
    }

    @Test
    void fromMime4JMessageShouldParseMailboxAddresses() throws Exception {
        Message message = this.toMime4JMessage("From: bob@domain\r\nTo: alice@domain, \"CEDRIC\" <cedric@domain>\r\nCc: dave@domain\r\nBcc: edgard@domain\r\n");
        Envelope envelope = Envelope.fromMime4JMessage((Message)message);
        Assertions.assertThat((Object)envelope).isEqualTo((Object)new Envelope(MaybeSender.of((MailAddress)new MailAddress("bob@domain")), (Set)ImmutableSet.of((Object)new MailAddress("alice@domain"), (Object)new MailAddress("cedric@domain"), (Object)new MailAddress("dave@domain"), (Object)new MailAddress("edgard@domain"))));
    }

    @Test
    void fromMime4JMessageShouldParseEncodedMailboxAddresses() throws Exception {
        Message message = this.toMime4JMessage("From: bob@domain\r\nTo: alice@domain, =?UTF-8?B?RnLDqWTDqXJpYyBNQVJUSU4=?= <cedric@domain>\r\nCc: dave@domain\r\nBcc: edgard@domain\r\n");
        Envelope envelope = Envelope.fromMime4JMessage((Message)message);
        Assertions.assertThat((Object)envelope).isEqualTo((Object)new Envelope(MaybeSender.of((MailAddress)new MailAddress("bob@domain")), (Set)ImmutableSet.of((Object)new MailAddress("alice@domain"), (Object)new MailAddress("cedric@domain"), (Object)new MailAddress("dave@domain"), (Object)new MailAddress("edgard@domain"))));
    }

    @Test
    void fromMime4JMessageShouldParseMailboxAddressesWithoutName() throws Exception {
        Message message = this.toMime4JMessage("From: bob@domain\r\nTo: alice@domain, <cedric@domain>\r\nCc: dave@domain\r\nBcc: edgard@domain\r\n");
        Envelope envelope = Envelope.fromMime4JMessage((Message)message);
        Assertions.assertThat((Object)envelope).isEqualTo((Object)new Envelope(MaybeSender.of((MailAddress)new MailAddress("bob@domain")), (Set)ImmutableSet.of((Object)new MailAddress("alice@domain"), (Object)new MailAddress("cedric@domain"), (Object)new MailAddress("dave@domain"), (Object)new MailAddress("edgard@domain"))));
    }

    @Test
    void fromMime4JMessageShouldNotThrowOnNullSender() throws Exception {
        Message message = this.toMime4JMessage("From: <>\r\nTo: alice@domain, cedric@domain\r\nCc: dave@domain\r\nBcc: edgard@domain\r\n");
        Envelope envelope = Envelope.fromMime4JMessage((Message)message);
        Assertions.assertThat((Object)envelope).isEqualTo((Object)new Envelope(MaybeSender.nullSender(), (Set)ImmutableSet.of((Object)new MailAddress("alice@domain"), (Object)new MailAddress("cedric@domain"), (Object)new MailAddress("dave@domain"), (Object)new MailAddress("edgard@domain"))));
    }

    @Test
    void fromMime4JMessageShouldNotThrowOnMissingFromHeader() throws Exception {
        Message message = this.toMime4JMessage("To: alice@domain, cedric@domain\r\nCc: dave@domain\r\nBcc: edgard@domain\r\n");
        Envelope envelope = Envelope.fromMime4JMessage((Message)message);
        Assertions.assertThat((Object)envelope).isEqualTo((Object)new Envelope(MaybeSender.nullSender(), (Set)ImmutableSet.of((Object)new MailAddress("alice@domain"), (Object)new MailAddress("cedric@domain"), (Object)new MailAddress("dave@domain"), (Object)new MailAddress("edgard@domain"))));
    }

    @Test
    void fromMime4JMessageShouldPreserveValidEnvelopeWhenIgnore() throws Exception {
        Message message = this.toMime4JMessage("From: bob@domain\r\nTo: alice@domain, bad@bad@domain\r\nCc: dave@domain\r\nBcc: edgard@domain\r\n");
        Envelope envelope = Envelope.fromMime4JMessage((Message)message, (Envelope.ValidationPolicy)Envelope.ValidationPolicy.IGNORE);
        Assertions.assertThat((Object)envelope).isEqualTo((Object)new Envelope(MaybeSender.of((MailAddress)new MailAddress("bob@domain")), (Set)ImmutableSet.of((Object)new MailAddress("alice@domain"), (Object)new MailAddress("dave@domain"), (Object)new MailAddress("edgard@domain"))));
    }

    @Test
    void fromMime4JMessageShouldThrowWhenThrowingValidationPolicyAndInvalidAddress() throws Exception {
        Message message = this.toMime4JMessage("From: bob@domain\r\nTo: alice@domain, bad@bad@domain\r\nCc: dave@domain\r\nBcc: edgard@domain\r\n");
        Assertions.assertThatThrownBy(() -> Envelope.fromMime4JMessage((Message)message, (Envelope.ValidationPolicy)Envelope.ValidationPolicy.THROW)).isInstanceOf(RuntimeException.class);
    }

    @Test
    void fromMime4JMessageShouldNotThrowOnMissingBccHeader() throws Exception {
        Message message = this.toMime4JMessage("From: bob@domain\r\nTo: alice@domain, cedric@domain\r\nCc: dave@domain\r\n");
        Envelope envelope = Envelope.fromMime4JMessage((Message)message);
        Assertions.assertThat((Object)envelope).isEqualTo((Object)new Envelope(MaybeSender.of((MailAddress)new MailAddress("bob@domain")), (Set)ImmutableSet.of((Object)new MailAddress("alice@domain"), (Object)new MailAddress("cedric@domain"), (Object)new MailAddress("dave@domain"))));
    }

    @Test
    void fromMime4JMessageShouldNotThrowOnMissingCcHeader() throws Exception {
        Message message = this.toMime4JMessage("From: bob@domain\r\nTo: alice@domain, cedric@domain\r\nBcc: edgard@domain\r\n");
        Envelope envelope = Envelope.fromMime4JMessage((Message)message);
        Assertions.assertThat((Object)envelope).isEqualTo((Object)new Envelope(MaybeSender.of((MailAddress)new MailAddress("bob@domain")), (Set)ImmutableSet.of((Object)new MailAddress("alice@domain"), (Object)new MailAddress("cedric@domain"), (Object)new MailAddress("edgard@domain"))));
    }

    @Test
    void fromMime4JMessageShouldNotThrowOnMissingToHeader() throws Exception {
        Message message = this.toMime4JMessage("From: bob@domain\r\nCc: dave@domain\r\nBcc: edgard@domain\r\n");
        Envelope envelope = Envelope.fromMime4JMessage((Message)message);
        Assertions.assertThat((Object)envelope).isEqualTo((Object)new Envelope(MaybeSender.of((MailAddress)new MailAddress("bob@domain")), (Set)ImmutableSet.of((Object)new MailAddress("dave@domain"), (Object)new MailAddress("edgard@domain"))));
    }

    private Message toMime4JMessage(String messageAsString) throws IOException {
        DefaultMessageBuilder defaultMessageBuilder = new DefaultMessageBuilder();
        defaultMessageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
        defaultMessageBuilder.setDecodeMonitor(DecodeMonitor.SILENT);
        return defaultMessageBuilder.parseMessage((InputStream)new ByteArrayInputStream(messageAsString.getBytes(StandardCharsets.UTF_8)));
    }
}

