/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import org.apache.james.server.core.ContentTypeCleaner;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ContentTypeCleanerTest {
    @Test
    void nullContentTypeShouldReturnNull() {
        Assertions.assertThat((String)ContentTypeCleaner.cleanContentType(null, null)).isNull();
    }

    @Test
    void emptyContentTypeShouldReturnNull() {
        Assertions.assertThat((String)ContentTypeCleaner.cleanContentType(null, (String)"")).isNull();
    }

    @Test
    void invalidContentTypeShouldReturnNull() {
        Assertions.assertThat((String)ContentTypeCleaner.cleanContentType(null, (String)"I'mNotValid")).isNull();
    }

    @Test
    void validContentTypeShouldReturnTheRawInput() {
        String contentType = "application/pdf";
        Assertions.assertThat((String)ContentTypeCleaner.cleanContentType(null, (String)contentType)).isEqualTo(contentType);
    }

    @Test
    void shouldSupportParameters() {
        String contentType = "application/pdf; filename=\"abc.pdf\"";
        Assertions.assertThat((String)ContentTypeCleaner.cleanContentType(null, (String)contentType)).isEqualTo(contentType);
    }
}

