/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.modules;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableWithOptions;
import com.datastax.oss.driver.api.querybuilder.schema.compaction.CompactionStrategy;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.mailbox.cassandra.table.CassandraMessageIdTable;
import org.apache.james.mailbox.cassandra.table.CassandraMessageIds;
import org.apache.james.mailbox.cassandra.table.CassandraMessageV3Table;
import org.apache.james.mailbox.cassandra.table.Flag;
import org.apache.james.mailbox.cassandra.table.MessageIdToImapUid;

public interface CassandraMessageModule {
    public static final int CACHED_MESSAGE_ID_ROWS = 1000;
    public static final int CACHED_IMAP_UID_ROWS = 100;
    public static final CassandraModule MODULE = CassandraModule.builder().table("messageIdTable").comment("Holds mailbox and flags for each message, lookup by mailbox ID + UID").options(options -> (CreateTableWithOptions)((CreateTableWithOptions)options.withCompaction((CompactionStrategy)SchemaBuilder.sizeTieredCompactionStrategy())).withCaching(true, SchemaBuilder.RowsPerPartition.rows((int)1000))).statement(statement -> types -> statement.withPartitionKey(CassandraMessageIds.MAILBOX_ID, DataTypes.TIMEUUID).withClusteringColumn(CassandraMessageIds.IMAP_UID, DataTypes.BIGINT).withColumn(CassandraMessageIds.MESSAGE_ID, DataTypes.TIMEUUID).withColumn(CassandraMessageIdTable.THREAD_ID, DataTypes.TIMEUUID).withColumn(CassandraMessageIdTable.MOD_SEQ, DataTypes.BIGINT).withColumn(Flag.ANSWERED, DataTypes.BOOLEAN).withColumn(Flag.DELETED, DataTypes.BOOLEAN).withColumn(Flag.DRAFT, DataTypes.BOOLEAN).withColumn(Flag.FLAGGED, DataTypes.BOOLEAN).withColumn(Flag.RECENT, DataTypes.BOOLEAN).withColumn(Flag.SEEN, DataTypes.BOOLEAN).withColumn(Flag.USER, DataTypes.BOOLEAN).withColumn(Flag.USER_FLAGS, (DataType)DataTypes.setOf((DataType)DataTypes.TEXT)).withColumn(CassandraMessageV3Table.INTERNAL_DATE, DataTypes.TIMESTAMP).withColumn(CassandraMessageIdTable.SAVE_DATE, DataTypes.TIMESTAMP).withColumn(CassandraMessageV3Table.BODY_START_OCTET, DataTypes.INT).withColumn(CassandraMessageV3Table.FULL_CONTENT_OCTETS, DataTypes.BIGINT).withColumn(CassandraMessageV3Table.HEADER_CONTENT, DataTypes.TEXT)).table("imapUidTable").comment("Holds mailbox and flags for each message, lookup by message ID").options(options -> (CreateTableWithOptions)((CreateTableWithOptions)((CreateTableWithOptions)options.withCompaction((CompactionStrategy)SchemaBuilder.sizeTieredCompactionStrategy())).withLZ4Compression(8, 1.0)).withCaching(true, SchemaBuilder.RowsPerPartition.rows((int)100))).statement(statement -> types -> statement.withPartitionKey(CassandraMessageIds.MESSAGE_ID, DataTypes.TIMEUUID).withClusteringColumn(CassandraMessageIds.MAILBOX_ID, DataTypes.TIMEUUID).withClusteringColumn(CassandraMessageIds.IMAP_UID, DataTypes.BIGINT).withColumn(MessageIdToImapUid.THREAD_ID, DataTypes.TIMEUUID).withColumn(MessageIdToImapUid.MOD_SEQ, DataTypes.BIGINT).withColumn(Flag.ANSWERED, DataTypes.BOOLEAN).withColumn(Flag.DELETED, DataTypes.BOOLEAN).withColumn(Flag.DRAFT, DataTypes.BOOLEAN).withColumn(Flag.FLAGGED, DataTypes.BOOLEAN).withColumn(Flag.RECENT, DataTypes.BOOLEAN).withColumn(Flag.SEEN, DataTypes.BOOLEAN).withColumn(Flag.USER, DataTypes.BOOLEAN).withColumn(Flag.USER_FLAGS, (DataType)DataTypes.setOf((DataType)DataTypes.TEXT)).withColumn(CassandraMessageV3Table.INTERNAL_DATE, DataTypes.TIMESTAMP).withColumn(CassandraMessageIdTable.SAVE_DATE, DataTypes.TIMESTAMP).withColumn(CassandraMessageV3Table.BODY_START_OCTET, DataTypes.INT).withColumn(CassandraMessageV3Table.FULL_CONTENT_OCTETS, DataTypes.BIGINT).withColumn(CassandraMessageV3Table.HEADER_CONTENT, DataTypes.TEXT)).table("messageV3").comment("Holds message metadata, independently of any mailboxes. Content of messages is stored in `blobs` and `blobparts` tables. Optimizes property storage compared to V2.").statement(statement -> types -> statement.withPartitionKey(CassandraMessageIds.MESSAGE_ID, DataTypes.TIMEUUID).withColumn(CassandraMessageV3Table.INTERNAL_DATE, DataTypes.TIMESTAMP).withColumn(CassandraMessageV3Table.BODY_START_OCTET, DataTypes.INT).withColumn(CassandraMessageV3Table.BODY_OCTECTS, DataTypes.BIGINT).withColumn(CassandraMessageV3Table.TEXTUAL_LINE_COUNT, DataTypes.BIGINT).withColumn(CassandraMessageV3Table.FULL_CONTENT_OCTETS, DataTypes.BIGINT).withColumn(CassandraMessageV3Table.BODY_CONTENT, DataTypes.TEXT).withColumn(CassandraMessageV3Table.HEADER_CONTENT, DataTypes.TEXT).withColumn(CassandraMessageV3Table.Properties.CONTENT_DESCRIPTION, DataTypes.TEXT).withColumn(CassandraMessageV3Table.Properties.CONTENT_DISPOSITION_TYPE, DataTypes.TEXT).withColumn(CassandraMessageV3Table.Properties.MEDIA_TYPE, DataTypes.TEXT).withColumn(CassandraMessageV3Table.Properties.SUB_TYPE, DataTypes.TEXT).withColumn(CassandraMessageV3Table.Properties.CONTENT_ID, DataTypes.TEXT).withColumn(CassandraMessageV3Table.Properties.CONTENT_MD5, DataTypes.TEXT).withColumn(CassandraMessageV3Table.Properties.CONTENT_TRANSFER_ENCODING, DataTypes.TEXT).withColumn(CassandraMessageV3Table.Properties.CONTENT_LOCATION, DataTypes.TEXT).withColumn(CassandraMessageV3Table.Properties.CONTENT_LANGUAGE, (DataType)DataTypes.frozenListOf((DataType)DataTypes.TEXT)).withColumn(CassandraMessageV3Table.Properties.CONTENT_DISPOSITION_PARAMETERS, (DataType)DataTypes.frozenMapOf((DataType)DataTypes.TEXT, (DataType)DataTypes.TEXT)).withColumn(CassandraMessageV3Table.Properties.CONTENT_TYPE_PARAMETERS, (DataType)DataTypes.frozenMapOf((DataType)DataTypes.TEXT, (DataType)DataTypes.TEXT)).withColumn(CassandraMessageV3Table.ATTACHMENTS, (DataType)DataTypes.listOf((DataType)SchemaBuilder.udt((CqlIdentifier)CassandraMessageV3Table.ATTACHMENTS, (boolean)true)))).type(CassandraMessageV3Table.ATTACHMENTS.asCql(true)).statement(statement -> statement.withField(CassandraMessageV3Table.Attachments.ID, DataTypes.TEXT).withField(CassandraMessageV3Table.Attachments.NAME, DataTypes.TEXT).withField(CassandraMessageV3Table.Attachments.CID, DataTypes.TEXT).withField(CassandraMessageV3Table.Attachments.IS_INLINE, DataTypes.BOOLEAN)).build();
}

