/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.cassandra.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.eventstore.dto.EventDTO;
import org.apache.james.mailbox.quota.cassandra.dto.HistoryEvolutionDTO;
import org.apache.james.mailbox.quota.cassandra.dto.QuotaDTO;
import org.apache.james.mailbox.quota.mailing.aggregates.UserQuotaThresholds;
import org.apache.james.mailbox.quota.mailing.events.QuotaThresholdChangedEvent;

class QuotaThresholdChangedEventDTO
implements EventDTO {
    private final String type;
    private final int eventId;
    private final String aggregateId;
    private final QuotaDTO sizeQuota;
    private final QuotaDTO countQuota;
    private final HistoryEvolutionDTO sizeEvolution;
    private final HistoryEvolutionDTO countEvolution;

    @JsonIgnore
    public static QuotaThresholdChangedEventDTO from(QuotaThresholdChangedEvent event, String type) {
        return new QuotaThresholdChangedEventDTO(type, event.eventId().serialize(), event.getAggregateId().asAggregateKey(), QuotaDTO.from(event.getSizeQuota()), QuotaDTO.from(event.getCountQuota()), HistoryEvolutionDTO.toDto(event.getSizeHistoryEvolution()), HistoryEvolutionDTO.toDto(event.getCountHistoryEvolution()));
    }

    @JsonCreator
    private QuotaThresholdChangedEventDTO(@JsonProperty(value="type") String type, @JsonProperty(value="eventId") int eventId, @JsonProperty(value="aggregateId") String aggregateId, @JsonProperty(value="sizeQuota") QuotaDTO sizeQuota, @JsonProperty(value="countQuota") QuotaDTO countQuota, @JsonProperty(value="sizeEvolution") HistoryEvolutionDTO sizeEvolution, @JsonProperty(value="countEvolution") HistoryEvolutionDTO countEvolution) {
        this.type = type;
        this.eventId = eventId;
        this.aggregateId = aggregateId;
        this.sizeQuota = sizeQuota;
        this.countQuota = countQuota;
        this.sizeEvolution = sizeEvolution;
        this.countEvolution = countEvolution;
    }

    public String getType() {
        return this.type;
    }

    public long getEventId() {
        return this.eventId;
    }

    public String getAggregateId() {
        return this.aggregateId;
    }

    public QuotaDTO getSizeQuota() {
        return this.sizeQuota;
    }

    public QuotaDTO getCountQuota() {
        return this.countQuota;
    }

    public HistoryEvolutionDTO getSizeEvolution() {
        return this.sizeEvolution;
    }

    public HistoryEvolutionDTO getCountEvolution() {
        return this.countEvolution;
    }

    @JsonIgnore
    public QuotaThresholdChangedEvent toEvent() {
        return new QuotaThresholdChangedEvent(EventId.fromSerialized((int)this.eventId), this.sizeEvolution.toHistoryEvolution(), this.countEvolution.toHistoryEvolution(), this.sizeQuota.asSizeQuota(), this.countQuota.asCountQuota(), UserQuotaThresholds.Id.fromKey((String)this.aggregateId));
    }
}

