/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import jakarta.inject.Inject;
import java.time.Clock;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import org.apache.james.task.AsyncSafeTask;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.webadmin.service.ExpireMailboxService;
import org.reactivestreams.Publisher;

public class ExpireMailboxTask
implements AsyncSafeTask {
    public static final TaskType TASK_TYPE = TaskType.of((String)"ExpireMailboxTask");
    private final ExpireMailboxService expireMailboxService;
    private final ExpireMailboxService.Context context;
    private final ExpireMailboxService.RunningOptions runningOptions;

    @Inject
    public ExpireMailboxTask(ExpireMailboxService expireMailboxService, ExpireMailboxService.RunningOptions runningOptions) {
        this.expireMailboxService = expireMailboxService;
        this.context = new ExpireMailboxService.Context();
        this.runningOptions = runningOptions;
    }

    public Publisher<Task.Result> runAsync() {
        return this.expireMailboxService.expireMailboxes(this.context, this.runningOptions, new Date());
    }

    public TaskType type() {
        return TASK_TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(AdditionalInformation.from(this.context, this.runningOptions));
    }

    public ExpireMailboxService.RunningOptions getRunningOptions() {
        return this.runningOptions;
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Instant timestamp;
        private final ExpireMailboxService.RunningOptions runningOptions;
        private final long mailboxesExpired;
        private final long mailboxesFailed;
        private final long mailboxesProcessed;
        private final long messagesDeleted;

        public static AdditionalInformation from(ExpireMailboxService.Context context, ExpireMailboxService.RunningOptions runningOptions) {
            return new AdditionalInformation(Clock.systemUTC().instant(), runningOptions, context.getInboxesExpired(), context.getInboxesFailed(), context.getInboxesProcessed(), context.getMessagesDeleted());
        }

        public AdditionalInformation(Instant timestamp, ExpireMailboxService.RunningOptions runningOptions, long mailboxesExpired, long mailboxesFailed, long mailboxesProcessed, long messagesDeleted) {
            this.timestamp = timestamp;
            this.runningOptions = runningOptions;
            this.mailboxesExpired = mailboxesExpired;
            this.mailboxesFailed = mailboxesFailed;
            this.mailboxesProcessed = mailboxesProcessed;
            this.messagesDeleted = messagesDeleted;
        }

        public ExpireMailboxService.RunningOptions getRunningOptions() {
            return this.runningOptions;
        }

        public long getMailboxesExpired() {
            return this.mailboxesExpired;
        }

        public long getMailboxesFailed() {
            return this.mailboxesFailed;
        }

        public long getMailboxesProcessed() {
            return this.mailboxesProcessed;
        }

        public long getMessagesDeleted() {
            return this.messagesDeleted;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }
}

