/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.blob.deduplication;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scala.publisher.package$;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuples;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Mg\u0001\u0002\u000b\u0016\u0001\tB\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!Aa\t\u0001B\u0001B\u0003%q\tC\u0003O\u0001\u0011\u0005q\nC\u0003[\u0001\u0011\u00053\fC\u0003[\u0001\u0011\u00053\u0010\u0003\u0004[\u0001\u0011\u0005\u00131\u0002\u0005\u00075\u0002!\t%!\u000b\t\ri\u0003A\u0011IA,\u0011\u0019Q\u0006\u0001\"\u0011\u0002b!9\u00111\u000e\u0001\u0005\n\u00055\u0004bBAD\u0001\u0011\u0005\u0013\u0011\u0012\u0005\b\u0003'\u0003A\u0011IAK\u0011\u001d\tY\n\u0001C!\u0003;Cq!!*\u0001\t\u0003\n9\u000bC\u0004\u0002*\u0002!\t%a+\t\u000f\u0005]\u0006\u0001\"\u0011\u0002:\"9\u0011q\u0019\u0001\u0005B\u0005%\u0007bBAg\u0001\u0011\u0005\u0013q\u001a\u0002\u0015!\u0006\u001c8\u000f\u00165s_V<\u0007N\u00117pEN#xN]3\u000b\u0005Y9\u0012!\u00043fIV\u0004H.[2bi&|gN\u0003\u0002\u00193\u0005!!\r\\8c\u0015\tQ2$\u0001\u0004tKJ4XM\u001d\u0006\u00039u\tQA[1nKNT!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO\u000e\u00011c\u0001\u0001$WA\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0005Y\u0006twMC\u0001)\u0003\u0011Q\u0017M^1\n\u0005)*#AB(cU\u0016\u001cG\u000f\u0005\u0002-a5\tQF\u0003\u0002/_\u0005\u0019\u0011\r]5\u000b\u0005aY\u0012BA\u0019.\u0005%\u0011En\u001c2Ti>\u0014X-\u0001\u0007cY>\u00147\u000b^8sK\u0012\u000bu\n\u0005\u0002-i%\u0011Q'\f\u0002\r\u00052|'m\u0015;pe\u0016$\u0015iT\u0001\u0012I\u00164\u0017-\u001e7u\u0005V\u001c7.\u001a;OC6,\u0007C\u0001\u00179\u0013\tITF\u0001\u0006Ck\u000e\\W\r\u001e(b[\u0016DCAA\u001eD\tB\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0007S:TWm\u0019;\u000b\u0003\u0001\u000bqA[1lCJ$\u0018-\u0003\u0002C{\t)a*Y7fI\u0006)a/\u00197vK\u0006\nQ)A\u0007eK\u001a\fW\u000f\u001c;Ck\u000e\\W\r^\u0001\u000eE2|'-\u00133GC\u000e$xN]=\u0011\u0005![eB\u0001\u0017J\u0013\tQU&\u0001\u0004CY>\u0014\u0017\nZ\u0005\u0003\u00196\u0013qAR1di>\u0014\u0018P\u0003\u0002K[\u00051A(\u001b8jiz\"B\u0001\u0015*T+B\u0011\u0011\u000bA\u0007\u0002+!)!\u0007\u0002a\u0001g!)a\u0007\u0002a\u0001o!\"1kO\"E\u0011\u00151E\u00011\u0001HQ\t!q\u000b\u0005\u0002=1&\u0011\u0011,\u0010\u0002\u0007\u0013:TWm\u0019;\u0002\tM\fg/\u001a\u000b\u00059\u0016<'\u000fE\u0002^A\nl\u0011A\u0018\u0006\u0003?~\tqB]3bGRLg/Z:ue\u0016\fWn]\u0005\u0003Cz\u0013\u0011\u0002U;cY&\u001c\b.\u001a:\u0011\u00051\u001a\u0017B\u00013.\u0005\u0019\u0011En\u001c2JI\")a-\u0002a\u0001o\u0005Q!-^2lKRt\u0015-\\3\t\u000b!,\u0001\u0019A5\u0002\t\u0011\fG/\u0019\t\u0004U6|W\"A6\u000b\u00031\fQa]2bY\u0006L!A\\6\u0003\u000b\u0005\u0013(/Y=\u0011\u0005)\u0004\u0018BA9l\u0005\u0011\u0011\u0015\u0010^3\t\u000bM,\u0001\u0019\u0001;\u0002\u001bM$xN]1hKB{G.[2z!\t)\bP\u0004\u0002-m&\u0011q/L\u0001\n\u00052|'m\u0015;pe\u0016L!!\u001f>\u0003\u001bM#xN]1hKB{G.[2z\u0015\t9X\u0006F\u0003]yv\fI\u0001C\u0003g\r\u0001\u0007q\u0007C\u0003i\r\u0001\u0007a\u0010E\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\rq%\u0001\u0002j_&!\u0011qAA\u0001\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000bM4\u0001\u0019\u0001;\u0015\u000fq\u000bi!a\u0004\u0002(!)am\u0002a\u0001o!1\u0001n\u0002a\u0001\u0003#\u0001B!a\u0005\u0002$5\u0011\u0011Q\u0003\u0006\u0005\u0003\u0007\t9B\u0003\u0003\u0002\u001a\u0005m\u0011AB2p[6|gN\u0003\u0003\u0002\u001e\u0005}\u0011AB4p_\u001edWM\u0003\u0002\u0002\"\u0005\u00191m\\7\n\t\u0005\u0015\u0012Q\u0003\u0002\u000b\u0005f$XmU8ve\u000e,\u0007\"B:\b\u0001\u0004!H#\u0003/\u0002,\u00055\u0012qFA+\u0011\u00151\u0007\u00021\u00018\u0011\u0015A\u0007\u00021\u0001j\u0011\u001d\t\t\u0004\u0003a\u0001\u0003g\taB\u00197pE&#\u0007K]8wS\u0012,'\u000f\u0005\u0003\u00026\u0005EcbAA\u001cm:!\u0011\u0011HA(\u001d\u0011\tY$!\u0014\u000f\t\u0005u\u00121\n\b\u0005\u0003\u007f\tIE\u0004\u0003\u0002B\u0005\u001dSBAA\"\u0015\r\t)%I\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001J!AH\u0010\n\u0005qi\u0012B\u0001\r\u001c\u0013\tqs&C\u0002\u0002Ti\u0014aB\u00117pE&#\u0007K]8wS\u0012,'\u000fC\u0003t\u0011\u0001\u0007A\u000fF\u0005]\u00033\nY&!\u0018\u0002`!)a-\u0003a\u0001o!1\u0001.\u0003a\u0001\u0003#Aq!!\r\n\u0001\u0004\t\u0019\u0004C\u0003t\u0013\u0001\u0007A\u000fF\u0005]\u0003G\n)'a\u001a\u0002j!)aM\u0003a\u0001o!)\u0001N\u0003a\u0001}\"9\u0011\u0011\u0007\u0006A\u0002\u0005M\u0002\"B:\u000b\u0001\u0004!\u0018AC<ji\"\u0014En\u001c2JIR!\u0011qNAC!\u0011i\u0006-!\u001d\u0011\r\u0005M\u0014\u0011\u00112\u007f\u001b\t\t)H\u0003\u0003\u0002x\u0005e\u0014\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\t\u0005m\u0014QP\u0001\u0005kRLGN\u0003\u0002\u0002\u0000\u00059!/Z1di>\u0014\u0018\u0002BAB\u0003k\u0012a\u0001V;qY\u0016\u0014\u0004\"\u00025\f\u0001\u0004q\u0018!\u0003:fC\u0012\u0014\u0015\u0010^3t)\u0019\tY)!$\u0002\u0010B\u0019Q\fY5\t\u000b\u0019d\u0001\u0019A\u001c\t\r\u0005EE\u00021\u0001c\u0003\u0019\u0011Gn\u001c2JI\u0006!!/Z1e)\u0015q\u0018qSAM\u0011\u00151W\u00021\u00018\u0011\u0019\t\t*\u0004a\u0001E\u0006a!/Z1e%\u0016\f7\r^5wKR1\u0011qTAQ\u0003G\u00032!\u00181\u007f\u0011\u00151g\u00021\u00018\u0011\u0019\t\tJ\u0004a\u0001E\u0006!r-\u001a;EK\u001a\fW\u000f\u001c;Ck\u000e\\W\r\u001e(b[\u0016$\u0012aN\u0001\rI\u0016dW\r^3Ck\u000e\\W\r\u001e\u000b\u0005\u0003[\u000b)\f\u0005\u0003^A\u0006=\u0006c\u0001\u0013\u00022&\u0019\u00111W\u0013\u0003\tY{\u0017\u000e\u001a\u0005\u0006MB\u0001\raN\u0001\u0007I\u0016dW\r^3\u0015\r\u0005m\u00161YAc!\u0011i\u0006-!0\u0011\u0007\u0011\ny,C\u0002\u0002B\u0016\u0012qAQ8pY\u0016\fg\u000eC\u0003g#\u0001\u0007q\u0007\u0003\u0004\u0002\u0012F\u0001\rAY\u0001\fY&\u001cHOQ;dW\u0016$8\u000f\u0006\u0002\u0002LB\u0019Q\fY\u001c\u0002\u00131L7\u000f\u001e\"m_\n\u001cHc\u0001/\u0002R\")am\u0005a\u0001o\u0001")
public class PassThroughBlobStore
implements BlobStore {
    private final BlobStoreDAO blobStoreDAO;
    @Named(value="defaultBucket")
    private final BucketName defaultBucketName;
    private final BlobId.Factory blobIdFactory;

    public Publisher<BlobId> save(BucketName bucketName, String data, BlobStore.StoragePolicy storagePolicy) {
        return super.save(bucketName, data, storagePolicy);
    }

    public Publisher<byte[]> readBytes(BucketName bucketName, BlobId blobId, BlobStore.StoragePolicy storagePolicy) {
        return super.readBytes(bucketName, blobId, storagePolicy);
    }

    public InputStream read(BucketName bucketName, BlobId blobId, BlobStore.StoragePolicy storagePolicy) {
        return super.read(bucketName, blobId, storagePolicy);
    }

    public Publisher<InputStream> readReactive(BucketName bucketName, BlobId blobId, BlobStore.StoragePolicy storagePolicy) {
        return super.readReactive(bucketName, blobId, storagePolicy);
    }

    public Publisher<BlobId> save(BucketName bucketName, byte[] data2, BlobStore.StoragePolicy storagePolicy) {
        return this.save(bucketName, data2, data -> this.withBlobId(data), storagePolicy);
    }

    public Publisher<BlobId> save(BucketName bucketName, InputStream data2, BlobStore.StoragePolicy storagePolicy) {
        return this.save(bucketName, data2, data -> this.withBlobId(data), storagePolicy);
    }

    public Publisher<BlobId> save(BucketName bucketName, ByteSource data2, BlobStore.StoragePolicy storagePolicy) {
        return this.save(bucketName, data2, data -> this.withBlobId(data), storagePolicy);
    }

    public Publisher<BlobId> save(BucketName bucketName, byte[] data, BlobStore.BlobIdProvider blobIdProvider, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        return this.save(bucketName, new ByteArrayInputStream(data), blobIdProvider, storagePolicy);
    }

    public Publisher<BlobId> save(BucketName bucketName, ByteSource data, BlobStore.BlobIdProvider blobIdProvider, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        return SMono$.MODULE$.fromCallable(() -> data.openStream()).using((Function1 & Serializable)stream -> SMono$.MODULE$.apply(blobIdProvider.apply(stream)).subscribeOn(Schedulers.boundedElastic()).map((Function1 & Serializable)javaTuple2 -> package$.MODULE$.tupleTwo2ScalaTuple2(javaTuple2)).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BlobId blobId = (BlobId)tuple2._1();
                InputStream inputStream = (InputStream)tuple2._2();
                return SMono$.MODULE$.apply($this.blobStoreDAO.save(bucketName, blobId, inputStream)).then(SMono$.MODULE$.just((Object)blobId));
            }
            throw new MatchError((Object)tuple2);
        }), (Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
    }

    public Publisher<BlobId> save(BucketName bucketName, InputStream data, BlobStore.BlobIdProvider blobIdProvider, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        return SMono$.MODULE$.apply(blobIdProvider.apply(data)).subscribeOn(Schedulers.boundedElastic()).flatMap((Function1 & Serializable)tuple -> SMono$.MODULE$.apply($this.blobStoreDAO.save(bucketName, (BlobId)tuple.getT1(), (InputStream)tuple.getT2())).then(SMono$.MODULE$.just(tuple.getT1())));
    }

    private Publisher<reactor.util.function.Tuple2<BlobId, InputStream>> withBlobId(InputStream data) {
        return SMono$.MODULE$.just((Object)Tuples.of((Object)this.blobIdFactory.of(UUID.randomUUID().toString()), (Object)data));
    }

    public Publisher<byte[]> readBytes(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.readBytes(bucketName, blobId);
    }

    public InputStream read(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.read(bucketName, blobId);
    }

    public Publisher<InputStream> readReactive(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.readReactive(bucketName, blobId);
    }

    public BucketName getDefaultBucketName() {
        return this.defaultBucketName;
    }

    public Publisher<Void> deleteBucket(BucketName bucketName) {
        return this.blobStoreDAO.deleteBucket(bucketName);
    }

    public Publisher<Boolean> delete(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)blobId);
        return SMono$.MODULE$.fromPublisher(this.blobStoreDAO.delete(bucketName, blobId)).then(SMono$.MODULE$.just((Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    public Publisher<BucketName> listBuckets() {
        return Flux.concat((Publisher[])new Publisher[]{this.blobStoreDAO.listBuckets(), Flux.just((Object)this.defaultBucketName)}).distinct();
    }

    public Publisher<BlobId> listBlobs(BucketName bucketName) {
        return this.blobStoreDAO.listBlobs(bucketName);
    }

    @Inject
    public PassThroughBlobStore(BlobStoreDAO blobStoreDAO, @Named(value="defaultBucket") BucketName defaultBucketName, BlobId.Factory blobIdFactory) {
        this.blobStoreDAO = blobStoreDAO;
        this.defaultBucketName = defaultBucketName;
        this.blobIdFactory = blobIdFactory;
    }
}

