/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.james.core.Username;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.Registration;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.MailboxChangeRepository;
import org.apache.james.jmap.api.change.TypeStateFactory;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.api.model.State;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.change.AccountIdRegistrationKey$;
import org.apache.james.jmap.change.EmailTypeName$;
import org.apache.james.jmap.change.MailboxTypeName$;
import org.apache.james.jmap.change.StateChangeListener;
import org.apache.james.jmap.change.TypeState;
import org.apache.james.jmap.core.AccountId$;
import org.apache.james.jmap.core.OutboundMessage;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.PushState;
import org.apache.james.jmap.core.PushState$;
import org.apache.james.jmap.core.RequestId;
import org.apache.james.jmap.core.ResponseObject;
import org.apache.james.jmap.core.StateChange;
import org.apache.james.jmap.core.UuidState;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.jmap.core.WebSocketError;
import org.apache.james.jmap.core.WebSocketInboundMessage;
import org.apache.james.jmap.core.WebSocketPushDisable$;
import org.apache.james.jmap.core.WebSocketPushEnable;
import org.apache.james.jmap.core.WebSocketRequest;
import org.apache.james.jmap.core.WebSocketResponse;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.http.UserProvisioning;
import org.apache.james.jmap.json.PushSerializer;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.routes.ClientContext;
import org.apache.james.jmap.routes.JMAPApi;
import org.apache.james.jmap.routes.WebSocketRoutes$;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.user.api.DelegationStore;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.Json$;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t%t!\u0002\u000e\u001c\u0011\u00031c!\u0002\u0015\u001c\u0011\u0003I\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004b\u0002\u001a\u0002\u0005\u0004%\ta\r\u0005\u0007u\u0005\u0001\u000b\u0011\u0002\u001b\u0007\t!Z\u0002a\u000f\u0005\t\u0011\u0016\u0011)\u0019!C\u0001\u0013\"A\u0001+\u0002B\u0001B\u0003%!\n\u0003\u0005R\u000b\t\u0005\t\u0015!\u0003S\u0011!)VA!A!\u0002\u00131\u0006\u0002\u00035\u0006\u0005\u0003\u0005\u000b\u0011B5\t\u00111,!\u0011!Q\u0001\n5D\u0001\"^\u0003\u0003\u0002\u0003\u0006IA\u001e\u0005\ts\u0016\u0011\t\u0011)A\u0005u\"Q\u0011\u0011A\u0003\u0003\u0002\u0003\u0006I!a\u0001\t\u0015\u0005%QA!A!\u0002\u0013\tY\u0001\u0003\u00041\u000b\u0011\u0005\u0011\u0011\u0004\u0005\u00079\u0015!\t%a\u0010\t\u000f\u0005]S\u0001\"\u0003\u0002Z!9\u0011QS\u0003\u0005\n\u0005]\u0005bBAc\u000b\u0011%\u0011q\u0019\u0005\b\u0005\u000b)A\u0011\u0002B\u0004\u0011\u001d\u0011)\"\u0002C\u0005\u0005/AqAa\u0007\u0006\t\u0013\u0011i\u0002C\u0004\u0003<\u0015!IA!\u0010\t\u000f\teS\u0001\"\u0003\u0003\\\u0005yq+\u001a2T_\u000e\\W\r\u001e*pkR,7O\u0003\u0002\u001d;\u00051!o\\;uKNT!AH\u0010\u0002\t)l\u0017\r\u001d\u0006\u0003A\u0005\nQA[1nKNT!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO\u000e\u0001\u0001CA\u0014\u0002\u001b\u0005Y\"aD,fEN{7m[3u%>,H/Z:\u0014\u0005\u0005Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002M\u00051AjT$H\u000bJ+\u0012\u0001\u000e\t\u0003kaj\u0011A\u000e\u0006\u0003o\r\nQa\u001d7gi)L!!\u000f\u001c\u0003\r1{wmZ3s\u0003\u001daujR$F%\u0002\u001a2!\u0002\u001fE!\ti$)D\u0001?\u0015\ty\u0004)\u0001\u0003mC:<'\"A!\u0002\t)\fg/Y\u0005\u0003\u0007z\u0012aa\u00142kK\u000e$\bCA#G\u001b\u0005i\u0012BA$\u001e\u0005)QU*\u0011)S_V$Xm]\u0001\u000eCV$\b.\u001a8uS\u000e\fGo\u001c:\u0016\u0003)\u0003\"a\u0013(\u000e\u00031S!!T\u000f\u0002\t!$H\u000f]\u0005\u0003\u001f2\u0013Q\"Q;uQ\u0016tG/[2bi>\u0014\u0018AD1vi\",g\u000e^5dCR|'\u000fI\u0001\u0010kN,'\u000f\u0015:pm&\u001c\u0018n\u001c8feB\u00111jU\u0005\u0003)2\u0013\u0001#V:feB\u0013xN^5tS>t\u0017N\\4\u0002\u0011\u00154XM\u001c;CkN\u0004\"a\u0016.\u000e\u0003aS!!W\u0010\u0002\r\u00154XM\u001c;t\u0013\tY\u0006L\u0001\u0005Fm\u0016tGOQ;tQ\u0011IQ,\u001a4\u0011\u0005y\u001bW\"A0\u000b\u0005\u0001\f\u0017AB5oU\u0016\u001cGOC\u0001c\u0003\u001dQ\u0017m[1si\u0006L!\u0001Z0\u0003\u000b9\u000bW.\u001a3\u0002\u000bY\fG.^3\"\u0003\u001d\fAAS'B!\u00069!.\\1q\u0003BL\u0007CA\u0014k\u0013\tY7DA\u0004K\u001b\u0006\u0003\u0016\t]5\u0002/5\f\u0017\u000e\u001c2pq\u000eC\u0017M\\4f%\u0016\u0004xn]5u_JL\bC\u00018t\u001b\u0005y'B\u00019r\u0003\u0019\u0019\u0007.\u00198hK*\u0011!/H\u0001\u0004CBL\u0017B\u0001;p\u0005]i\u0015-\u001b7c_b\u001c\u0005.\u00198hKJ+\u0007o\\:ji>\u0014\u00180A\u000bf[\u0006LGn\u00115b]\u001e,'+\u001a9pg&$xN]=\u0011\u00059<\u0018B\u0001=p\u0005U)U.Y5m\u0007\"\fgnZ3SKB|7/\u001b;pef\fa\u0002];tQN+'/[1mSj,'\u000f\u0005\u0002|}6\tAP\u0003\u0002~;\u0005!!n]8o\u0013\tyHP\u0001\bQkND7+\u001a:jC2L'0\u001a:\u0002!QL\b/Z*uCR,g)Y2u_JL\bc\u00018\u0002\u0006%\u0019\u0011qA8\u0003!QK\b/Z*uCR,g)Y2u_JL\u0018a\u00043fY\u0016<\u0017\r^5p]N#xN]3\u0011\t\u00055\u0011QC\u0007\u0003\u0003\u001fQ1A]A\t\u0015\r\t\u0019bH\u0001\u0005kN,'/\u0003\u0003\u0002\u0018\u0005=!a\u0004#fY\u0016<\u0017\r^5p]N#xN]3\u0015)\u0005m\u0011QDA\u0013\u0003O\tY#!\f\u00020\u0005E\u00121GA\u001b!\t9S\u0001C\u0003I!\u0001\u0007!\n\u000b\u0004\u0002\u001eu+\u0017\u0011E\u0011\u0003\u0003G\t\u0001B\u0015$D[a2$'\r\u0005\u0006#B\u0001\rA\u0015\u0005\u0006+B\u0001\rA\u0016\u0015\u0006\u0003OiVM\u001a\u0005\u0006QB\u0001\r!\u001b\u0005\u0006YB\u0001\r!\u001c\u0005\u0006kB\u0001\rA\u001e\u0005\u0006sB\u0001\rA\u001f\u0005\b\u0003\u0003\u0001\u0002\u0019AA\u0002\u0011\u001d\tI\u0001\u0005a\u0001\u0003\u0017A3\u0001EA\u001d!\rq\u00161H\u0005\u0004\u0003{y&AB%oU\u0016\u001cG\u000f\u0006\u0002\u0002BA1\u00111IA'\u0003#j!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0007gR\u0014X-Y7\u000b\u0007\u0005-\u0003)\u0001\u0003vi&d\u0017\u0002BA(\u0003\u000b\u0012aa\u0015;sK\u0006l\u0007cA#\u0002T%\u0019\u0011QK\u000f\u0003\u0013)k\u0015\t\u0015*pkR,\u0017\u0001\u00055b]\u0012dWmV3c'>\u001c7.\u001a;t)\u0019\tY&!\u001e\u0002\fB1\u0011QLA6\u0003_j!!a\u0018\u000b\t\u0005\u0005\u00141M\u0001\naV\u0014G.[:iKJTA!!\u001a\u0002h\u0005!1m\u001c:f\u0015\t\tI'A\u0004sK\u0006\u001cGo\u001c:\n\t\u00055\u0014q\f\u0002\u0005\u001b>tw\u000eE\u0002>\u0003cJ1!a\u001d?\u0005\u00111v.\u001b3\t\u000f\u0005]$\u00031\u0001\u0002z\u0005\t\u0002\u000e\u001e;q'\u0016\u0014h/\u001a:SKF,Xm\u001d;\u0011\t\u0005m\u0014qQ\u0007\u0003\u0003{RA!a \u0002\u0002\u000611/\u001a:wKJT1!TAB\u0015\u0011\t))a\u001a\u0002\u000b9,G\u000f^=\n\t\u0005%\u0015Q\u0010\u0002\u0012\u0011R$\boU3sm\u0016\u0014(+Z9vKN$\bbBAG%\u0001\u0007\u0011qR\u0001\u0013QR$\boU3sm\u0016\u0014(+Z:q_:\u001cX\r\u0005\u0003\u0002|\u0005E\u0015\u0002BAJ\u0003{\u0012!\u0003\u0013;uaN+'O^3s%\u0016\u001c\bo\u001c8tK\u0006I\u0002.\u00198eY\u0016<VMY*pG.,GoQ8o]\u0016\u001cG/[8o)\u0011\tI*!.\u0015\r\u0005m\u00131TAV\u0011\u001d\tij\u0005a\u0001\u0003?\u000b!!\u001b8\u0011\t\u0005\u0005\u0016qU\u0007\u0003\u0003GSA!!*\u0002\u0002\u0006Iq/\u001a2t_\u000e\\W\r^\u0005\u0005\u0003S\u000b\u0019K\u0001\tXK\n\u001cxnY6fi&s'm\\;oI\"9\u0011QV\nA\u0002\u0005=\u0016aA8viB!\u0011\u0011UAY\u0013\u0011\t\u0019,a)\u0003#]+'m]8dW\u0016$x*\u001e;c_VtG\rC\u0004\u00028N\u0001\r!!/\u0002\u000fM,7o]5p]B!\u00111XAa\u001b\t\tiLC\u0002\u0002@~\tq!\\1jY\n|\u00070\u0003\u0003\u0002D\u0006u&AD'bS2\u0014w\u000e_*fgNLwN\\\u0001\u0015Q\u0006tG\r\\3DY&,g\u000e^'fgN\fw-Z:\u0015\t\u0005%\u00171 \u000b\u0005\u0003\u0017\f\t\u000f\u0005\u0004\u0002N\u0006M\u0017q[\u0007\u0003\u0003\u001fTA!!\u0019\u0002R*\u0019Q&a\u0019\n\t\u0005U\u0017q\u001a\u0002\u0006'6{gn\u001c\t\u0005\u00033\fi.\u0004\u0002\u0002\\*\u0019\u0011QM\u000f\n\t\u0005}\u00171\u001c\u0002\u0010\u001fV$(m\\;oI6+7o]1hK\"9\u00111\u001d\u000bA\u0002\u0005\u0015\u0018aB7fgN\fw-\u001a\t\u0005\u0003O\f)P\u0004\u0003\u0002j\u0006E\bcAAvY5\u0011\u0011Q\u001e\u0006\u0004\u0003_,\u0013A\u0002\u001fs_>$h(C\u0002\u0002t2\na\u0001\u0015:fI\u00164\u0017\u0002BA|\u0003s\u0014aa\u0015;sS:<'bAAzY!9\u0011Q \u000bA\u0002\u0005}\u0018!D2mS\u0016tGoQ8oi\u0016DH\u000fE\u0002(\u0005\u0003I1Aa\u0001\u001c\u00055\u0019E.[3oi\u000e{g\u000e^3yi\u0006A2/\u001a8e!V\u001c\bn\u0015;bi\u0016LeMU3rk\u0016\u001cH/\u001a3\u0015\r\u0005-'\u0011\u0002B\n\u0011\u001d\u0011Y!\u0006a\u0001\u0005\u001b\t!\u0002];tQ\u0016s\u0017M\u00197f!\u0011\tINa\u0004\n\t\tE\u00111\u001c\u0002\u0014/\u0016\u00147k\\2lKR\u0004Vo\u001d5F]\u0006\u0014G.\u001a\u0005\b\u0003{,\u0002\u0019AA\u0000\u00035\u0019XM\u001c3QkND7\u000b^1uKR!\u00111\u001aB\r\u0011\u001d\tiP\u0006a\u0001\u0003\u007f\f\u0001\u0004[1oI2,\u0007\n\u001e;q\u0011\u0006tGm\u001d5bW\u0016,%O]8s)\u0019\u0011yB!\t\u00038A1\u0011QZAj\u0003_BqAa\t\u0018\u0001\u0004\u0011)#A\u0005uQJ|w/\u00192mKB!!q\u0005B\u0019\u001d\u0011\u0011IC!\f\u000f\t\u0005-(1F\u0005\u0002[%\u0019!q\u0006\u0017\u0002\u000fA\f7m[1hK&!!1\u0007B\u001b\u0005%!\u0006N]8xC\ndWMC\u0002\u000301BqA!\u000f\u0018\u0001\u0004\ty)\u0001\u0005sKN\u0004xN\\:f\u0003\u001d\t7/\u0012:s_J$BAa\u0010\u0003JQ!!\u0011\tB$!\u0011\tINa\u0011\n\t\t\u0015\u00131\u001c\u0002\u000f/\u0016\u00147k\\2lKR,%O]8s\u0011\u001d\u0011\u0019\u0003\u0007a\u0001\u0005KAqAa\u0013\u0019\u0001\u0004\u0011i%A\u0005sKF,Xm\u001d;JIB)1Fa\u0014\u0003T%\u0019!\u0011\u000b\u0017\u0003\r=\u0003H/[8o!\u0011\tIN!\u0016\n\t\t]\u00131\u001c\u0002\n%\u0016\fX/Z:u\u0013\u0012\faB]3ta>tG\rR3uC&d7\u000f\u0006\u0004\u0003 \tu#q\f\u0005\b\u0003\u001bK\u0002\u0019AAH\u0011\u001d\u0011\t'\u0007a\u0001\u0005G\nq\u0001Z3uC&d7\u000f\u0005\u0003\u0002Z\n\u0015\u0014\u0002\u0002B4\u00037\u0014a\u0002\u0015:pE2,W\u000eR3uC&d7\u000f")
public class WebSocketRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final UserProvisioning userProvisioner;
    @Named(value="JMAP")
    private final EventBus eventBus;
    private final JMAPApi jmapApi;
    private final MailboxChangeRepository mailboxChangeRepository;
    private final EmailChangeRepository emailChangeRepository;
    private final PushSerializer pushSerializer;
    private final TypeStateFactory typeStateFactory;
    private final DelegationStore delegationStore;

    public static Logger LOGGER() {
        return WebSocketRoutes$.MODULE$.LOGGER();
    }

    public Mono<Void> handleInternalError(HttpServerResponse response, Logger logger, Throwable e) {
        return super.handleInternalError(response, logger, e);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse response, Logger logger, Throwable e) {
        return super.handleBadRequest(response, logger, e);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse response, Logger logger, Throwable e) {
        return super.handleAuthenticationFailure(response, logger, e);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.GET, (String)"/jmap/ws")).action((httpServerRequest, httpServerResponse) -> this.handleWebSockets(httpServerRequest, httpServerResponse)).corsHeaders(), JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.OPTIONS, (String)"/jmap/ws")).action(JMAPRoutes.CORS_CONTROL).corsHeaders()});
    }

    private Mono<Void> handleWebSockets(HttpServerRequest httpServerRequest, HttpServerResponse httpServerResponse) {
        return SMono$.MODULE$.apply((Publisher)this.authenticator().authenticate(httpServerRequest)).flatMap((Function1 & Serializable)mailboxSession -> $this.userProvisioner.provisionUser((MailboxSession)mailboxSession).then().then(SMono$.MODULE$.apply((Publisher)httpServerResponse.sendWebsocket((in, out) -> this.handleWebSocketConnection((MailboxSession)mailboxSession, (WebsocketInbound)in, (WebsocketOutbound)out))))).onErrorResume((Function1 & Serializable)throwable -> this.handleHttpHandshakeError((Throwable)throwable, httpServerResponse)).asJava().then();
    }

    private Mono<Void> handleWebSocketConnection(MailboxSession session, WebsocketInbound in, WebsocketOutbound out) {
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        ClientContext context = new ClientContext((Sinks.Many<OutboundMessage>)sink, new AtomicReference<Registration>(), session);
        SFlux qual$1 = SFlux$.MODULE$.apply((Publisher)in.aggregateFrames().receiveFrames()).map((Function1 & Serializable)frame -> {
            byte[] bytes = new byte[frame.content().readableBytes()];
            frame.content().readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        });
        Function1 & Serializable x$1 = (Function1 & Serializable)message -> this.handleClientMessages(context, (String)message);
        int x$2 = qual$1.flatMap$default$2();
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        SFlux responseFlux = qual$1.flatMap((Function1)x$1, x$2, x$3, x$4).doOnTerminate((Function0)(JFunction0.mcV.sp & Serializable)() -> context.clean()).doOnCancel((Function0)(JFunction0.mcV.sp & Serializable)() -> context.clean());
        return out.sendString((Publisher)SFlux$.MODULE$.merge((Seq)new .colon.colon((Object)responseFlux, (List)new .colon.colon((Object)sink.asFlux(), (List)Nil$.MODULE$)), SFlux$.MODULE$.merge$default$2(), SFlux$.MODULE$.merge$default$3()).map((Function1 & Serializable)outboundMessage -> $this.pushSerializer.serialize((OutboundMessage)outboundMessage)).map((Function1 & Serializable)json -> Json$.MODULE$.stringify(json))).then();
    }

    private SMono<OutboundMessage> handleClientMessages(ClientContext clientContext, String message) {
        return (SMono)this.pushSerializer.deserializeWebSocketInboundMessage(message).fold((Function1 & Serializable)invalid -> {
            WebSocketError error = this.asError((Option<RequestId>)None$.MODULE$, new IllegalArgumentException(invalid.toString()));
            return SMono$.MODULE$.just((Object)error);
        }, (Function1 & Serializable)x0$1 -> {
            WebSocketInboundMessage webSocketInboundMessage = x0$1;
            if (webSocketInboundMessage instanceof WebSocketRequest) {
                WebSocketRequest webSocketRequest = (WebSocketRequest)webSocketInboundMessage;
                return $this.jmapApi.process(webSocketRequest.requestObject(), clientContext.session()).map((Function1 & Serializable)x$1 -> new WebSocketResponse(webSocketRequest.id(), (ResponseObject)x$1)).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)this.asError(webSocketRequest.id(), (Throwable)e)));
            }
            if (webSocketInboundMessage instanceof WebSocketPushEnable) {
                WebSocketPushEnable webSocketPushEnable = (WebSocketPushEnable)webSocketInboundMessage;
                return SMono$.MODULE$.just((Object)clientContext.session().getUser()).concatWith((Publisher)SFlux$.MODULE$.fromPublisher($this.delegationStore.delegatedUsers(clientContext.session().getUser()))).map((Function1 & Serializable)username -> AccountIdRegistrationKey$.MODULE$.of((Username)username)).collectSeq().flatMap((Function1 & Serializable)keys -> SMono$.MODULE$.apply($this.eventBus.register((EventListener.ReactiveEventListener)new StateChangeListener((Set<TypeName>)((Set)webSocketPushEnable.dataTypes().getOrElse((Function0 & Serializable)() -> $this.typeStateFactory.all().toSet())), clientContext.outbound()), CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)keys).asJavaCollection()))).doOnNext((Function1 & Serializable)newRegistration -> {
                    clientContext.withRegistration(newRegistration);
                    return BoxedUnit.UNIT;
                }).then(this.sendPushStateIfRequested(webSocketPushEnable, clientContext));
            }
            if (WebSocketPushDisable$.MODULE$.equals(webSocketInboundMessage)) {
                return SMono$.MODULE$.fromCallable(() -> {
                    clientContext.clean();
                    return BoxedUnit.UNIT;
                }).then(SMono$.MODULE$.empty());
            }
            throw new MatchError((Object)webSocketInboundMessage);
        });
    }

    private SMono<OutboundMessage> sendPushStateIfRequested(WebSocketPushEnable pushEnable, ClientContext clientContext) {
        return (SMono)pushEnable.pushState().map((Function1 & Serializable)x$2 -> this.sendPushState(clientContext)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty());
    }

    private SMono<OutboundMessage> sendPushState(ClientContext clientContext) {
        Username username = clientContext.session().getUser();
        org.apache.james.jmap.core.AccountId accountId = (org.apache.james.jmap.core.AccountId)AccountId$.MODULE$.from(username).fold((Function1 & Serializable)failure -> {
            throw new IllegalArgumentException((Throwable)failure);
        }, (Function1 & Serializable)success -> success);
        return SMono$.MODULE$.apply((Publisher)this.mailboxChangeRepository.getLatestStateWithDelegation(AccountId.fromUsername((Username)username)).flatMap(mailboxState -> $this.emailChangeRepository.getLatestStateWithDelegation(AccountId.fromUsername((Username)username)).map(emailState -> new StateChange((Map<org.apache.james.jmap.core.AccountId, TypeState>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)accountId), (Object)new TypeState((Map<TypeName, State>)((Map)MailboxTypeName$.MODULE$.asMap((Option<State>)new Some((Object)UuidState$.MODULE$.fromJava((org.apache.james.jmap.api.change.State)mailboxState))).$plus$plus(EmailTypeName$.MODULE$.asMap((Option<State>)new Some((Object)UuidState$.MODULE$.fromJava((org.apache.james.jmap.api.change.State)emailState)))))))}))), (Option<PushState>)new Some((Object)PushState$.MODULE$.from(new UuidState(mailboxState.getValue()), new UuidState(emailState.getValue())))))));
    }

    private SMono<Void> handleHttpHandshakeError(Throwable throwable, HttpServerResponse response) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof UnauthorizedException) {
            UnauthorizedException unauthorizedException = (UnauthorizedException)throwable2;
            return this.respondDetails(unauthorizedException.addHeaders(response), ProblemDetails$.MODULE$.forThrowable(throwable));
        }
        return this.respondDetails(response, ProblemDetails$.MODULE$.forThrowable(throwable));
    }

    private WebSocketError asError(Option<RequestId> requestId, Throwable throwable) {
        return new WebSocketError(requestId, ProblemDetails$.MODULE$.forThrowable(throwable));
    }

    private SMono<Void> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details) {
        return SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").sendString((Publisher)SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()), StandardCharsets.UTF_8).then());
    }

    @Inject
    public WebSocketRoutes(@Named(value="RFC-8621") Authenticator authenticator, UserProvisioning userProvisioner, @Named(value="JMAP") EventBus eventBus, JMAPApi jmapApi, MailboxChangeRepository mailboxChangeRepository, EmailChangeRepository emailChangeRepository, PushSerializer pushSerializer, TypeStateFactory typeStateFactory, DelegationStore delegationStore) {
        this.authenticator = authenticator;
        this.userProvisioner = userProvisioner;
        this.eventBus = eventBus;
        this.jmapApi = jmapApi;
        this.mailboxChangeRepository = mailboxChangeRepository;
        this.emailChangeRepository = emailChangeRepository;
        this.pushSerializer = pushSerializer;
        this.typeStateFactory = typeStateFactory;
        this.delegationStore = delegationStore;
    }
}

