/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Username;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.core.JmapRfc8621Configuration;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.Session;
import org.apache.james.jmap.core.UrlPrefixes$;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.routes.SessionRoutes$;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.user.api.DelegationStore;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.Json$;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Set;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Mx!\u0002\u000f\u001e\u0011\u0003Ac!\u0002\u0016\u001e\u0011\u0003Y\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004b\u0002\u001b\u0002\u0005\u0004%I!\u000e\u0005\u0007\u0003\u0006\u0001\u000b\u0011\u0002\u001c\t\u000f\t\u000b!\u0019!C\u0005k!11)\u0001Q\u0001\nYBq\u0001R\u0001C\u0002\u0013%Q\t\u0003\u0004M\u0003\u0001\u0006IA\u0012\u0004\u0005Uu\u0001Q\n\u0003\u0005[\u0013\t\u0015\r\u0011\"\u0001\\\u0011!\u0011\u0017B!A!\u0002\u0013a\u0006\u0002C2\n\u0005\u000b\u0007I\u0011\u00013\t\u0011!L!\u0011!Q\u0001\n\u0015D\u0001\"[\u0005\u0003\u0006\u0004%\tA\u001b\u0005\tg&\u0011\t\u0011)A\u0005W\"AA/\u0003BC\u0002\u0013\u0005Q\u000f\u0003\u0005}\u0013\t\u0005\t\u0015!\u0003w\u0011\u0015\u0011\u0014\u0002\"\u0001~\u0011%\t9#\u0003b\u0001\n\u0013\tI\u0003\u0003\u0005\u0002:%\u0001\u000b\u0011BA\u0016\u0011%\tY$\u0003b\u0001\n\u0013\tI\u0003\u0003\u0005\u0002>%\u0001\u000b\u0011BA\u0016\u0011\u0019q\u0012\u0002\"\u0011\u0002@!9\u0011qK\u0005\u0005\n\u0005e\u0003bBAE\u0013\u0011%\u00111\u0012\u0005\b\u0003sKA\u0011BA^\u0011\u001d\t\t/\u0003C\u0005\u0003G\fQbU3tg&|gNU8vi\u0016\u001c(B\u0001\u0010 \u0003\u0019\u0011x.\u001e;fg*\u0011\u0001%I\u0001\u0005U6\f\u0007O\u0003\u0002#G\u0005)!.Y7fg*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0001\"!K\u0001\u000e\u0003u\u0011QbU3tg&|gNU8vi\u0016\u001c8CA\u0001-!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001K\u0001\r\u00156\u000b\u0005kX*F'NKuJT\u000b\u0002mA\u0011qG\u0010\b\u0003qq\u0002\"!\u000f\u0018\u000e\u0003iR!aO\u0014\u0002\rq\u0012xn\u001c;?\u0013\tid&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u007f\u0001\u0013aa\u0015;sS:<'BA\u001f/\u00035QU*\u0011)`'\u0016\u001b6+S(OA\u0005yq+\u0012'M?.suj\u0016(`\u00156\u000b\u0005+\u0001\tX\u000b2cul\u0013(P/:{&*T!QA\u00051AjT$H\u000bJ+\u0012A\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013\u0016\nQa\u001d7gi)L!a\u0013%\u0003\r1{wmZ3s\u0003\u001daujR$F%\u0002\u001a2!\u0003(W!\tyE+D\u0001Q\u0015\t\t&+\u0001\u0003mC:<'\"A*\u0002\t)\fg/Y\u0005\u0003+B\u0013aa\u00142kK\u000e$\bCA,Y\u001b\u0005y\u0012BA- \u0005)QU*\u0011)S_V$Xm]\u0001\u000eCV$\b.\u001a8uS\u000e\fGo\u001c:\u0016\u0003q\u0003\"!\u00181\u000e\u0003yS!aX\u0010\u0002\t!$H\u000f]\u0005\u0003Cz\u0013Q\"Q;uQ\u0016tG/[2bi>\u0014\u0018AD1vi\",g\u000e^5dCR|'\u000fI\u0001\u0010g\u0016\u001c8/[8o'V\u0004\b\u000f\\5feV\tQ\r\u0005\u0002*M&\u0011q-\b\u0002\u0010'\u0016\u001c8/[8o'V\u0004\b\u000f\\5fe\u0006\u00012/Z:tS>t7+\u001e9qY&,'\u000fI\u0001\u0010I\u0016dWmZ1uS>t7\u000b^8sKV\t1\u000e\u0005\u0002mc6\tQN\u0003\u0002o_\u0006\u0019\u0011\r]5\u000b\u0005A\f\u0013\u0001B;tKJL!A]7\u0003\u001f\u0011+G.Z4bi&|gn\u0015;pe\u0016\f\u0001\u0003Z3mK\u001e\fG/[8o'R|'/\u001a\u0011\u00021)l\u0017\r\u001d*gGb2$'M\"p]\u001aLw-\u001e:bi&|g.F\u0001w!\t9(0D\u0001y\u0015\tIx$\u0001\u0003d_J,\u0017BA>y\u0005aQU.\u00199SM\u000eDdGM\u0019D_:4\u0017nZ;sCRLwN\\\u0001\u001aU6\f\u0007O\u00154dqY\u0012\u0014gQ8oM&<WO]1uS>t\u0007\u0005\u0006\u0005\u007f\u007f\u0006e\u00111DA\u000f!\tI\u0013\u0002C\u0003[%\u0001\u0007A\fK\u0004\u0000\u0003\u0007\t\u0019\"!\u0006\u0011\t\u0005\u0015\u0011qB\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u00051\u0011N\u001c6fGRT!!!\u0004\u0002\u000f)\f7.\u0019:uC&!\u0011\u0011CA\u0004\u0005\u0015q\u0015-\\3e\u0003\u00151\u0018\r\\;fC\t\t9\"\u0001\u0005S\r\u000ek\u0003H\u000e\u001a2\u0011\u0015\u0019'\u00031\u0001f\u0011\u0015I'\u00031\u0001l\u0011\u0015!(\u00031\u0001wQ\r\u0011\u0012\u0011\u0005\t\u0005\u0003\u000b\t\u0019#\u0003\u0003\u0002&\u0005\u001d!AB%oU\u0016\u001cG/A\bhK:,'/\u0019;f'\u0016\u001c8/[8o+\t\tY\u0003\u0005\u0003\u0002.\u0005MbbA,\u00020%\u0019\u0011\u0011G\u0010\u0002\u0013)k\u0015\t\u0015*pkR,\u0017\u0002BA\u001b\u0003o\u0011a!Q2uS>t'bAA\u0019?\u0005\u0001r-\u001a8fe\u0006$XmU3tg&|g\u000eI\u0001\u0012e\u0016$\u0017N]3diR{7+Z:tS>t\u0017A\u0005:fI&\u0014Xm\u0019;U_N+7o]5p]\u0002\"\"!!\u0011\u0011\r\u0005\r\u0013QJA)\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013AB:ue\u0016\fWNC\u0002\u0002LI\u000bA!\u001e;jY&!\u0011qJA#\u0005\u0019\u0019FO]3b[B\u0019q+a\u0015\n\u0007\u0005UsDA\u0005K\u001b\u0006\u0003&k\\;uK\u0006\tr-\u001a;EK2,w-\u0019;fIV\u001bXM]:\u0015\t\u0005m\u0013\u0011\u0010\t\u0007\u0003;\nY'a\u001c\u000e\u0005\u0005}#\u0002BA1\u0003G\n\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0007=\n)GC\u0002z\u0003OR!!!\u001b\u0002\u000fI,\u0017m\u0019;pe&!\u0011QNA0\u0005\u0015\u0019f\t\\;y!\u0011\t\t(!\u001e\u000e\u0005\u0005M$BA=\"\u0013\u0011\t9(a\u001d\u0003\u0011U\u001bXM\u001d8b[\u0016Dq!a\u001f\u0019\u0001\u0004\ti(\u0001\bnC&d'm\u001c=TKN\u001c\u0018n\u001c8\u0011\t\u0005}\u0014QQ\u0007\u0003\u0003\u0003S1!a!\"\u0003\u001di\u0017-\u001b7c_bLA!a\"\u0002\u0002\nqQ*Y5mE>D8+Z:tS>t\u0017aC:f]\u0012\u0014Vm\u001d9p]\u0012$b!!$\u0002\u001a\u0006\r\u0006CBA/\u0003\u001f\u000b\u0019*\u0003\u0003\u0002\u0012\u0006}#!B*N_:|\u0007cA(\u0002\u0016&\u0019\u0011q\u0013)\u0003\tY{\u0017\u000e\u001a\u0005\b\u00037K\u0002\u0019AAO\u0003\u001d\u0019Xm]:j_:\u00042a^AP\u0013\r\t\t\u000b\u001f\u0002\b'\u0016\u001c8/[8o\u0011\u001d\t)+\u0007a\u0001\u0003O\u000bAA]3taB!\u0011\u0011VA[\u001b\t\tYK\u0003\u0003\u0002.\u0006=\u0016AB:feZ,'OC\u0002`\u0003cSA!a-\u0002h\u0005)a.\u001a;us&!\u0011qWAV\u0005IAE\u000f\u001e9TKJ4XM\u001d*fgB|gn]3\u0002\u001b\u0015\u0014(o\u001c:IC:$G.\u001b8h)\u0019\ti,a2\u0002^B1\u0011qXAb\u0003'k!!!1\u000b\t\u0005\u0005\u0014QM\u0005\u0005\u0003\u000b\f\tM\u0001\u0003N_:|\u0007bBAe5\u0001\u0007\u00111Z\u0001\ni\"\u0014xn^1cY\u0016\u0004B!!4\u0002X:!\u0011qZAj\u001d\rI\u0014\u0011[\u0005\u0002_%\u0019\u0011Q\u001b\u0018\u0002\u000fA\f7m[1hK&!\u0011\u0011\\An\u0005%!\u0006N]8xC\ndWMC\u0002\u0002V:Bq!a8\u001b\u0001\u0004\t9+\u0001\u0005sKN\u0004xN\\:f\u00039\u0011Xm\u001d9p]\u0012$U\r^1jYN$b!!0\u0002f\u0006%\bbBAt7\u0001\u0007\u0011qU\u0001\u0013QR$\boU3sm\u0016\u0014(+Z:q_:\u001cX\rC\u0004\u0002ln\u0001\r!!<\u0002\u000f\u0011,G/Y5mgB\u0019q/a<\n\u0007\u0005E\bP\u0001\bQe>\u0014G.Z7EKR\f\u0017\u000e\\:")
public class SessionRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final SessionSupplier sessionSupplier;
    private final DelegationStore delegationStore;
    private final JmapRfc8621Configuration jmapRfc8621Configuration;
    private final JMAPRoute.Action generateSession;
    private final JMAPRoute.Action redirectToSession;

    public Mono<Void> handleInternalError(HttpServerResponse response, Logger logger, Throwable e) {
        return super.handleInternalError(response, logger, e);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse response, Logger logger, Throwable e) {
        return super.handleBadRequest(response, logger, e);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse response, Logger logger, Throwable e) {
        return super.handleAuthenticationFailure(response, logger, e);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    public DelegationStore delegationStore() {
        return this.delegationStore;
    }

    public JmapRfc8621Configuration jmapRfc8621Configuration() {
        return this.jmapRfc8621Configuration;
    }

    private JMAPRoute.Action generateSession() {
        return this.generateSession;
    }

    private JMAPRoute.Action redirectToSession() {
        return this.redirectToSession;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.GET, (String)SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$JMAP_SESSION())).action(this.generateSession()).corsHeaders(), JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.OPTIONS, (String)SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$JMAP_SESSION())).action(JMAPRoutes.CORS_CONTROL).noCorsHeaders(), JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.GET, (String)SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$WELL_KNOWN_JMAP())).action(this.redirectToSession()).corsHeaders(), JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.OPTIONS, (String)SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$WELL_KNOWN_JMAP())).action(JMAPRoutes.CORS_CONTROL).noCorsHeaders()});
    }

    private SFlux<Username> getDelegatedUsers(MailboxSession mailboxSession) {
        return SFlux$.MODULE$.apply(this.delegationStore().delegatedUsers((Username)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mailboxSession.getLoggedInUser())).getOrElse((Function0 & Serializable)() -> mailboxSession.getUser())));
    }

    private SMono<Void> sendRespond(Session session, HttpServerResponse resp) {
        return SMono$.MODULE$.fromCallable(() -> Json$.MODULE$.stringify(ResponseSerializer$.MODULE$.serialize(session))).map((Function1 & Serializable)x$1 -> x$1.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.apply((Publisher)resp.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8").status(HttpResponseStatus.OK).header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then()));
    }

    private Mono<Void> errorHandling(Throwable throwable, HttpServerResponse response) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof UnauthorizedException) {
            UnauthorizedException unauthorizedException = (UnauthorizedException)throwable2;
            SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$LOGGER().warn("Unauthorized", (Throwable)unauthorizedException);
            HttpResponseStatus x$1 = HttpResponseStatus.UNAUTHORIZED;
            String x$2 = unauthorizedException.getMessage();
            String x$3 = ProblemDetails$.MODULE$.apply$default$1();
            Option<String> x$4 = ProblemDetails$.MODULE$.apply$default$3();
            return this.respondDetails(unauthorizedException.addHeaders(response), new ProblemDetails(x$3, x$1, x$4, x$2));
        }
        SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$LOGGER().error("Unexpected error upon requesting session", throwable2);
        HttpResponseStatus x$5 = HttpResponseStatus.INTERNAL_SERVER_ERROR;
        String x$6 = throwable2.getMessage();
        String x$7 = ProblemDetails$.MODULE$.apply$default$1();
        Option<String> x$8 = ProblemDetails$.MODULE$.apply$default$3();
        return this.respondDetails(response, new ProblemDetails(x$7, x$5, x$8, x$6));
    }

    private Mono<Void> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details) {
        return SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()).map((Function1 & Serializable)x$2 -> x$2.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then())).asJava();
    }

    public static final /* synthetic */ void $anonfun$generateSession$4(SessionRoutes $this, HttpServerRequest request$1, Pair x0$1, SynchronousSink x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            Pair baseUserAndDelegatedUsers = (Pair)tuple2._1();
            SynchronousSink sink = (SynchronousSink)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.sessionSupplier().generate((Username)baseUserAndDelegatedUsers.getLeft(), (Set<Username>)((IterableOnceOps)baseUserAndDelegatedUsers.getRight()).toSet(), UrlPrefixes$.MODULE$.from($this.jmapRfc8621Configuration(), request$1)).fold((Function1 & Serializable)x$1 -> {
                sink.error(x$1);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)session -> {
                sink.next((Object)session);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Inject
    public SessionRoutes(@Named(value="RFC-8621") Authenticator authenticator, SessionSupplier sessionSupplier, DelegationStore delegationStore, JmapRfc8621Configuration jmapRfc8621Configuration) {
        this.authenticator = authenticator;
        this.sessionSupplier = sessionSupplier;
        this.delegationStore = delegationStore;
        this.jmapRfc8621Configuration = jmapRfc8621Configuration;
        this.generateSession = (request, response) -> SMono$.MODULE$.fromPublisher((Publisher)this.authenticator().authenticate(request)).flatMap((Function1 & Serializable)mailboxSession -> this.getDelegatedUsers((MailboxSession)mailboxSession).collectSeq().map((Function1 & Serializable)seq -> Pair.of((Object)mailboxSession.getUser(), (Object)seq))).handle((Function2 & Serializable)(x0$1, x1$1) -> {
            SessionRoutes.$anonfun$generateSession$4(this, request, x0$1, x1$1);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)session -> this.sendRespond((Session)session, response)).onErrorResume((Function1 & Serializable)throwable -> SMono$.MODULE$.fromPublisher(this.errorHandling((Throwable)throwable, response))).asJava();
        this.redirectToSession = JMAPRoutes.redirectTo((String)SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$JMAP_SESSION());
    }
}

