/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.RequestObject;
import org.apache.james.jmap.core.ResponseObject;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.http.UserProvisioning;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.routes.JMAPApi;
import org.apache.james.jmap.routes.JMAPApiRoutes$;
import org.apache.james.mailbox.MailboxSession;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.JsError;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.Json$;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005=v!\u0002\n\u0014\u0011\u0003qb!\u0002\u0011\u0014\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003b\u0002\u0016\u0002\u0005\u0004%\ta\u000b\u0005\u0007e\u0005\u0001\u000b\u0011\u0002\u0017\u0007\t\u0001\u001a\u0002a\r\u0005\t\u0001\u0016\u0011)\u0019!C\u0001\u0003\"A\u0001*\u0002B\u0001B\u0003%!\t\u0003\u0005J\u000b\t\u0005\t\u0015!\u0003K\u0011!iUA!A!\u0002\u0013q\u0005\"\u0002\u0015\u0006\t\u0003\t\u0006\"\u0002\u000b\u0006\t\u00032\u0007\"\u0002:\u0006\t\u0013\u0019\bbBA\u0012\u000b\u0011%\u0011Q\u0005\u0005\b\u0003\u007f)A\u0011BA!\u0011\u001d\t\t(\u0002C\u0005\u0003gBq!!$\u0006\t\u0013\ty\tC\u0004\u0002 \u0016!I!!)\u0002\u001b)k\u0015\tU!qSJ{W\u000f^3t\u0015\t!R#\u0001\u0004s_V$Xm\u001d\u0006\u0003-]\tAA[7ba*\u0011\u0001$G\u0001\u0006U\u0006lWm\u001d\u0006\u00035m\ta!\u00199bG\",'\"\u0001\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005}\tQ\"A\n\u0003\u001b)k\u0015\tU!qSJ{W\u000f^3t'\t\t!\u0005\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\ta\u0001T(H\u000f\u0016\u0013V#\u0001\u0017\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=Z\u0012!B:mMRR\u0017BA\u0019/\u0005\u0019aunZ4fe\u00069AjT$H\u000bJ\u00033cA\u00035yA\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\u0005Y\u0006twMC\u0001:\u0003\u0011Q\u0017M^1\n\u0005m2$AB(cU\u0016\u001cG\u000f\u0005\u0002>}5\tQ#\u0003\u0002@+\tQ!*T!Q%>,H/Z:\u0002\u001b\u0005,H\u000f[3oi&\u001c\u0017\r^8s+\u0005\u0011\u0005CA\"G\u001b\u0005!%BA#\u0016\u0003\u0011AG\u000f\u001e9\n\u0005\u001d#%!D!vi\",g\u000e^5dCR|'/\u0001\bbkRDWM\u001c;jG\u0006$xN\u001d\u0011\u0002\u001fU\u001cXM\u001d)s_ZL7/[8oKJ\u0004\"aQ&\n\u00051#%\u0001E+tKJ\u0004&o\u001c<jg&|g.\u001b8h\u0003\u001dQW.\u00199Ba&\u0004\"aH(\n\u0005A\u001b\"a\u0002&N\u0003B\u000b\u0005/\u001b\u000b\u0005%N\u0003\u0017\r\u0005\u0002 \u000b!)\u0001I\u0003a\u0001\u0005\"\"1+V/_!\t16,D\u0001X\u0015\tA\u0016,\u0001\u0004j]*,7\r\u001e\u0006\u00025\u00069!.Y6beR\f\u0017B\u0001/X\u0005\u0015q\u0015-\\3e\u0003\u00151\u0018\r\\;fC\u0005y\u0016\u0001\u0003*G\u00076BdGM\u0019\t\u000b%S\u0001\u0019\u0001&\t\u000b5S\u0001\u0019\u0001()\u0005)\u0019\u0007C\u0001,e\u0013\t)wK\u0001\u0004J]*,7\r\u001e\u000b\u0002OB\u0019\u0001.\\8\u000e\u0003%T!A[6\u0002\rM$(/Z1n\u0015\ta\u0007(\u0001\u0003vi&d\u0017B\u00018j\u0005\u0019\u0019FO]3b[B\u0011Q\b]\u0005\u0003cV\u0011\u0011BS'B!J{W\u000f^3\u0002\tA|7\u000f\u001e\u000b\u0006i\u0006\r\u0011\u0011\u0004\t\u0004krtX\"\u0001<\u000b\u0005]D\u0018!\u00039vE2L7\u000f[3s\u0015\tI(0\u0001\u0003d_J,'\"A>\u0002\u000fI,\u0017m\u0019;pe&\u0011QP\u001e\u0002\u0005\u001b>tw\u000e\u0005\u00026\u007f&\u0019\u0011\u0011\u0001\u001c\u0003\tY{\u0017\u000e\u001a\u0005\b\u0003\u000ba\u0001\u0019AA\u0004\u0003EAG\u000f\u001e9TKJ4XM\u001d*fcV,7\u000f\u001e\t\u0005\u0003\u0013\t)\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\u0019\u0019XM\u001d<fe*\u0019Q)!\u0005\u000b\u0007\u0005M!0A\u0003oKR$\u00180\u0003\u0003\u0002\u0018\u0005-!!\u0005%uiB\u001cVM\u001d<feJ+\u0017/^3ti\"9\u00111\u0004\u0007A\u0002\u0005u\u0011A\u00055uiB\u001cVM\u001d<feJ+7\u000f]8og\u0016\u0004B!!\u0003\u0002 %!\u0011\u0011EA\u0006\u0005IAE\u000f\u001e9TKJ4XM\u001d*fgB|gn]3\u0002'I,\u0017/^3ti\u0006\u001b(j]8o'R\u0014X-Y7\u0015\t\u0005\u001d\u0012Q\b\t\u0007\u0003S\ty#a\r\u000e\u0005\u0005-\"bA<\u0002.)\u0011Q\u0005_\u0005\u0005\u0003c\tYCA\u0003T\u001b>tw\u000e\u0005\u0003\u00026\u0005eRBAA\u001c\u0015\tIX#\u0003\u0003\u0002<\u0005]\"!\u0004*fcV,7\u000f^(cU\u0016\u001cG\u000fC\u0004\u0002\u00065\u0001\r!a\u0002\u0002%A\f'o]3SKF,Xm\u001d;PE*,7\r\u001e\u000b\u0005\u0003\u0007\n\t\u0007\u0005\u0005\u0002F\u0005U\u00131LA\u001a\u001d\u0011\t9%!\u0015\u000f\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u0014\u001e\u0003\u0019a$o\\8u}%\tQ%C\u0002\u0002T\u0011\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002X\u0005e#AB#ji\",'OC\u0002\u0002T\u0011\u0002B!!\u0012\u0002^%!\u0011qLA-\u0005aIE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c\u0005\b\u0003Gr\u0001\u0019AA3\u0003-Ig\u000e];u'R\u0014X-Y7\u0011\t\u0005\u001d\u0014QN\u0007\u0003\u0003SR1!a\u001b9\u0003\tIw.\u0003\u0003\u0002p\u0005%$aC%oaV$8\u000b\u001e:fC6\fq\u0001\u001d:pG\u0016\u001c8\u000f\u0006\u0005\u0002v\u0005]\u00141PA?!\u0015\tI#a\f\u007f\u0011\u001d\tIh\u0004a\u0001\u0003g\tQB]3rk\u0016\u001cHo\u00142kK\u000e$\bbBA\u000e\u001f\u0001\u0007\u0011Q\u0004\u0005\b\u0003\u007fz\u0001\u0019AAA\u00039i\u0017-\u001b7c_b\u001cVm]:j_:\u0004B!a!\u0002\n6\u0011\u0011Q\u0011\u0006\u0004\u0003\u000f;\u0012aB7bS2\u0014w\u000e_\u0005\u0005\u0003\u0017\u000b)I\u0001\bNC&d'm\u001c=TKN\u001c\u0018n\u001c8\u0002\u0017!\fg\u000e\u001a7f\u000bJ\u0014xN\u001d\u000b\u0007\u0003k\n\t*a'\t\u000f\u0005M\u0005\u00031\u0001\u0002\u0016\u0006IA\u000f\u001b:po\u0006\u0014G.\u001a\t\u0005\u0003\u000b\n9*\u0003\u0003\u0002\u001a\u0006e#!\u0003+ie><\u0018M\u00197f\u0011\u001d\ti\n\u0005a\u0001\u0003;\t\u0001B]3ta>t7/Z\u0001\u000fe\u0016\u001c\bo\u001c8e\t\u0016$\u0018-\u001b7t)\u0019\t)(a)\u0002&\"9\u00111D\tA\u0002\u0005u\u0001bBAT#\u0001\u0007\u0011\u0011V\u0001\bI\u0016$\u0018-\u001b7t!\u0011\t)$a+\n\t\u00055\u0016q\u0007\u0002\u000f!J|'\r\\3n\t\u0016$\u0018-\u001b7t\u0001")
public class JMAPApiRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final UserProvisioning userProvisioner;
    private final JMAPApi jmapApi;

    public static Logger LOGGER() {
        return JMAPApiRoutes$.MODULE$.LOGGER();
    }

    public Mono<Void> handleInternalError(HttpServerResponse response, Logger logger, Throwable e) {
        return super.handleInternalError(response, logger, e);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse response, Logger logger, Throwable e) {
        return super.handleBadRequest(response, logger, e);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse response, Logger logger, Throwable e) {
        return super.handleAuthenticationFailure(response, logger, e);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.POST, (String)"/jmap")).action((httpServerRequest, httpServerResponse) -> this.post(httpServerRequest, httpServerResponse)).corsHeaders(), JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.OPTIONS, (String)"/jmap")).action(JMAPRoutes.CORS_CONTROL).corsHeaders()});
    }

    private Mono<Void> post(HttpServerRequest httpServerRequest, HttpServerResponse httpServerResponse) {
        return SMono$.MODULE$.apply((Publisher)this.authenticator().authenticate(httpServerRequest)).flatMap((Function1 & Serializable)mailboxSession -> $this.userProvisioner.provisionUser((MailboxSession)mailboxSession).then().then(this.requestAsJsonStream(httpServerRequest).flatMap((Function1 & Serializable)requestObject -> this.process((RequestObject)requestObject, httpServerResponse, (MailboxSession)mailboxSession)))).onErrorResume((Function1 & Serializable)throwable -> this.handleError((Throwable)throwable, httpServerResponse)).asJava().then();
    }

    private SMono<RequestObject> requestAsJsonStream(HttpServerRequest httpServerRequest) {
        return SMono$.MODULE$.fromPublisher((Publisher)httpServerRequest.receive().aggregate().asInputStream()).handle((Function2 & Serializable)(x0$1, x1$1) -> {
            JMAPApiRoutes.$anonfun$requestAsJsonStream$1(this, x0$1, x1$1);
            return BoxedUnit.UNIT;
        });
    }

    private Either<IllegalArgumentException, RequestObject> parseRequestObject(InputStream inputStream) {
        JsResult<RequestObject> jsResult = ResponseSerializer$.MODULE$.deserializeRequestObject(inputStream);
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            RequestObject requestObject = (RequestObject)jsSuccess.value();
            return new Right((Object)requestObject);
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            return new Left((Object)new IllegalArgumentException(ResponseSerializer$.MODULE$.serialize(jsError).toString()));
        }
        throw new MatchError(jsResult);
    }

    private SMono<Void> process(RequestObject requestObject, HttpServerResponse httpServerResponse, MailboxSession mailboxSession) {
        return this.jmapApi.process(requestObject, mailboxSession).map((Function1 & Serializable)responseObject -> ResponseSerializer$.MODULE$.serialize((ResponseObject)responseObject)).map((Function1 & Serializable)json -> Json$.MODULE$.stringify(json)).map((Function1 & Serializable)x$1 -> x$1.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(HttpResponseStatus.OK).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then()));
    }

    private SMono<Void> handleError(Throwable throwable, HttpServerResponse response) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof UnauthorizedException) {
            UnauthorizedException unauthorizedException = (UnauthorizedException)throwable2;
            return this.respondDetails(unauthorizedException.addHeaders(response), ProblemDetails$.MODULE$.forThrowable(throwable));
        }
        return this.respondDetails(response, ProblemDetails$.MODULE$.forThrowable(throwable));
    }

    private SMono<Void> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details) {
        return SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()).map((Function1 & Serializable)x$2 -> x$2.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then()));
    }

    public static final /* synthetic */ void $anonfun$requestAsJsonStream$1(JMAPApiRoutes $this, InputStream x0$1, SynchronousSink x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            InputStream input = (InputStream)tuple2._1();
            SynchronousSink sink = (SynchronousSink)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.parseRequestObject(input).fold((Function1 & Serializable)x$1 -> {
                sink.error(x$1);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)x$1 -> {
                sink.next((Object)x$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Inject
    public JMAPApiRoutes(@Named(value="RFC-8621") Authenticator authenticator, UserProvisioning userProvisioner, JMAPApi jmapApi) {
        this.authenticator = authenticator;
        this.userProvisioner = userProvisioner;
        this.jmapApi = jmapApi;
    }
}

