/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.james.core.Username;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.Registration;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.api.change.TypeStateFactory;
import org.apache.james.jmap.change.AccountIdRegistrationKey$;
import org.apache.james.jmap.change.StateChangeListener;
import org.apache.james.jmap.core.OutboundMessage;
import org.apache.james.jmap.core.PingMessage;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.StateChange;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.http.UserProvisioning;
import org.apache.james.jmap.json.PushSerializer;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.routes.ClientContext;
import org.apache.james.jmap.routes.EventSourceOptions;
import org.apache.james.jmap.routes.EventSourceOptionsFactory;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.user.api.DelegationStore;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.Json$;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function1;
import scala.NotImplementedError;
import scala.Option;
import scala.collection.Iterable;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001B\b\u0011\u0001mA\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005U!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u0011a\u0003!\u0011!Q\u0001\neCQ\u0001\u0019\u0001\u0005\u0002\u0005DQ!\u0005\u0001\u0005BIDQA \u0001\u0005\n}Dq!a\u000f\u0001\t\u0013\ti\u0004C\u0004\u0002t\u0001!I!!\u001e\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\"9\u0011\u0011\u0018\u0001\u0005\n\u0005m&!E#wK:$8k\\;sG\u0016\u0014v.\u001e;fg*\u0011\u0011CE\u0001\u0007e>,H/Z:\u000b\u0005M!\u0012\u0001\u00026nCBT!!\u0006\f\u0002\u000b)\fW.Z:\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\r\u0001A\u0004\n\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\nA\u0001\\1oO*\t\u0011%\u0001\u0003kCZ\f\u0017BA\u0012\u001f\u0005\u0019y%M[3diB\u0011QEJ\u0007\u0002%%\u0011qE\u0005\u0002\u000b\u00156\u000b\u0005KU8vi\u0016\u001c\u0018!D1vi\",g\u000e^5dCR|'/F\u0001+!\tYc&D\u0001-\u0015\ti##\u0001\u0003iiR\u0004\u0018BA\u0018-\u00055\tU\u000f\u001e5f]RL7-\u0019;pe\u0006q\u0011-\u001e;iK:$\u0018nY1u_J\u0004\u0013aD;tKJ\u0004&o\u001c<jg&|g.\u001a:\u0011\u0005-\u001a\u0014B\u0001\u001b-\u0005A)6/\u001a:Qe>4\u0018n]5p]&tw-\u0001\u0005fm\u0016tGOQ;t!\t9$(D\u00019\u0015\tID#\u0001\u0004fm\u0016tGo]\u0005\u0003wa\u0012\u0001\"\u0012<f]R\u0014Uo\u001d\u0015\u0005\tu*e\t\u0005\u0002?\u00076\tqH\u0003\u0002A\u0003\u00061\u0011N\u001c6fGRT\u0011AQ\u0001\bU\u0006\\\u0017M\u001d;b\u0013\t!uHA\u0003OC6,G-A\u0003wC2,X-I\u0001H\u0003\u0011QU*\u0011)\u0002\u001dA,8\u000f[*fe&\fG.\u001b>feB\u0011!*T\u0007\u0002\u0017*\u0011AJE\u0001\u0005UN|g.\u0003\u0002O\u0017\nq\u0001+^:i'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018\u0001\u0005;za\u0016\u001cF/\u0019;f\r\u0006\u001cGo\u001c:z!\t\tf+D\u0001S\u0015\t\u0019F+\u0001\u0004dQ\u0006tw-\u001a\u0006\u0003+J\t1!\u00199j\u0013\t9&K\u0001\tUsB,7\u000b^1uK\u001a\u000b7\r^8ss\u0006yA-\u001a7fO\u0006$\u0018n\u001c8Ti>\u0014X\r\u0005\u0002[=6\t1L\u0003\u0002V9*\u0011Q\fF\u0001\u0005kN,'/\u0003\u0002`7\nyA)\u001a7fO\u0006$\u0018n\u001c8Ti>\u0014X-\u0001\u0004=S:LGO\u0010\u000b\bE\u0012D\u0017n\u001b7n!\t\u0019\u0007!D\u0001\u0011\u0011\u0015A\u0003\u00021\u0001+Q\u0011!W(\u00124\"\u0003\u001d\f\u0001B\u0015$D[a2$'\r\u0005\u0006c!\u0001\rA\r\u0005\u0006k!\u0001\rA\u000e\u0015\u0005Sv*e\tC\u0003I\u0011\u0001\u0007\u0011\nC\u0003P\u0011\u0001\u0007\u0001\u000bC\u0003Y\u0011\u0001\u0007\u0011\f\u000b\u0002\t_B\u0011a\b]\u0005\u0003c~\u0012a!\u00138kK\u000e$H#A:\u0011\u0007QL80D\u0001v\u0015\t1x/\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003q\u0002\nA!\u001e;jY&\u0011!0\u001e\u0002\u0007'R\u0014X-Y7\u0011\u0005\u0015b\u0018BA?\u0013\u0005%QU*\u0011)S_V$X-A\u0005iC:$G.Z*T\u000bR1\u0011\u0011AA\u000e\u0003c\u0001b!a\u0001\u0002\u0012\u0005UQBAA\u0003\u0015\u0011\t9!!\u0003\u0002\u0013A,(\r\\5tQ\u0016\u0014(\u0002BA\u0006\u0003\u001b\tAaY8sK*\u0011\u0011qB\u0001\be\u0016\f7\r^8s\u0013\u0011\t\u0019\"!\u0002\u0003\t5{gn\u001c\t\u0004;\u0005]\u0011bAA\r=\t!ak\\5e\u0011\u001d\tiB\u0003a\u0001\u0003?\tqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002\"\u00055RBAA\u0012\u0015\u0011\t)#a\n\u0002\rM,'O^3s\u0015\ri\u0013\u0011\u0006\u0006\u0005\u0003W\ti!A\u0003oKR$\u00180\u0003\u0003\u00020\u0005\r\"!\u0005%uiB\u001cVM\u001d<feJ+\u0017/^3ti\"9\u00111\u0007\u0006A\u0002\u0005U\u0012\u0001\u0003:fgB|gn]3\u0011\t\u0005\u0005\u0012qG\u0005\u0005\u0003s\t\u0019C\u0001\nIiR\u00048+\u001a:wKJ\u0014Vm\u001d9p]N,\u0017a\u0003:fO&\u001cH/\u001a:T'\u0016#\u0002\"a\u0010\u0002X\u0005e\u0013\u0011\u000e\t\u0007\u0003\u0003\nI%!\u0014\u000e\u0005\u0005\r#\u0002BA\u0004\u0003\u000bRA!a\u0012\u0002\n\u0005)1oY1mC&!\u00111JA\"\u0005\u0015\u0019Vj\u001c8p!\u0011\ty%a\u0015\u000e\u0005\u0005E#BAA$\u0013\u0011\t)&!\u0015\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003gY\u0001\u0019AA\u001b\u0011\u001d\tYf\u0003a\u0001\u0003;\nqa]3tg&|g\u000e\u0005\u0003\u0002`\u0005\u0015TBAA1\u0015\r\t\u0019\u0007F\u0001\b[\u0006LGNY8y\u0013\u0011\t9'!\u0019\u0003\u001d5\u000b\u0017\u000e\u001c2pqN+7o]5p]\"9\u00111N\u0006A\u0002\u00055\u0014aB8qi&|gn\u001d\t\u0004G\u0006=\u0014bAA9!\t\u0011RI^3oiN{WO]2f\u001fB$\u0018n\u001c8t\u0003)\t7oU*F\u000bZ,g\u000e\u001e\u000b\u0005\u0003o\ni\t\u0005\u0003\u0002z\u0005\u001de\u0002BA>\u0003\u0007\u0003B!! \u0002R5\u0011\u0011q\u0010\u0006\u0004\u0003\u0003S\u0012A\u0002\u001fs_>$h(\u0003\u0003\u0002\u0006\u0006E\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\n\u0006-%AB*ue&twM\u0003\u0003\u0002\u0006\u0006E\u0003bBAH\u0019\u0001\u0007\u0011\u0011S\u0001\u0010_V$(m\\;oI6+7o]1hKB!\u00111SAL\u001b\t\t)JC\u0002\u0002\fIIA!!'\u0002\u0016\nyq*\u001e;c_VtG-T3tg\u0006<W-\u0001\u0012iC:$G.Z\"p]:,7\r^5p]\u0016\u001bH/\u00192mSNDW.\u001a8u\u000bJ\u0014xN\u001d\u000b\u0007\u0003?\u000b\t+a.\u0011\r\u0005\u0005\u0013\u0011JA\u000b\u0011\u001d\t\u0019+\u0004a\u0001\u0003K\u000b\u0011\u0002\u001e5s_^\f'\r\\3\u0011\t\u0005\u001d\u0016\u0011\u0017\b\u0005\u0003S\u000biK\u0004\u0003\u0002~\u0005-\u0016BAA$\u0013\u0011\ty+!\u0015\u0002\u000fA\f7m[1hK&!\u00111WA[\u0005%!\u0006N]8xC\ndWM\u0003\u0003\u00020\u0006E\u0003bBA\u001a\u001b\u0001\u0007\u0011QG\u0001\u000fe\u0016\u001c\bo\u001c8e\t\u0016$\u0018-\u001b7t)\u0019\ty*!0\u0002@\"9\u00111\u0007\bA\u0002\u0005U\u0002bBAa\u001d\u0001\u0007\u00111Y\u0001\bI\u0016$\u0018-\u001b7t!\u0011\t\u0019*!2\n\t\u0005\u001d\u0017Q\u0013\u0002\u000f!J|'\r\\3n\t\u0016$\u0018-\u001b7t\u0001")
public class EventSourceRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final UserProvisioning userProvisioner;
    @Named(value="JMAP")
    private final EventBus eventBus;
    private final PushSerializer pushSerializer;
    private final TypeStateFactory typeStateFactory;
    private final DelegationStore delegationStore;

    public Mono<Void> handleInternalError(HttpServerResponse response, Logger logger, Throwable e) {
        return super.handleInternalError(response, logger, e);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse response, Logger logger, Throwable e) {
        return super.handleBadRequest(response, logger, e);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse response, Logger logger, Throwable e) {
        return super.handleAuthenticationFailure(response, logger, e);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.GET, "/eventSource")).action((request, response) -> this.handleSSE(request, response)).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, "/eventSource")).action(JMAPRoutes.CORS_CONTROL).corsHeaders()});
    }

    private Mono<Void> handleSSE(HttpServerRequest request, HttpServerResponse response) {
        return ((SMono)new EventSourceOptionsFactory(this.typeStateFactory).forRequest(request).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)options -> SMono$.MODULE$.apply((Publisher)this.authenticator().authenticate(request)).flatMap((Function1 & Serializable)mailboxSession -> $this.userProvisioner.provisionUser((MailboxSession)mailboxSession).then().then(this.registerSSE(response, (MailboxSession)mailboxSession, (EventSourceOptions)options))))).onErrorResume((Function1 & Serializable)throwable -> this.handleConnectionEstablishmentError((Throwable)throwable, response)).asJava().then();
    }

    private SMono<BoxedUnit> registerSSE(HttpServerResponse response, MailboxSession session, EventSourceOptions options) {
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        ClientContext context = new ClientContext((Sinks.Many<OutboundMessage>)sink, new AtomicReference<Registration>(), session);
        SFlux<PingMessage> qual$1 = options.pingPolicy().asFlux();
        Function1 & Serializable x$1 = (Function1 & Serializable)ping -> {
            EventSourceRoutes.$anonfun$registerSSE$1(context, ping);
            return BoxedUnit.UNIT;
        };
        Option x$2 = qual$1.subscribe$default$2();
        Option x$3 = qual$1.subscribe$default$3();
        Disposable pingDisposable = qual$1.subscribe((Function1)x$1, x$2, x$3);
        SMono$.MODULE$.just((Object)session.getUser()).concatWith((Publisher)SFlux$.MODULE$.fromPublisher(this.delegationStore.delegatedUsers(session.getUser()))).map((Function1 & Serializable)username -> AccountIdRegistrationKey$.MODULE$.of((Username)username)).collectSeq().flatMap((Function1 & Serializable)keys -> SMono$.MODULE$.apply($this.eventBus.register((EventListener.ReactiveEventListener)new StateChangeListener(options.types(), context.outbound()), CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)keys).asJavaCollection()))).doOnNext((Function1 & Serializable)newRegistration -> {
            context.withRegistration(newRegistration);
            return BoxedUnit.UNIT;
        }).subscribeOn(Schedulers.boundedElastic()).subscribe();
        return SMono$.MODULE$.apply((Publisher)response.addHeader((CharSequence)"Connection", (CharSequence)"keep-alive").sse().sendString((Publisher)options.closeAfter().applyOn((SFlux<OutboundMessage>)SFlux$.MODULE$.apply((Publisher)sink.asFlux())).map((Function1 & Serializable)outboundMessage -> this.asSSEEvent((OutboundMessage)outboundMessage)), StandardCharsets.UTF_8).then().doFinally(x$5 -> context.clean()).doFinally(x$6 -> pingDisposable.dispose()).then()).then();
    }

    private String asSSEEvent(OutboundMessage outboundMessage) {
        String string2;
        OutboundMessage outboundMessage2 = outboundMessage;
        if (outboundMessage2 instanceof PingMessage) {
            string2 = "ping";
        } else if (outboundMessage2 instanceof StateChange) {
            string2 = "state";
        } else {
            throw new NotImplementedError();
        }
        String event = string2;
        return "event: " + event + "\ndata: " + Json$.MODULE$.stringify(this.pushSerializer.serializeSSE(outboundMessage)) + "\n\n";
    }

    private SMono<Void> handleConnectionEstablishmentError(Throwable throwable, HttpServerResponse response) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof UnauthorizedException) {
            UnauthorizedException unauthorizedException = (UnauthorizedException)throwable2;
            return this.respondDetails(unauthorizedException.addHeaders(response), ProblemDetails$.MODULE$.forThrowable(throwable));
        }
        return this.respondDetails(response, ProblemDetails$.MODULE$.forThrowable(throwable));
    }

    private SMono<Void> respondDetails(HttpServerResponse response, ProblemDetails details) {
        return SMono$.MODULE$.fromPublisher((Publisher)response.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").sendString((Publisher)SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()), StandardCharsets.UTF_8).then());
    }

    public static final /* synthetic */ void $anonfun$registerSSE$1(ClientContext context$1, PingMessage ping) {
        context$1.outbound().emitNext((Object)ping, Sinks.EmitFailureHandler.FAIL_FAST);
    }

    @Inject
    public EventSourceRoutes(@Named(value="RFC-8621") Authenticator authenticator, UserProvisioning userProvisioner, @Named(value="JMAP") EventBus eventBus, PushSerializer pushSerializer, TypeStateFactory typeStateFactory, DelegationStore delegationStore) {
        this.authenticator = authenticator;
        this.userProvisioner = userProvisioner;
        this.eventBus = eventBus;
        this.pushSerializer = pushSerializer;
        this.typeStateFactory = typeStateFactory;
        this.delegationStore = delegationStore;
    }
}

