/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.Refined;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.mail.MailboxGet$;
import org.apache.james.jmap.mail.MailboxSetError$;
import org.apache.james.jmap.mail.MailboxSetRequest;
import org.apache.james.jmap.mail.RemoveEmailsOnDestroy;
import org.apache.james.jmap.mail.UnparsedMailboxId;
import org.apache.james.jmap.method.MailboxHasChildException;
import org.apache.james.jmap.method.MailboxHasMailException;
import org.apache.james.jmap.method.MailboxSetDeletePerformer$;
import org.apache.james.jmap.method.MailboxSetDeletePerformer$MailboxDeletionResults$;
import org.apache.james.jmap.method.SystemMailboxChangeException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageRange;
import org.reactivestreams.Publisher;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rmt!B,Y\u0011\u0003\u0019g!B3Y\u0011\u00031\u0007\"B7\u0002\t\u0003q\u0007bB8\u0002\u0005\u0004%I\u0001\u001d\u0005\u0007o\u0006\u0001\u000b\u0011B9\u0007\u000fa\f\u0001\u0013aI\u0011s\u001a1\u0011Q[\u0001A\u0003/D!\"!\b\u0007\u0005+\u0007I\u0011AAm\u0011)\tiC\u0002B\tB\u0003%\u00111\u001c\u0005\u0007[\u001a!\t!a;\t\u0013\u0005Mc!!A\u0005\u0002\u0005E\b\"CA.\rE\u0005I\u0011AA{\u0011%\tIHBA\u0001\n\u0003\nY\bC\u0005\u0002\u000e\u001a\t\t\u0011\"\u0001\u0002\u0010\"I\u0011q\u0013\u0004\u0002\u0002\u0013\u0005\u0011\u0011 \u0005\n\u0003K3\u0011\u0011!C!\u0003OC\u0011\"!.\u0007\u0003\u0003%\t!!@\t\u0013\u0005\u0005g!!A\u0005B\t\u0005\u0001\"CAd\r\u0005\u0005I\u0011IAe\u0011%\tYMBA\u0001\n\u0003\ni\rC\u0005\u0002P\u001a\t\t\u0011\"\u0011\u0003\u0006\u001dI!\u0011B\u0001\u0002\u0002#\u0005!1\u0002\u0004\n\u0003+\f\u0011\u0011!E\u0001\u0005\u001bAa!\u001c\f\u0005\u0002\t\u0015\u0002\"CAf-\u0005\u0005IQIAg\u0011%\u00119CFA\u0001\n\u0003\u0013I\u0003C\u0005\u0003.Y\t\t\u0011\"!\u00030!I!1\b\f\u0002\u0002\u0013%!Q\b\u0004\u0005w\u0006\u0001E\u0010\u0003\u0006\u0002\u001eq\u0011)\u001a!C\u0001\u0003?A!\"!\f\u001d\u0005#\u0005\u000b\u0011BA\u0011\u0011)\ty\u0003\bBK\u0002\u0013\u0005\u0011\u0011\u0007\u0005\u000b\u0003sa\"\u0011#Q\u0001\n\u0005M\u0002BB7\u001d\t\u0003\tY\u0004C\u0004\u0002Dq!\t!!\u0012\t\u0013\u0005MC$!A\u0005\u0002\u0005U\u0003\"CA.9E\u0005I\u0011AA/\u0011%\t\u0019\bHI\u0001\n\u0003\t)\bC\u0005\u0002zq\t\t\u0011\"\u0011\u0002|!I\u0011Q\u0012\u000f\u0002\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0003/c\u0012\u0011!C\u0001\u00033C\u0011\"!*\u001d\u0003\u0003%\t%a*\t\u0013\u0005UF$!A\u0005\u0002\u0005]\u0006\"CAa9\u0005\u0005I\u0011IAb\u0011%\t9\rHA\u0001\n\u0003\nI\rC\u0005\u0002Lr\t\t\u0011\"\u0011\u0002N\"I\u0011q\u001a\u000f\u0002\u0002\u0013\u0005\u0013\u0011[\u0004\n\u0005\u000b\n\u0011\u0011!E\u0001\u0005\u000f2\u0001b_\u0001\u0002\u0002#\u0005!\u0011\n\u0005\u0007[B\"\tA!\u0015\t\u0013\u0005-\u0007'!A\u0005F\u00055\u0007\"\u0003B\u0014a\u0005\u0005I\u0011\u0011B*\u0011%\u0011i\u0003MA\u0001\n\u0003\u0013I\u0006C\u0005\u0003<A\n\t\u0011\"\u0003\u0003>\u00191!QM\u0001A\u0005OB!B!\u001b7\u0005+\u0007I\u0011\u0001B6\u0011)\u0011\u0019H\u000eB\tB\u0003%!Q\u000e\u0005\u0007[Z\"\tA!\u001e\t\u000f\tmd\u0007\"\u0001\u0003~!9!\u0011\u0011\u001c\u0005\u0002\t\r\u0005\"CA*m\u0005\u0005I\u0011\u0001BK\u0011%\tYFNI\u0001\n\u0003\u0011I\nC\u0005\u0002zY\n\t\u0011\"\u0011\u0002|!I\u0011Q\u0012\u001c\u0002\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0003/3\u0014\u0011!C\u0001\u0005;C\u0011\"!*7\u0003\u0003%\t%a*\t\u0013\u0005Uf'!A\u0005\u0002\t\u0005\u0006\"CAam\u0005\u0005I\u0011\tBS\u0011%\t9MNA\u0001\n\u0003\nI\rC\u0005\u0002LZ\n\t\u0011\"\u0011\u0002N\"I\u0011q\u001a\u001c\u0002\u0002\u0013\u0005#\u0011V\u0004\n\u0005[\u000b\u0011\u0011!E\u0001\u0005_3\u0011B!\u001a\u0002\u0003\u0003E\tA!-\t\r5DE\u0011\u0001B[\u0011%\tY\rSA\u0001\n\u000b\ni\rC\u0005\u0003(!\u000b\t\u0011\"!\u00038\"I!Q\u0006%\u0002\u0002\u0013\u0005%1\u0018\u0005\n\u0005wA\u0015\u0011!C\u0005\u0005{1Q!\u001a-\u0001\u0005\u0003D!Ba1O\u0005\u0003\u0005\u000b\u0011\u0002Bc\u0011)\u0011iM\u0014B\u0001B\u0003%!q\u001a\u0005\u000b\u0005+t%\u0011!Q\u0001\n\t]\u0007BB7O\t\u0003\u0011)\u000fC\u0004\u0004\u00029#\taa\u0001\t\u000f\r\u0015c\n\"\u0003\u0004H!91Q\f(\u0005\n\r}\u0003bBB8\u001d\u0012%1\u0011O\u0001\u001a\u001b\u0006LGNY8y'\u0016$H)\u001a7fi\u0016\u0004VM\u001d4pe6,'O\u0003\u0002Z5\u00061Q.\u001a;i_\u0012T!a\u0017/\u0002\t)l\u0017\r\u001d\u0006\u0003;z\u000bQA[1nKNT!a\u00181\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0017aA8sO\u000e\u0001\u0001C\u00013\u0002\u001b\u0005A&!G'bS2\u0014w\u000e_*fi\u0012+G.\u001a;f!\u0016\u0014hm\u001c:nKJ\u001c\"!A4\u0011\u0005!\\W\"A5\u000b\u0003)\fQa]2bY\u0006L!\u0001\\5\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1-\u0001\u0004M\u001f\u001e;UIU\u000b\u0002cB\u0011!/^\u0007\u0002g*\u0011A\u000fY\u0001\u0006g24GG[\u0005\u0003mN\u0014a\u0001T8hO\u0016\u0014\u0018a\u0002'P\u000f\u001e+%\u000b\t\u0002\u0016\u001b\u0006LGNY8y\t\u0016dW\r^5p]J+7/\u001e7u'\t)q-K\u0002\u00069\u0019\u0011a#T1jY\n|\u0007\u0010R3mKRLwN\u001c$bS2,(/Z\n\u00079\u001dlx0!\u0002\u0011\u0005y,Q\"A\u0001\u0011\u0007!\f\t!C\u0002\u0002\u0004%\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002\b\u0005]a\u0002BA\u0005\u0003'qA!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f\u0011\u0017A\u0002\u001fs_>$h(C\u0001k\u0013\r\t)\"[\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI\"a\u0007\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0007\u0005U\u0011.A\u0005nC&d'm\u001c=JIV\u0011\u0011\u0011\u0005\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011q\u0005.\u0002\t5\f\u0017\u000e\\\u0005\u0005\u0003W\t)CA\tV]B\f'o]3e\u001b\u0006LGNY8y\u0013\u0012\f!\"\\1jY\n|\u00070\u00133!\u0003%)\u0007pY3qi&|g.\u0006\u0002\u00024A!\u0011qAA\u001b\u0013\u0011\t9$a\u0007\u0003\u0013QC'o\\<bE2,\u0017AC3yG\u0016\u0004H/[8oAQ1\u0011QHA \u0003\u0003\u0002\"A \u000f\t\u000f\u0005u\u0011\u00051\u0001\u0002\"!9\u0011qF\u0011A\u0002\u0005M\u0012!E1t\u001b\u0006LGNY8y'\u0016$XI\u001d:peV\u0011\u0011q\t\t\u0005\u0003\u0013\ny%\u0004\u0002\u0002L)\u0019\u0011Q\n.\u0002\t\r|'/Z\u0005\u0005\u0003#\nYE\u0001\u0005TKR,%O]8s\u0003\u0011\u0019w\u000e]=\u0015\r\u0005u\u0012qKA-\u0011%\tib\tI\u0001\u0002\u0004\t\t\u0003C\u0005\u00020\r\u0002\n\u00111\u0001\u00024\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA0U\u0011\t\t#!\u0019,\u0005\u0005\r\u0004\u0003BA3\u0003_j!!a\u001a\u000b\t\u0005%\u00141N\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001cj\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\n9GA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002x)\"\u00111GA1\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0010\t\u0005\u0003\u007f\nI)\u0004\u0002\u0002\u0002*!\u00111QAC\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0015\u0001\u00026bm\u0006LA!a#\u0002\u0002\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!%\u0011\u0007!\f\u0019*C\u0002\u0002\u0016&\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a'\u0002\"B\u0019\u0001.!(\n\u0007\u0005}\u0015NA\u0002B]fD\u0011\"a))\u0003\u0003\u0005\r!!%\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\u000b\u0005\u0004\u0002,\u0006E\u00161T\u0007\u0003\u0003[S1!a,j\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003g\u000biK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA]\u0003\u007f\u00032\u0001[A^\u0013\r\ti,\u001b\u0002\b\u0005>|G.Z1o\u0011%\t\u0019KKA\u0001\u0002\u0004\tY*\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA?\u0003\u000bD\u0011\"a),\u0003\u0003\u0005\r!!%\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!%\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!! \u0002\r\u0015\fX/\u00197t)\u0011\tI,a5\t\u0013\u0005\rf&!AA\u0002\u0005m%AF'bS2\u0014w\u000e\u001f#fY\u0016$\u0018n\u001c8Tk\u000e\u001cWm]:\u0014\r\u00199Wp`A\u0003+\t\tY\u000e\u0005\u0003\u0002^\u0006\u001dXBAAp\u0015\u0011\t\t/a9\u0002\u000b5|G-\u001a7\u000b\u0007\u0005\u0015H,A\u0004nC&d'm\u001c=\n\t\u0005%\u0018q\u001c\u0002\n\u001b\u0006LGNY8y\u0013\u0012$B!!<\u0002pB\u0011aP\u0002\u0005\b\u0003;I\u0001\u0019AAn)\u0011\ti/a=\t\u0013\u0005u!\u0002%AA\u0002\u0005mWCAA|U\u0011\tY.!\u0019\u0015\t\u0005m\u00151 \u0005\n\u0003Gs\u0011\u0011!a\u0001\u0003##B!!/\u0002\u0000\"I\u00111\u0015\t\u0002\u0002\u0003\u0007\u00111\u0014\u000b\u0005\u0003{\u0012\u0019\u0001C\u0005\u0002$F\t\t\u00111\u0001\u0002\u0012R!\u0011\u0011\u0018B\u0004\u0011%\t\u0019\u000bFA\u0001\u0002\u0004\tY*\u0001\fNC&d'm\u001c=EK2,G/[8o'V\u001c7-Z:t!\tqhcE\u0003\u0017\u0005\u001f\u0011Y\u0002\u0005\u0005\u0003\u0012\t]\u00111\\Aw\u001b\t\u0011\u0019BC\u0002\u0003\u0016%\fqA];oi&lW-\u0003\u0003\u0003\u001a\tM!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!!Q\u0004B\u0012\u001b\t\u0011yB\u0003\u0003\u0003\"\u0005\u0015\u0015AA5p\u0013\u0011\tIBa\b\u0015\u0005\t-\u0011!B1qa2LH\u0003BAw\u0005WAq!!\b\u001a\u0001\u0004\tY.A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tE\"q\u0007\t\u0006Q\nM\u00121\\\u0005\u0004\u0005kI'AB(qi&|g\u000eC\u0005\u0003:i\t\t\u00111\u0001\u0002n\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t}\u0002\u0003BA@\u0005\u0003JAAa\u0011\u0002\u0002\n1qJ\u00196fGR\fa#T1jY\n|\u0007\u0010R3mKRLwN\u001c$bS2,(/\u001a\t\u0003}B\u001aR\u0001\rB&\u00057\u0001\"B!\u0005\u0003N\u0005\u0005\u00121GA\u001f\u0013\u0011\u0011yEa\u0005\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0003HQ1\u0011Q\bB+\u0005/Bq!!\b4\u0001\u0004\t\t\u0003C\u0004\u00020M\u0002\r!a\r\u0015\t\tm#1\r\t\u0006Q\nM\"Q\f\t\bQ\n}\u0013\u0011EA\u001a\u0013\r\u0011\t'\u001b\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\teB'!AA\u0002\u0005u\"AF'bS2\u0014w\u000e\u001f#fY\u0016$\u0018n\u001c8SKN,H\u000e^:\u0014\u000bY:w0!\u0002\u0002\u000fI,7/\u001e7ugV\u0011!Q\u000e\t\u0006\u0003\u000f\u0011y'`\u0005\u0005\u0005c\nYBA\u0002TKF\f\u0001B]3tk2$8\u000f\t\u000b\u0005\u0005o\u0012I\b\u0005\u0002\u007fm!9!\u0011N\u001dA\u0002\t5\u0014!\u00033fgR\u0014x._3e+\t\u0011y\b\u0005\u0004\u0002\b\t=\u00141\\\u0001\u000fe\u0016$(/[3wK\u0016\u0013(o\u001c:t+\t\u0011)\t\u0005\u0005\u0003\b\n=\u0015\u0011EA$\u001d\u0011\u0011IIa#\u0011\u0007\u0005-\u0011.C\u0002\u0003\u000e&\fa\u0001\u0015:fI\u00164\u0017\u0002\u0002BI\u0005'\u00131!T1q\u0015\r\u0011i)\u001b\u000b\u0005\u0005o\u00129\nC\u0005\u0003jq\u0002\n\u00111\u0001\u0003nU\u0011!1\u0014\u0016\u0005\u0005[\n\t\u0007\u0006\u0003\u0002\u001c\n}\u0005\"CAR\u0001\u0006\u0005\t\u0019AAI)\u0011\tILa)\t\u0013\u0005\r&)!AA\u0002\u0005mE\u0003BA?\u0005OC\u0011\"a)D\u0003\u0003\u0005\r!!%\u0015\t\u0005e&1\u0016\u0005\n\u0003G3\u0015\u0011!a\u0001\u00037\u000ba#T1jY\n|\u0007\u0010R3mKRLwN\u001c*fgVdGo\u001d\t\u0003}\"\u001bR\u0001\u0013BZ\u00057\u0001\u0002B!\u0005\u0003\u0018\t5$q\u000f\u000b\u0003\u0005_#BAa\u001e\u0003:\"9!\u0011N&A\u0002\t5D\u0003\u0002B_\u0005\u007f\u0003R\u0001\u001bB\u001a\u0005[B\u0011B!\u000fM\u0003\u0003\u0005\rAa\u001e\u0014\u00059;\u0017AD7bS2\u0014w\u000e_'b]\u0006<WM\u001d\t\u0005\u0005\u000f\u0014I-\u0004\u0002\u0002d&!!1ZAr\u00059i\u0015-\u001b7c_bl\u0015M\\1hKJ\f1c];cg\u000e\u0014\u0018\u000e\u001d;j_:l\u0015M\\1hKJ\u0004BAa2\u0003R&!!1[Ar\u0005M\u0019VOY:de&\u0004H/[8o\u001b\u0006t\u0017mZ3s\u0003Ai\u0017-\u001b7c_bLEMR1di>\u0014\u0018\u0010\u0005\u0003\u0003Z\n}g\u0002BAo\u00057LAA!8\u0002`\u0006IQ*Y5mE>D\u0018\nZ\u0005\u0005\u0005C\u0014\u0019OA\u0004GC\u000e$xN]=\u000b\t\tu\u0017q\u001c\u000b\t\u0005O\u0014IOa;\u0003nB\u0011AM\u0014\u0005\b\u0005\u0007\u0014\u0006\u0019\u0001Bc\u0011\u001d\u0011iM\u0015a\u0001\u0005\u001fDqA!6S\u0001\u0004\u00119\u000eK\u0002S\u0005c\u0004BAa=\u0003~6\u0011!Q\u001f\u0006\u0005\u0005o\u0014I0\u0001\u0004j]*,7\r\u001e\u0006\u0003\u0005w\fqA[1lCJ$\u0018-\u0003\u0003\u0003\u0000\nU(AB%oU\u0016\u001cG/A\beK2,G/Z'bS2\u0014w\u000e_3t)\u0019\u0019)a!\r\u0004<A11qAB\u000b\u00073i!a!\u0003\u000b\t\r-1QB\u0001\naV\u0014G.[:iKJT1A[B\b\u0015\u0011\tie!\u0005\u000b\u0005\rM\u0011a\u0002:fC\u000e$xN]\u0005\u0005\u0007/\u0019IAA\u0003T\u001b>tw\u000eE\u0002\u0004\u001cYr1a!\b\u0001\u001d\u0011\u0019yba\f\u000f\t\r\u00052Q\u0006\b\u0005\u0007G\u0019YC\u0004\u0003\u0004&\r%b\u0002BA\u0006\u0007OI\u0011!Y\u0005\u0003?\u0002L!!\u00180\n\u0005mc\u0016BA-[\u0011\u001d\u0019\u0019d\u0015a\u0001\u0007k\ta\"\\1jY\n|\u0007pU3tg&|g\u000e\u0005\u0003\u0003H\u000e]\u0012\u0002BB\u001d\u0003G\u0014a\"T1jY\n|\u0007pU3tg&|g\u000eC\u0004\u0004>M\u0003\raa\u0010\u0002#5\f\u0017\u000e\u001c2pqN+GOU3rk\u0016\u001cH\u000f\u0005\u0003\u0002$\r\u0005\u0013\u0002BB\"\u0003K\u0011\u0011#T1jY\n|\u0007pU3u%\u0016\fX/Z:u\u0003\u0019!W\r\\3uKRA1\u0011JB'\u0007\u001f\u001a\u0019\u0006\u0005\u0004\u0004\b\rU11\n\t\u0004\u00077)\u0001bBB\u001a)\u0002\u00071Q\u0007\u0005\b\u0007#\"\u0006\u0019AA\u0011\u0003\tIG\rC\u0004\u0004VQ\u0003\raa\u0016\u0002\u0013=tG)Z:ue>L\b\u0003BA\u0012\u00073JAaa\u0017\u0002&\t)\"+Z7pm\u0016,U.Y5mg>sG)Z:ue>L\u0018\u0001\u00033p\t\u0016dW\r^3\u0015\u0011\r\u00054\u0011NB6\u0007[\u0002baa\u0002\u0004\u0016\r\r\u0004c\u00015\u0004f%\u00191qM5\u0003\tUs\u0017\u000e\u001e\u0005\b\u0007g)\u0006\u0019AB\u001b\u0011\u001d\u0019\t&\u0016a\u0001\u00037Dqa!\u0016V\u0001\u0004\u00199&\u0001\tjg\u0006\u001b\u0016p\u001d;f[6\u000b\u0017\u000e\u001c2pqR!\u0011\u0011XB:\u0011\u001d\t)O\u0016a\u0001\u0007k\u0002BAa2\u0004x%!1\u0011PAr\u00059iUm]:bO\u0016l\u0015M\\1hKJ\u0004")
public class MailboxSetDeletePerformer {
    private final MailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;
    private final MailboxId.Factory mailboxIdFactory;

    public SMono<MailboxDeletionResults> deleteMailboxes(MailboxSession mailboxSession, MailboxSetRequest mailboxSetRequest) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)((IterableOnceOps)mailboxSetRequest.destroy().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).toSet());
        Function1 & Serializable x$1 = (Function1 & Serializable)id -> this.delete(mailboxSession, (UnparsedMailboxId)id, ((RemoveEmailsOnDestroy)mailboxSetRequest.onDestroyRemoveEmails().getOrElse((Function0 & Serializable)() -> new RemoveEmailsOnDestroy(MailboxSetDeletePerformer.$anonfun$deleteMailboxes$3()))).value()).onErrorRecover((PartialFunction)new Serializable(null, (UnparsedMailboxId)id){
            private static final long serialVersionUID = 0L;
            private final UnparsedMailboxId id$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 e, Function1<A1, B1> function1) {
                A1 A1 = e;
                return (B1)new MailboxDeletionFailure(this.id$1, e);
            }

            public final boolean isDefinedAt(Throwable e) {
                Throwable throwable = e;
                return true;
            }
            {
                this.id$1 = id$1;
            }
        });
        int x$2 = 5;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, 5, x$3, x$4).collectSeq().map((Function1)MailboxSetDeletePerformer$MailboxDeletionResults$.MODULE$);
    }

    private SMono<MailboxDeletionResult> delete(MailboxSession mailboxSession, UnparsedMailboxId id2, boolean onDestroy) {
        return (SMono)MailboxGet$.MODULE$.parse(this.mailboxIdFactory, id2).fold((Function1 & Serializable)e -> SMono$.MODULE$.error(e), (Function1 & Serializable)id -> this.doDelete(mailboxSession, (MailboxId)id, onDestroy).then(SMono$.MODULE$.just((Object)new MailboxDeletionSuccess((MailboxId)id))));
    }

    private SMono<BoxedUnit> doDelete(MailboxSession mailboxSession, MailboxId id, boolean onDestroy) {
        return SMono$.MODULE$.apply(this.mailboxManager.getMailboxReactive(id, mailboxSession)).flatMap((Function1 & Serializable)mailbox -> SMono$.MODULE$.apply($this.mailboxManager.hasChildrenReactive(mailbox.getMailboxPath(), mailboxSession)).flatMap((Function1 & Serializable)hasChildren -> {
            if (this.isASystemMailbox((MessageManager)mailbox)) {
                throw new SystemMailboxChangeException(id);
            }
            if (Predef$.MODULE$.Boolean2boolean(hasChildren)) {
                throw new MailboxHasChildException(id);
            }
            if (onDestroy) {
                return SMono$.MODULE$.apply((Publisher)$this.mailboxManager.deleteMailboxReactive(id, mailboxSession)).flatMap((Function1 & Serializable)deletedMailbox -> SMono$.MODULE$.apply($this.subscriptionManager.unsubscribeReactive(deletedMailbox.generateAssociatedPath(), mailboxSession))).then();
            }
            return SMono$.MODULE$.apply(mailbox.getMessagesReactive(MessageRange.all(), FetchGroup.MINIMAL, mailboxSession)).hasElement().handle((Function2 & Serializable)(hasElement, sink) -> {
                MailboxSetDeletePerformer.$anonfun$doDelete$4(id, BoxesRunTime.unboxToBoolean((Object)hasElement), sink);
                return BoxedUnit.UNIT;
            }).then(SMono$.MODULE$.apply((Publisher)$this.mailboxManager.deleteMailboxReactive(id, mailboxSession)).flatMap((Function1 & Serializable)deletedMailbox -> SMono$.MODULE$.apply($this.subscriptionManager.unsubscribeReactive(deletedMailbox.generateAssociatedPath(), mailboxSession))).then());
        }));
    }

    private boolean isASystemMailbox(MessageManager mailbox) {
        return Role.from((String)mailbox.getMailboxPath().getName()).isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$deleteMailboxes$3() {
        return false;
    }

    public static final /* synthetic */ void $anonfun$doDelete$4(MailboxId id$2, boolean hasElement, SynchronousSink sink) {
        if (hasElement) {
            sink.error((Throwable)new MailboxHasMailException(id$2));
            return;
        }
    }

    @Inject
    public MailboxSetDeletePerformer(MailboxManager mailboxManager, SubscriptionManager subscriptionManager, MailboxId.Factory mailboxIdFactory) {
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
        this.mailboxIdFactory = mailboxIdFactory;
    }

    public static class MailboxDeletionFailure
    implements MailboxDeletionResult,
    Product,
    Serializable {
        private final UnparsedMailboxId mailboxId;
        private final Throwable exception;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public UnparsedMailboxId mailboxId() {
            return this.mailboxId;
        }

        public Throwable exception() {
            return this.exception;
        }

        public SetError asMailboxSetError() {
            Throwable throwable = this.exception();
            if (throwable instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)throwable;
                MailboxSetDeletePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetDeletePerformer$$LOGGER().info("Attempt to delete a non existing mailbox: {}", (Object)mailboxNotFoundException.getMessage());
                return SetError$.MODULE$.notFound(mailboxNotFoundException.getMessage());
            }
            if (throwable instanceof MailboxHasMailException) {
                MailboxHasMailException mailboxHasMailException = (MailboxHasMailException)throwable;
                MailboxSetDeletePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetDeletePerformer$$LOGGER().info("Attempt to delete a mailbox with mails");
                return MailboxSetError$.MODULE$.mailboxHasEmail(mailboxHasMailException.mailboxId().serialize() + " is not empty");
            }
            if (throwable instanceof MailboxHasChildException) {
                MailboxHasChildException mailboxHasChildException = (MailboxHasChildException)throwable;
                MailboxSetDeletePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetDeletePerformer$$LOGGER().info("Attempt to delete a mailbox with children");
                return MailboxSetError$.MODULE$.mailboxHasChild(mailboxHasChildException.mailboxId().serialize() + " has child mailboxes");
            }
            if (throwable instanceof SystemMailboxChangeException) {
                MailboxSetDeletePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetDeletePerformer$$LOGGER().info("Attempt to delete a system folder");
                return SetError$.MODULE$.invalidArguments("System mailboxes cannot be destroyed", SetError$.MODULE$.invalidArguments$default$2());
            }
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                MailboxSetDeletePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetDeletePerformer$$LOGGER().info("Illegal argument in Mailbox/set delete", (Throwable)illegalArgumentException);
                return SetError$.MODULE$.invalidArguments(new Refined((Object)this.mailboxId().id()) + " is not a mailboxId: " + illegalArgumentException.getMessage(), SetError$.MODULE$.invalidArguments$default$2());
            }
            MailboxSetDeletePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetDeletePerformer$$LOGGER().error("Failed to delete mailbox", throwable);
            return SetError$.MODULE$.serverFail(this.exception().getMessage());
        }

        public MailboxDeletionFailure copy(UnparsedMailboxId mailboxId, Throwable exception) {
            return new MailboxDeletionFailure(mailboxId, exception);
        }

        public UnparsedMailboxId copy$default$1() {
            return this.mailboxId();
        }

        public Throwable copy$default$2() {
            return this.exception();
        }

        public String productPrefix() {
            return "MailboxDeletionFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mailboxId();
                }
                case 1: {
                    return this.exception();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxDeletionFailure;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "mailboxId";
                }
                case 1: {
                    return "exception";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxDeletionFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxDeletionFailure mailboxDeletionFailure = (MailboxDeletionFailure)x$1;
            UnparsedMailboxId unparsedMailboxId = this.mailboxId();
            UnparsedMailboxId unparsedMailboxId2 = mailboxDeletionFailure.mailboxId();
            if (unparsedMailboxId == null) {
                if (unparsedMailboxId2 != null) {
                    return false;
                }
            } else if (!((Object)unparsedMailboxId).equals(unparsedMailboxId2)) return false;
            Throwable throwable = this.exception();
            Throwable throwable2 = mailboxDeletionFailure.exception();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!mailboxDeletionFailure.canEqual(this)) return false;
            return true;
        }

        public MailboxDeletionFailure(UnparsedMailboxId mailboxId, Throwable exception) {
            this.mailboxId = mailboxId;
            this.exception = exception;
            Product.$init$((Product)this);
        }
    }

    public static interface MailboxDeletionResult {
    }

    public static class MailboxDeletionResults
    implements Product,
    Serializable {
        private final Seq<MailboxDeletionResult> results;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Seq<MailboxDeletionResult> results() {
            return this.results;
        }

        public Seq<MailboxId> destroyed() {
            return (Seq)((IterableOps)this.results().flatMap((Function1 & Serializable)result -> {
                MailboxDeletionResult mailboxDeletionResult = result;
                if (mailboxDeletionResult instanceof MailboxDeletionSuccess) {
                    MailboxDeletionSuccess mailboxDeletionSuccess = (MailboxDeletionSuccess)mailboxDeletionResult;
                    return new Some((Object)mailboxDeletionSuccess);
                }
                return None$.MODULE$;
            })).map((Function1 & Serializable)x$1 -> x$1.mailboxId());
        }

        public Map<UnparsedMailboxId, SetError> retrieveErrors() {
            return ((IterableOnceOps)this.results().flatMap((Function1 & Serializable)result -> {
                MailboxDeletionResult mailboxDeletionResult = result;
                if (mailboxDeletionResult instanceof MailboxDeletionFailure) {
                    MailboxDeletionFailure mailboxDeletionFailure = (MailboxDeletionFailure)mailboxDeletionResult;
                    return new Some((Object)new Tuple2((Object)mailboxDeletionFailure.mailboxId(), (Object)mailboxDeletionFailure.asMailboxSetError()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public MailboxDeletionResults copy(Seq<MailboxDeletionResult> results) {
            return new MailboxDeletionResults(results);
        }

        public Seq<MailboxDeletionResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "MailboxDeletionResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxDeletionResults;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "results";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxDeletionResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxDeletionResults mailboxDeletionResults = (MailboxDeletionResults)x$1;
            Seq<MailboxDeletionResult> seq = this.results();
            Seq<MailboxDeletionResult> seq2 = mailboxDeletionResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!mailboxDeletionResults.canEqual(this)) return false;
            return true;
        }

        public MailboxDeletionResults(Seq<MailboxDeletionResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class MailboxDeletionSuccess
    implements MailboxDeletionResult,
    Product,
    Serializable {
        private final MailboxId mailboxId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public MailboxId mailboxId() {
            return this.mailboxId;
        }

        public MailboxDeletionSuccess copy(MailboxId mailboxId) {
            return new MailboxDeletionSuccess(mailboxId);
        }

        public MailboxId copy$default$1() {
            return this.mailboxId();
        }

        public String productPrefix() {
            return "MailboxDeletionSuccess";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mailboxId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxDeletionSuccess;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "mailboxId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxDeletionSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxDeletionSuccess mailboxDeletionSuccess = (MailboxDeletionSuccess)x$1;
            MailboxId mailboxId = this.mailboxId();
            MailboxId mailboxId2 = mailboxDeletionSuccess.mailboxId();
            if (mailboxId == null) {
                if (mailboxId2 != null) {
                    return false;
                }
            } else if (!mailboxId.equals(mailboxId2)) return false;
            if (!mailboxDeletionSuccess.canEqual(this)) return false;
            return true;
        }

        public MailboxDeletionSuccess(MailboxId mailboxId) {
            this.mailboxId = mailboxId;
            Product.$init$((Product)this);
        }
    }
}

