/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.mail.Flags;
import java.io.Serializable;
import java.util.Collection;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.json.EmailSetSerializer;
import org.apache.james.jmap.mail.EmailSet$;
import org.apache.james.jmap.mail.EmailSetRequest;
import org.apache.james.jmap.mail.Keywords;
import org.apache.james.jmap.mail.KeywordsFactory$;
import org.apache.james.jmap.mail.MailboxIds;
import org.apache.james.jmap.mail.UnparsedMessageId;
import org.apache.james.jmap.mail.ValidatedEmailSetUpdate;
import org.apache.james.jmap.method.EmailSetUpdatePerformer$;
import org.apache.james.jmap.method.EmailSetUpdatePerformer$EmailUpdateSuccess$;
import org.apache.james.jmap.method.MessageNotFoundException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsValue;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0011Ut!B0a\u0011\u0003Yg!B7a\u0011\u0003q\u0007\"B;\u0002\t\u00031\bbB<\u0002\u0005\u0004%I\u0001\u001f\u0005\u0007\u007f\u0006\u0001\u000b\u0011B=\u0007\u0013\u0005\u0005\u0011\u0001%A\u0012\u0002\u0005\raABA\u0003\u0003\u0001\u000b9\u0001\u0003\u0006\u0002,\u0019\u0011)\u001a!C\u0001\u0003[A!\"a\u0010\u0007\u0005#\u0005\u000b\u0011BA\u0018\u0011\u0019)h\u0001\"\u0001\u0002B!I\u0011q\t\u0004\u0002\u0002\u0013\u0005\u0011\u0011\n\u0005\n\u0003\u001b2\u0011\u0013!C\u0001\u0003\u001fB\u0011\"!\u001a\u0007\u0003\u0003%\t%a\u001a\t\u0013\u0005ed!!A\u0005\u0002\u0005m\u0004\"CAB\r\u0005\u0005I\u0011AAC\u0011%\t\tJBA\u0001\n\u0003\n\u0019\nC\u0005\u0002\"\u001a\t\t\u0011\"\u0001\u0002$\"I\u0011Q\u0016\u0004\u0002\u0002\u0013\u0005\u0013q\u0016\u0005\n\u0003g3\u0011\u0011!C!\u0003kC\u0011\"a.\u0007\u0003\u0003%\t%!/\t\u0013\u0005mf!!A\u0005B\u0005uv!CAa\u0003\u0005\u0005\t\u0012AAb\r%\t)!AA\u0001\u0012\u0003\t)\r\u0003\u0004v-\u0011\u0005\u0011Q\u001c\u0005\n\u0003o3\u0012\u0011!C#\u0003sC\u0011\"a8\u0017\u0003\u0003%\t)!9\t\u0013\u0005\u0015h#!A\u0005\u0002\u0006\u001d\b\"CAz-\u0005\u0005I\u0011BA{\r\u0019\ti0\u0001!\u0002\u0000\"Q!\u0011\u0001\u000f\u0003\u0016\u0004%\tAa\u0001\t\u0015\tEAD!E!\u0002\u0013\u0011)\u0001\u0003\u0006\u0003\u0014q\u0011)\u001a!C\u0001\u0005+A!B!\b\u001d\u0005#\u0005\u000b\u0011\u0002B\f\u0011\u0019)H\u0004\"\u0001\u0003 !9!q\u0005\u000f\u0005\u0002\t%\u0002\"CA$9\u0005\u0005I\u0011\u0001B\u001c\u0011%\ti\u0005HI\u0001\n\u0003\u0011i\u0004C\u0005\u0003Bq\t\n\u0011\"\u0001\u0003D!I\u0011Q\r\u000f\u0002\u0002\u0013\u0005\u0013q\r\u0005\n\u0003sb\u0012\u0011!C\u0001\u0003wB\u0011\"a!\u001d\u0003\u0003%\tAa\u0012\t\u0013\u0005EE$!A\u0005B\u0005M\u0005\"CAQ9\u0005\u0005I\u0011\u0001B&\u0011%\ti\u000bHA\u0001\n\u0003\u0012y\u0005C\u0005\u00024r\t\t\u0011\"\u0011\u00026\"I\u0011q\u0017\u000f\u0002\u0002\u0013\u0005\u0013\u0011\u0018\u0005\n\u0003wc\u0012\u0011!C!\u0005':\u0011Ba\u0016\u0002\u0003\u0003E\tA!\u0017\u0007\u0013\u0005u\u0018!!A\t\u0002\tm\u0003BB;1\t\u0003\u0011\u0019\u0007C\u0005\u00028B\n\t\u0011\"\u0012\u0002:\"I\u0011q\u001c\u0019\u0002\u0002\u0013\u0005%Q\r\u0005\n\u0003K\u0004\u0014\u0011!CA\u0005WB\u0011\"a=1\u0003\u0003%I!!>\u0007\r\t]\u0014\u0001\u0011B=\u0011)\u0011YH\u000eBK\u0002\u0013\u0005!Q\u0010\u0005\u000b\u0005\u000b3$\u0011#Q\u0001\n\t}\u0004BB;7\t\u0003\u00119\tC\u0004\u0003\u000eZ\"\tAa$\t\u000f\t%f\u0007\"\u0001\u0003,\"I\u0011q\t\u001c\u0002\u0002\u0013\u0005!\u0011\u0017\u0005\n\u0003\u001b2\u0014\u0013!C\u0001\u0005kC\u0011\"!\u001a7\u0003\u0003%\t%a\u001a\t\u0013\u0005ed'!A\u0005\u0002\u0005m\u0004\"CABm\u0005\u0005I\u0011\u0001B]\u0011%\t\tJNA\u0001\n\u0003\n\u0019\nC\u0005\u0002\"Z\n\t\u0011\"\u0001\u0003>\"I\u0011Q\u0016\u001c\u0002\u0002\u0013\u0005#\u0011\u0019\u0005\n\u0003g3\u0014\u0011!C!\u0003kC\u0011\"a.7\u0003\u0003%\t%!/\t\u0013\u0005mf'!A\u0005B\t\u0015w!\u0003Be\u0003\u0005\u0005\t\u0012\u0001Bf\r%\u00119(AA\u0001\u0012\u0003\u0011i\r\u0003\u0004v\u0011\u0012\u0005!\u0011\u001b\u0005\n\u0003oC\u0015\u0011!C#\u0003sC\u0011\"a8I\u0003\u0003%\tIa5\t\u0013\u0005\u0015\b*!A\u0005\u0002\n]\u0007\"CAz\u0011\u0006\u0005I\u0011BA{\r\u0015i\u0007\r\u0001Bo\u0011)\u0011yN\u0014B\u0001B\u0003%!\u0011\u001d\u0005\u000b\u0005[t%\u0011!Q\u0001\n\t=\bB\u0003B|\u001d\n\u0005\t\u0015!\u0003\u0003z\"Q!q (\u0003\u0002\u0003\u0006Ia!\u0001\t\rUtE\u0011AB\b\u0011\u001d\u0019iC\u0014C\u0001\u0007_Aqa!\fO\t\u0013\u0019\t\bC\u0004\u0004\u0014:#Ia!&\t\u000f\r\rg\n\"\u0003\u0004F\"91\u0011\u001c(\u0005\n\rm\u0007b\u0002C\u000b\u001d\u0012%Aq\u0003\u0005\b\tGqE\u0011\u0002C\u0013\u0011\u001d!9D\u0014C\u0005\tsAq\u0001\"\u0011O\t\u0013!\u0019\u0005C\u0004\u0005T9#I\u0001\"\u0016\t\u000f\u0011\u001dd\n\"\u0003\u0005j\u00059R)\\1jYN+G/\u00169eCR,\u0007+\u001a:g_JlWM\u001d\u0006\u0003C\n\fa!\\3uQ>$'BA2e\u0003\u0011QW.\u00199\u000b\u0005\u00154\u0017!\u00026b[\u0016\u001c(BA4i\u0003\u0019\t\u0007/Y2iK*\t\u0011.A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002m\u00035\t\u0001MA\fF[\u0006LGnU3u+B$\u0017\r^3QKJ4wN]7feN\u0011\u0011a\u001c\t\u0003aNl\u0011!\u001d\u0006\u0002e\u0006)1oY1mC&\u0011A/\u001d\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Y\u0017A\u0002'P\u000f\u001e+%+F\u0001z!\tQX0D\u0001|\u0015\ta\b.A\u0003tY\u001a$$.\u0003\u0002\u007fw\n1Aj\\4hKJ\fq\u0001T(H\u000f\u0016\u0013\u0006EA\tF[\u0006LG.\u00169eCR,'+Z:vYR\u001c\"!B8\u0003%\u0015k\u0017-\u001b7Va\u0012\fG/Z*vG\u000e,7o]\n\t\r=\fI!!\u0004\u0002\u0014A\u0019\u00111B\u0003\u000e\u0003\u0005\u00012\u0001]A\b\u0013\r\t\t\"\u001d\u0002\b!J|G-^2u!\u0011\t)\"!\n\u000f\t\u0005]\u0011\u0011\u0005\b\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011Q\u00046\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0018bAA\u0012c\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0014\u0003S\u0011AbU3sS\u0006d\u0017N_1cY\u0016T1!a\tr\u0003%iWm]:bO\u0016LE-\u0006\u0002\u00020A!\u0011\u0011GA\u001e\u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012!B7pI\u0016d'bAA\u001dI\u00069Q.Y5mE>D\u0018\u0002BA\u001f\u0003g\u0011\u0011\"T3tg\u0006<W-\u00133\u0002\u00155,7o]1hK&#\u0007\u0005\u0006\u0003\u0002D\u0005\u0015\u0003cAA\u0006\r!9\u00111F\u0005A\u0002\u0005=\u0012\u0001B2paf$B!a\u0011\u0002L!I\u00111\u0006\u0006\u0011\u0002\u0003\u0007\u0011qF\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tF\u000b\u0003\u00020\u0005M3FAA+!\u0011\t9&!\u0019\u000e\u0005\u0005e#\u0002BA.\u0003;\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}\u0013/\u0001\u0006b]:|G/\u0019;j_:LA!a\u0019\u0002Z\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u0007\u0005\u0003\u0002l\u0005UTBAA7\u0015\u0011\ty'!\u001d\u0002\t1\fgn\u001a\u0006\u0003\u0003g\nAA[1wC&!\u0011qOA7\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0010\t\u0004a\u0006}\u0014bAAAc\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qQAG!\r\u0001\u0018\u0011R\u0005\u0004\u0003\u0017\u000b(aA!os\"I\u0011q\u0012\b\u0002\u0002\u0003\u0007\u0011QP\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005U\u0005CBAL\u0003;\u000b9)\u0004\u0002\u0002\u001a*\u0019\u00111T9\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002 \u0006e%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!*\u0002,B\u0019\u0001/a*\n\u0007\u0005%\u0016OA\u0004C_>dW-\u00198\t\u0013\u0005=\u0005#!AA\u0002\u0005\u001d\u0015A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\u001b\u00022\"I\u0011qR\t\u0002\u0002\u0003\u0007\u0011QP\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011QP\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011N\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0015\u0016q\u0018\u0005\n\u0003\u001f#\u0012\u0011!a\u0001\u0003\u000f\u000b!#R7bS2,\u0006\u000fZ1uKN+8mY3tgB\u0019\u00111\u0002\f\u0014\u000bY\t9-a5\u0011\u0011\u0005%\u0017qZA\u0018\u0003\u0007j!!a3\u000b\u0007\u00055\u0017/A\u0004sk:$\u0018.\\3\n\t\u0005E\u00171\u001a\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004\u0003BAk\u00037l!!a6\u000b\t\u0005e\u0017\u0011O\u0001\u0003S>LA!a\n\u0002XR\u0011\u00111Y\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0003\u0007\n\u0019\u000fC\u0004\u0002,e\u0001\r!a\f\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011^Ax!\u0015\u0001\u00181^A\u0018\u0013\r\ti/\u001d\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005E($!AA\u0002\u0005\r\u0013a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011q\u001f\t\u0005\u0003W\nI0\u0003\u0003\u0002|\u00065$AB(cU\u0016\u001cGO\u0001\nF[\u0006LG.\u00169eCR,g)Y5mkJ,7\u0003\u0003\u000fp\u0003\u0013\ti!a\u0005\u0002#Ut\u0007/\u0019:tK\u0012lUm]:bO\u0016LE-\u0006\u0002\u0003\u0006A!!q\u0001B\u0007\u001b\t\u0011IAC\u0002\u0003\f\t\fA!\\1jY&!!q\u0002B\u0005\u0005E)f\u000e]1sg\u0016$W*Z:tC\u001e,\u0017\nZ\u0001\u0013k:\u0004\u0018M]:fI6+7o]1hK&#\u0007%A\u0001f+\t\u00119\u0002\u0005\u0003\u0002\u0016\te\u0011\u0002\u0002B\u000e\u0003S\u0011\u0011\u0002\u00165s_^\f'\r\\3\u0002\u0005\u0015\u0004CC\u0002B\u0011\u0005G\u0011)\u0003E\u0002\u0002\fqAqA!\u0001\"\u0001\u0004\u0011)\u0001C\u0004\u0003\u0014\u0005\u0002\rAa\u0006\u0002#\u0005\u001cX*Z:tC\u001e,7+\u001a;FeJ|'/\u0006\u0002\u0003,A!!Q\u0006B\u001a\u001b\t\u0011yCC\u0002\u00032\t\fAaY8sK&!!Q\u0007B\u0018\u0005!\u0019V\r^#se>\u0014HC\u0002B\u0011\u0005s\u0011Y\u0004C\u0005\u0003\u0002\r\u0002\n\u00111\u0001\u0003\u0006!I!1C\u0012\u0011\u0002\u0003\u0007!qC\u000b\u0003\u0005\u007fQCA!\u0002\u0002T\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B#U\u0011\u00119\"a\u0015\u0015\t\u0005\u001d%\u0011\n\u0005\n\u0003\u001fC\u0013\u0011!a\u0001\u0003{\"B!!*\u0003N!I\u0011q\u0012\u0016\u0002\u0002\u0003\u0007\u0011q\u0011\u000b\u0005\u0003S\u0012\t\u0006C\u0005\u0002\u0010.\n\t\u00111\u0001\u0002~Q!\u0011Q\u0015B+\u0011%\tyILA\u0001\u0002\u0004\t9)\u0001\nF[\u0006LG.\u00169eCR,g)Y5mkJ,\u0007cAA\u0006aM)\u0001G!\u0018\u0002TBQ\u0011\u0011\u001aB0\u0005\u000b\u00119B!\t\n\t\t\u0005\u00141\u001a\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DC\u0001B-)\u0019\u0011\tCa\u001a\u0003j!9!\u0011A\u001aA\u0002\t\u0015\u0001b\u0002B\ng\u0001\u0007!q\u0003\u000b\u0005\u0005[\u0012)\bE\u0003q\u0003W\u0014y\u0007E\u0004q\u0005c\u0012)Aa\u0006\n\u0007\tM\u0014O\u0001\u0004UkBdWM\r\u0005\n\u0003c$\u0014\u0011!a\u0001\u0005C\u0011!#R7bS2,\u0006\u000fZ1uKJ+7/\u001e7ugN1ag\\A\u0007\u0003'\tqA]3tk2$8/\u0006\u0002\u0003\u0000A1\u0011Q\u0003BA\u0003\u0013IAAa!\u0002*\t\u00191+Z9\u0002\u0011I,7/\u001e7ug\u0002\"BA!#\u0003\fB\u0019\u00111\u0002\u001c\t\u000f\tm\u0014\b1\u0001\u0003\u0000\u00059Q\u000f\u001d3bi\u0016$WC\u0001BI!\u0015\u0001\u00181\u001eBJ!!\u0011)J!(\u00020\t\rf\u0002\u0002BL\u00053\u00032!!\u0007r\u0013\r\u0011Y*]\u0001\u0007!J,G-\u001a4\n\t\t}%\u0011\u0015\u0002\u0004\u001b\u0006\u0004(b\u0001BNcB\u0019\u0001O!*\n\u0007\t\u001d\u0016O\u0001\u0003V]&$\u0018A\u00038piV\u0003H-\u0019;fIV\u0011!Q\u0016\t\u0006a\u0006-(q\u0016\t\t\u0005+\u0013iJ!\u0002\u0003,Q!!\u0011\u0012BZ\u0011%\u0011Y\b\u0010I\u0001\u0002\u0004\u0011y(\u0006\u0002\u00038*\"!qPA*)\u0011\t9Ia/\t\u0013\u0005=\u0005)!AA\u0002\u0005uD\u0003BAS\u0005\u007fC\u0011\"a$C\u0003\u0003\u0005\r!a\"\u0015\t\u0005%$1\u0019\u0005\n\u0003\u001f\u001b\u0015\u0011!a\u0001\u0003{\"B!!*\u0003H\"I\u0011q\u0012$\u0002\u0002\u0003\u0007\u0011qQ\u0001\u0013\u000b6\f\u0017\u000e\\+qI\u0006$XMU3tk2$8\u000fE\u0002\u0002\f!\u001bR\u0001\u0013Bh\u0003'\u0004\u0002\"!3\u0002P\n}$\u0011\u0012\u000b\u0003\u0005\u0017$BA!#\u0003V\"9!1P&A\u0002\t}D\u0003\u0002Bm\u00057\u0004R\u0001]Av\u0005\u007fB\u0011\"!=M\u0003\u0003\u0005\rA!#\u0014\u00059{\u0017AC:fe&\fG.\u001b>feB!!1\u001dBu\u001b\t\u0011)OC\u0002\u0003h\n\fAA[:p]&!!1\u001eBs\u0005I)U.Y5m'\u0016$8+\u001a:jC2L'0\u001a:\u0002!5,7o]1hK&#W*\u00198bO\u0016\u0014\b\u0003\u0002By\u0005gl!!a\u000e\n\t\tU\u0018q\u0007\u0002\u0011\u001b\u0016\u001c8/Y4f\u0013\u0012l\u0015M\\1hKJ\fa\"\\1jY\n|\u00070T1oC\u001e,'\u000f\u0005\u0003\u0003r\nm\u0018\u0002\u0002B\u007f\u0003o\u0011a\"T1jY\n|\u00070T1oC\u001e,'/\u0001\tnKN\u001c\u0018mZ3JI\u001a\u000b7\r^8ssB!11AB\u0005\u001d\u0011\t\td!\u0002\n\t\r\u001d\u00111G\u0001\n\u001b\u0016\u001c8/Y4f\u0013\u0012LAaa\u0003\u0004\u000e\t9a)Y2u_JL(\u0002BB\u0004\u0003g!\"b!\u0005\u0004\u0014\rU1qCB\r!\tag\nC\u0004\u0003`N\u0003\rA!9\t\u000f\t58\u000b1\u0001\u0003p\"9!q_*A\u0002\te\bb\u0002B\u0000'\u0002\u00071\u0011\u0001\u0015\u0004'\u000eu\u0001\u0003BB\u0010\u0007Si!a!\t\u000b\t\r\r2QE\u0001\u0007S:TWm\u0019;\u000b\u0005\r\u001d\u0012a\u00026bW\u0006\u0014H/Y\u0005\u0005\u0007W\u0019\tC\u0001\u0004J]*,7\r^\u0001\u0007kB$\u0017\r^3\u0015\r\rE2QLB4!\u0019\u0019\u0019d!\u0011\u0004F5\u00111Q\u0007\u0006\u0005\u0007o\u0019I$A\u0005qk\nd\u0017n\u001d5fe*\u0019!oa\u000f\u000b\t\tE2Q\b\u0006\u0003\u0007\u007f\tqA]3bGR|'/\u0003\u0003\u0004D\rU\"!B*N_:|\u0007cAB$m9\u00191\u0011\n\u0001\u000f\t\r-31\f\b\u0005\u0007\u001b\u001aIF\u0004\u0003\u0004P\r]c\u0002BB)\u0007+rA!!\u0007\u0004T%\t\u0011.\u0003\u0002hQ&\u0011QMZ\u0005\u0003G\u0012L!!\u00192\t\u000f\r}C\u000b1\u0001\u0004b\u0005yQ-\\1jYN+GOU3rk\u0016\u001cH\u000f\u0005\u0003\u0003\b\r\r\u0014\u0002BB3\u0005\u0013\u0011q\"R7bS2\u001cV\r\u001e*fcV,7\u000f\u001e\u0005\b\u0007S\"\u0006\u0019AB6\u00039i\u0017-\u001b7c_b\u001cVm]:j_:\u0004BA!=\u0004n%!1qNA\u001c\u00059i\u0015-\u001b7c_b\u001cVm]:j_:$ba!\r\u0004t\r=\u0005bBB;+\u0002\u00071qO\u0001\bkB$\u0017\r^3t!!\u0011)J!(\u0003\u0006\re\u0004\u0003BB>\u0007\u0017k!a! \u000b\t\t\u001d8q\u0010\u0006\u0005\u0007\u0003\u001b\u0019)\u0001\u0003mS\n\u001c(\u0002BBC\u0007\u000f\u000b1!\u00199j\u0015\t\u0019I)\u0001\u0003qY\u0006L\u0018\u0002BBG\u0007{\u0012\u0001BS:PE*,7\r\u001e\u0005\b\u0007#+\u0006\u0019AB6\u0003\u001d\u0019Xm]:j_:\f\u0001\u0002Z8Va\u0012\fG/\u001a\u000b\t\u0007/\u001bija,\u0004BB111GB!\u00073\u0003b!!\u0006\u0003\u0002\u000em\u0005cAB$\u000b!91q\u0014,A\u0002\r\u0005\u0016\u0001\u0004<bY&$W\u000b\u001d3bi\u0016\u001c\bCBA\u000b\u0007G\u001b9+\u0003\u0003\u0004&\u0006%\"\u0001\u0002'jgR\u0004r\u0001\u001dB9\u0003_\u0019I\u000b\u0005\u0003\u0003\b\r-\u0016\u0002BBW\u0005\u0013\u0011qCV1mS\u0012\fG/\u001a3F[\u0006LGnU3u+B$\u0017\r^3\t\u000f\rEf\u000b1\u0001\u00044\u0006AQ.\u001a;b\t\u0006$\u0018\r\u0005\u0005\u0003\u0016\nu\u0015qFB[!\u0019\t)ba.\u0004<&!1\u0011XA\u0015\u0005!IE/\u001a:bE2,\u0007\u0003BA\u0019\u0007{KAaa0\u00024\ti2i\\7q_N,G-T3tg\u0006<W-\u00133XSRDW*\u001a;b\t\u0006$\u0018\rC\u0004\u0004\u0012Z\u0003\raa\u001b\u0002\u0011\u0005\u001c(+\u00198hKN$Baa2\u0004XB11\u0011ZBh\u0007#l!aa3\u000b\t\r5\u0017\u0011T\u0001\nS6lW\u000f^1cY\u0016LAa!*\u0004LB!\u0011\u0011GBj\u0013\u0011\u0019).a\r\u0003\u00195+7o]1hKJ\u000bgnZ3\t\u000f\rEv\u000b1\u0001\u00044\u0006\u0011R\u000f\u001d3bi\u00164E.Y4t\u0005f\u0014\u0016M\\4f)9\u00199j!8\u0004h\u000eU81`B\u007f\t'Aqaa8Y\u0001\u0004\u0019\t/A\u0005nC&d'm\u001c=JIB!\u0011\u0011GBr\u0013\u0011\u0019)/a\r\u0003\u00135\u000b\u0017\u000e\u001c2pq&#\u0007bBBu1\u0002\u000711^\u0001\u0006M2\fwm\u001d\t\u0005\u0007[\u001c\t0\u0004\u0002\u0004p*!!1BB\u0013\u0013\u0011\u0019\u0019pa<\u0003\u000b\u0019c\u0017mZ:\t\u000f\r]\b\f1\u0001\u0004z\u00061!/\u00198hKN\u0004b!!\u0006\u0004$\u000eE\u0007bBBY1\u0002\u000711\u0017\u0005\b\u0007\u007fD\u0006\u0019\u0001C\u0001\u0003))\b\u000fZ1uK6{G-\u001a\t\u0005\t\u0007!iA\u0004\u0003\u0005\u0006\u0011%a\u0002BB'\t\u000fI1!!\u000fe\u0013\u0011!Y!a\u000e\u0002\u001d5+7o]1hK6\u000bg.Y4fe&!Aq\u0002C\t\u0005=1E.Y4t+B$\u0017\r^3N_\u0012,'\u0002\u0002C\u0006\u0003oAqa!%Y\u0001\u0004\u0019Y'A\u0006n_Z,')\u001f*b]\u001e,G\u0003DBL\t3!Y\u0002\"\b\u0005 \u0011\u0005\u0002bBBp3\u0002\u00071\u0011\u001d\u0005\b\u0007[I\u0006\u0019ABU\u0011\u001d\u001990\u0017a\u0001\u0007sDqa!-Z\u0001\u0004\u0019\u0019\fC\u0004\u0004\u0012f\u0003\raa\u001b\u0002\u001bU\u0004H-\u0019;f\u0005f\u0014\u0016M\\4f)!\u00199\nb\n\u0005*\u0011-\u0002bBB|5\u0002\u00071\u0011 \u0005\b\u0007cS\u0006\u0019ABZ\u0011\u001d!iC\u0017a\u0001\t_\t\u0011b\u001c9fe\u0006$\u0018n\u001c8\u0011\u000fA$\td!5\u00056%\u0019A1G9\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CBB\u001a\u0007\u0003\u0012\u0019+A\tva\u0012\fG/Z#bG\"lUm]:bO\u0016$\u0002ba&\u0005<\u0011uBq\b\u0005\b\u0007?[\u0006\u0019ABQ\u0011\u001d\u0019\tl\u0017a\u0001\u0007gCqa!%\\\u0001\u0004\u0019Y'A\nva\u0012\fG/Z*j]\u001edW-T3tg\u0006<W\r\u0006\u0006\u0005F\u0011\u001dC\u0011\nC&\t#\u0002baa\r\u0004B\rm\u0005bBA\u00169\u0002\u0007\u0011q\u0006\u0005\b\u0007[a\u0006\u0019ABU\u0011\u001d!i\u0005\u0018a\u0001\t\u001f\nab\u001d;pe\u0016$W*\u001a;b\t\u0006$\u0018\r\u0005\u0004\u0002\u0016\r\r61\u0018\u0005\b\u0007#c\u0006\u0019AB6\u0003A)\b\u000fZ1uK6\u000b\u0017\u000e\u001c2pq&#7\u000f\u0006\u0006\u0005F\u0011]C\u0011\fC.\tKBq!a\u000b^\u0001\u0004\ty\u0003C\u0004\u0004.u\u0003\ra!+\t\u000f\u0011uS\f1\u0001\u0005`\u0005QQ.Y5mE>D\u0018\nZ:\u0011\t\t\u001dA\u0011M\u0005\u0005\tG\u0012IA\u0001\u0006NC&d'm\u001c=JINDqa!%^\u0001\u0004\u0019Y'A\u0006va\u0012\fG/\u001a$mC\u001e\u001cH\u0003\u0004C#\tW\"i\u0007b\u001c\u0005r\u0011M\u0004bBA\u0016=\u0002\u0007\u0011q\u0006\u0005\b\u0007[q\u0006\u0019ABU\u0011\u001d!iF\u0018a\u0001\t?Bq\u0001\"\u0014_\u0001\u0004!y\u0005C\u0004\u0004\u0012z\u0003\raa\u001b")
public class EmailSetUpdatePerformer {
    private final EmailSetSerializer serializer;
    private final MessageIdManager messageIdManager;
    private final MailboxManager mailboxManager;
    private final MessageId.Factory messageIdFactory;

    public SMono<EmailUpdateResults> update(EmailSetRequest emailSetRequest, MailboxSession mailboxSession) {
        return (SMono)emailSetRequest.update().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.nonEmpty())).map((Function1 & Serializable)x$4 -> this.update((Map<UnparsedMessageId, JsObject>)x$4, mailboxSession)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.just((Object)new EmailUpdateResults((scala.collection.immutable.Seq<EmailUpdateResult>)((scala.collection.immutable.Seq)Nil$.MODULE$))));
    }

    private SMono<EmailUpdateResults> update(Map<UnparsedMessageId, JsObject> updates2, MailboxSession session) {
        List validatedUpdates = ((IterableOnceOps)updates2.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                UnparsedMessageId unparsedMessageId = (UnparsedMessageId)tuple2._1();
                JsObject json = (JsObject)tuple2._2();
                return EmailSet$.MODULE$.parse($this.messageIdFactory, unparsedMessageId).toEither().left().map((Function1 & Serializable)e -> new EmailUpdateFailure(unparsedMessageId, (Throwable)e)).flatMap((Function1 & Serializable)id -> (Either)$this.serializer.deserializeEmailSetUpdate((JsValue)json).asEither().left().map((Function1 & Serializable)e -> new IllegalArgumentException(e.toString())).flatMap((Function1 & Serializable)x$5 -> x$5.validate()).fold((Function1 & Serializable)e -> new Left((Object)new EmailUpdateFailure(unparsedMessageId, (Throwable)e)), (Function1 & Serializable)emailSetUpdate -> new Right((Object)new Tuple2(id, emailSetUpdate))));
            }
            throw new MatchError((Object)tuple2);
        })).toList();
        List failures = validatedUpdates.flatMap((Function1 & Serializable)x0$2 -> {
            Either either = x0$2;
            if (either instanceof Left) {
                Left left = (Left)either;
                EmailUpdateFailure e = (EmailUpdateFailure)left.value();
                return new Some((Object)e);
            }
            return None$.MODULE$;
        });
        List validUpdates = validatedUpdates.flatMap((Function1 & Serializable)x0$3 -> {
            Either either = x0$3;
            if (either instanceof Right) {
                Right right = (Right)either;
                Tuple2 pair = (Tuple2)right.value();
                return new Some((Object)pair);
            }
            return None$.MODULE$;
        });
        return SFlux$.MODULE$.fromPublisher(this.messageIdManager.messagesMetadata(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)validUpdates.map((Function1 & Serializable)x$6 -> (MessageId)x$6._1())).asJavaCollection(), session)).collectMultimap((Function1 & Serializable)metaData -> metaData.getComposedMessageId().getMessageId()).flatMap((Function1 & Serializable)x$7 -> this.doUpdate((List<Tuple2<MessageId, ValidatedEmailSetUpdate>>)validUpdates, (Map<MessageId, Iterable<ComposedMessageIdWithMetaData>>)x$7, session)).map((Function1 & Serializable)updates -> new EmailUpdateResults((scala.collection.immutable.Seq<EmailUpdateResult>)((scala.collection.immutable.Seq)updates.$plus$plus((IterableOnce)failures))));
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> doUpdate(List<Tuple2<MessageId, ValidatedEmailSetUpdate>> validUpdates, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MailboxSession session) {
        boolean singleMailbox;
        boolean sameUpdate = ((SeqOps)validUpdates.map((Function1 & Serializable)x$8 -> (ValidatedEmailSetUpdate)x$8._2()).distinctBy((Function1 & Serializable)x$9 -> x$9.update())).size() == 1;
        boolean bl = singleMailbox = ((IterableOnceOps)((IterableOps)metaData.values().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$10 -> x$10.getComposedMessageId().getMailboxId())).toSet().size() == 1;
        if (sameUpdate && singleMailbox && validUpdates.size() > 3) {
            ValidatedEmailSetUpdate update = (ValidatedEmailSetUpdate)validUpdates.map((Function1 & Serializable)x$11 -> (ValidatedEmailSetUpdate)x$11._2()).headOption().get();
            List<MessageRange> ranges = this.asRanges(metaData);
            MailboxId mailboxId = (MailboxId)((IterableOps)((IterableOps)metaData.values().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$12 -> x$12.getComposedMessageId().getMailboxId())).headOption().get();
            if (update.update().isOnlyFlagAddition()) {
                return this.updateFlagsByRange(mailboxId, ((Keywords)update.update().keywordsToAdd().get()).asFlags(), ranges, metaData, MessageManager.FlagsUpdateMode.ADD, session);
            }
            if (update.update().isOnlyFlagRemoval()) {
                return this.updateFlagsByRange(mailboxId, ((Keywords)update.update().keywordsToRemove().get()).asFlags(), ranges, metaData, MessageManager.FlagsUpdateMode.REMOVE, session);
            }
            if (update.update().isOnlyMove()) {
                return this.moveByRange(mailboxId, update, ranges, metaData, session);
            }
            return this.updateEachMessage(validUpdates, metaData, session);
        }
        return this.updateEachMessage(validUpdates, metaData, session);
    }

    private List<MessageRange> asRanges(Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData) {
        return CollectionConverters$.MODULE$.ListHasAsScala(MessageRange.toRanges((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((IterableOps)metaData.values().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$13 -> x$13.getComposedMessageId().getUid())).toList().distinct()).asJava())).asScala().toList();
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> updateFlagsByRange(MailboxId mailboxId, Flags flags, List<MessageRange> ranges, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MessageManager.FlagsUpdateMode updateMode, MailboxSession session) {
        SMono mailboxMono = SMono$.MODULE$.apply(this.mailboxManager.getMailboxReactive(mailboxId, session));
        return mailboxMono.flatMap((Function1 & Serializable)mailbox -> this.updateByRange(ranges, metaData, (Function1<MessageRange, SMono<BoxedUnit>>)(Function1 & Serializable)range -> SMono$.MODULE$.apply(mailbox.setFlagsReactive(flags, updateMode, range, session)).then()));
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> moveByRange(MailboxId mailboxId, ValidatedEmailSetUpdate update, List<MessageRange> ranges, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MailboxSession session) {
        MailboxId targetId = (MailboxId)((MailboxIds)update.update().mailboxIds().get()).value().headOption().get();
        return this.updateByRange(ranges, metaData, (Function1<MessageRange, SMono<BoxedUnit>>)(Function1 & Serializable)range -> SMono$.MODULE$.apply($this.mailboxManager.moveMessagesReactive(range, mailboxId, targetId, session)).then());
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> updateByRange(List<MessageRange> ranges, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, Function1<MessageRange, SMono<BoxedUnit>> operation) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable(ranges);
        Function1 & Serializable x$1 = (Function1 & Serializable)range -> {
            scala.collection.immutable.Seq messageIds = ((MapOps)metaData.filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)EmailSetUpdatePerformer.$anonfun$updateByRange$2(range, entry)))).keys().toSeq();
            return ((SMono)operation.apply(range)).then(SMono$.MODULE$.just(messageIds.map((Function1)EmailSetUpdatePerformer$EmailUpdateSuccess$.MODULE$))).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just(messageIds.map((Function1 & Serializable)id -> new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed((MessageId)id), (Throwable)e))));
        };
        int x$2 = qual$1.concatMap$default$2();
        return qual$1.concatMap((Function1)x$1, x$2).reduce((Object)Nil$.MODULE$, (Function2 & Serializable)(x$14, x$15) -> (scala.collection.immutable.Seq)x$14.$plus$plus((IterableOnce)x$15));
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> updateEachMessage(List<Tuple2<MessageId, ValidatedEmailSetUpdate>> validUpdates, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MailboxSession session) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable(validUpdates);
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                MessageId messageId = (MessageId)tuple2._1();
                ValidatedEmailSetUpdate updatePatch = (ValidatedEmailSetUpdate)tuple2._2();
                return this.updateSingleMessage(messageId, updatePatch, (List<ComposedMessageIdWithMetaData>)((List)metaData.get((Object)messageId).toList().flatten(Predef$.MODULE$.$conforms())), session);
            }
            throw new MatchError((Object)tuple2);
        };
        int x$2 = qual$1.concatMap$default$2();
        return qual$1.concatMap((Function1)x$1, x$2).collectSeq();
    }

    private SMono<EmailUpdateResult> updateSingleMessage(MessageId messageId, ValidatedEmailSetUpdate update, List<ComposedMessageIdWithMetaData> storedMetaData, MailboxSession session) {
        MailboxIds mailboxIds = new MailboxIds((List<MailboxId>)storedMetaData.map((Function1 & Serializable)metaData -> metaData.getComposedMessageId().getMailboxId()));
        if (mailboxIds.value().isEmpty()) {
            return SMono$.MODULE$.just((Object)new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed(messageId), new MessageNotFoundException(messageId)));
        }
        return this.updateFlags(messageId, update, mailboxIds, storedMetaData, session).flatMap((Function1 & Serializable)x0$1 -> {
            EmailUpdateResult emailUpdateResult = x0$1;
            if (emailUpdateResult instanceof EmailUpdateFailure) {
                EmailUpdateFailure emailUpdateFailure = (EmailUpdateFailure)emailUpdateResult;
                return SMono$.MODULE$.just((Object)emailUpdateFailure);
            }
            if (emailUpdateResult instanceof EmailUpdateSuccess) {
                return this.updateMailboxIds(messageId, update, mailboxIds, session);
            }
            throw new MatchError((Object)emailUpdateResult);
        }).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed(messageId), (Throwable)e))).switchIfEmpty(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId)));
    }

    private SMono<EmailUpdateResult> updateMailboxIds(MessageId messageId, ValidatedEmailSetUpdate update, MailboxIds mailboxIds, MailboxSession session) {
        if (update.update().isMailboxUpdate()) {
            MailboxIds targetIds = (MailboxIds)update.mailboxIdsTransformation().apply((Object)mailboxIds);
            return SMono$.MODULE$.apply(this.messageIdManager.setInMailboxesReactive(messageId, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(targetIds.value()).asJava(), session)).then(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId))).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed(messageId), (Throwable)e))).switchIfEmpty(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId)));
        }
        return SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId));
    }

    private SMono<EmailUpdateResult> updateFlags(MessageId messageId, ValidatedEmailSetUpdate update, MailboxIds mailboxIds, List<ComposedMessageIdWithMetaData> storedMetaData, MailboxSession session) {
        if (update.update().isFlagUpdate()) {
            Flags originalFlags = (Flags)storedMetaData.foldLeft((Object)new Flags(), (Function2 & Serializable)(flags, m) -> {
                flags.add(m.getFlags());
                return flags;
            });
            Flags newFlags = ((Keywords)update.keywordsTransformation().apply(KeywordsFactory$.MODULE$.LENIENT_KEYWORDS_FACTORY().fromFlags(originalFlags).get())).asFlagsWithRecentAndDeletedFrom(originalFlags);
            return SMono$.MODULE$.apply(this.messageIdManager.setFlagsReactive(newFlags, MessageManager.FlagsUpdateMode.REPLACE, messageId, (java.util.List)ImmutableList.copyOf((Collection)CollectionConverters$.MODULE$.IterableHasAsJava(mailboxIds.value()).asJavaCollection()), session)).then(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId)));
        }
        return SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId));
    }

    public static final /* synthetic */ boolean $anonfun$updateByRange$2(MessageRange range$1, Tuple2 entry) {
        return ((IterableOnceOps)entry._2()).exists((Function1 & Serializable)composedId -> BoxesRunTime.boxToBoolean((boolean)range$1.includes(composedId.getComposedMessageId().getUid())));
    }

    @Inject
    public EmailSetUpdatePerformer(EmailSetSerializer serializer, MessageIdManager messageIdManager, MailboxManager mailboxManager, MessageId.Factory messageIdFactory) {
        this.serializer = serializer;
        this.messageIdManager = messageIdManager;
        this.mailboxManager = mailboxManager;
        this.messageIdFactory = messageIdFactory;
    }

    public static class EmailUpdateFailure
    implements EmailUpdateResult,
    Product,
    Serializable {
        private final UnparsedMessageId unparsedMessageId;
        private final Throwable e;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public UnparsedMessageId unparsedMessageId() {
            return this.unparsedMessageId;
        }

        public Throwable e() {
            return this.e;
        }

        public SetError asMessageSetError() {
            Throwable throwable = this.e();
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                EmailSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$EmailSetUpdatePerformer$$LOGGER().info("Illegal argument in Email/set update", (Throwable)illegalArgumentException);
                return SetError$.MODULE$.invalidPatch("Message update is invalid: " + illegalArgumentException.getMessage());
            }
            if (throwable instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)throwable;
                EmailSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$EmailSetUpdatePerformer$$LOGGER().info("Mailbox not found in Email/set update", (Throwable)mailboxNotFoundException);
                return SetError$.MODULE$.notFound("Mailbox not found");
            }
            if (throwable instanceof MessageNotFoundException) {
                MessageNotFoundException messageNotFoundException = (MessageNotFoundException)throwable;
                EmailSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$EmailSetUpdatePerformer$$LOGGER().info("Message not found in Email/set update: " + messageNotFoundException.messageId().serialize());
                return SetError$.MODULE$.notFound("Cannot find message with messageId: " + messageNotFoundException.messageId().serialize());
            }
            if (throwable instanceof OverQuotaException) {
                OverQuotaException overQuotaException = (OverQuotaException)throwable;
                EmailSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$EmailSetUpdatePerformer$$LOGGER().info("Overquota in email set update");
                return SetError$.MODULE$.overQuota(overQuotaException.getMessage());
            }
            EmailSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$EmailSetUpdatePerformer$$LOGGER().error("Failed to update email", this.e());
            return SetError$.MODULE$.serverFail(this.e().getMessage());
        }

        public EmailUpdateFailure copy(UnparsedMessageId unparsedMessageId, Throwable e) {
            return new EmailUpdateFailure(unparsedMessageId, e);
        }

        public UnparsedMessageId copy$default$1() {
            return this.unparsedMessageId();
        }

        public Throwable copy$default$2() {
            return this.e();
        }

        public String productPrefix() {
            return "EmailUpdateFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.unparsedMessageId();
                }
                case 1: {
                    return this.e();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EmailUpdateFailure;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "unparsedMessageId";
                }
                case 1: {
                    return "e";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EmailUpdateFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            EmailUpdateFailure emailUpdateFailure = (EmailUpdateFailure)x$1;
            UnparsedMessageId unparsedMessageId = this.unparsedMessageId();
            UnparsedMessageId unparsedMessageId2 = emailUpdateFailure.unparsedMessageId();
            if (unparsedMessageId == null) {
                if (unparsedMessageId2 != null) {
                    return false;
                }
            } else if (!((Object)unparsedMessageId).equals(unparsedMessageId2)) return false;
            Throwable throwable = this.e();
            Throwable throwable2 = emailUpdateFailure.e();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!emailUpdateFailure.canEqual(this)) return false;
            return true;
        }

        public EmailUpdateFailure(UnparsedMessageId unparsedMessageId, Throwable e) {
            this.unparsedMessageId = unparsedMessageId;
            this.e = e;
            Product.$init$((Product)this);
        }
    }

    public static interface EmailUpdateResult {
    }

    public static class EmailUpdateResults
    implements Product,
    Serializable {
        private final scala.collection.immutable.Seq<EmailUpdateResult> results;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public scala.collection.immutable.Seq<EmailUpdateResult> results() {
            return this.results;
        }

        public Option<Map<MessageId, BoxedUnit>> updated() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                EmailUpdateResult emailUpdateResult = x0$1;
                if (emailUpdateResult instanceof EmailUpdateSuccess) {
                    EmailUpdateSuccess emailUpdateSuccess = (EmailUpdateSuccess)emailUpdateResult;
                    return new Some((Object)new Tuple2((Object)emailUpdateSuccess.messageId(), (Object)BoxedUnit.UNIT));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty()));
        }

        public Option<Map<UnparsedMessageId, SetError>> notUpdated() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                EmailUpdateResult emailUpdateResult = x0$1;
                if (emailUpdateResult instanceof EmailUpdateFailure) {
                    EmailUpdateFailure emailUpdateFailure = (EmailUpdateFailure)emailUpdateResult;
                    return new Some((Object)new Tuple2((Object)emailUpdateFailure.unparsedMessageId(), (Object)emailUpdateFailure.asMessageSetError()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nonEmpty()));
        }

        public EmailUpdateResults copy(scala.collection.immutable.Seq<EmailUpdateResult> results) {
            return new EmailUpdateResults(results);
        }

        public scala.collection.immutable.Seq<EmailUpdateResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "EmailUpdateResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EmailUpdateResults;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "results";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EmailUpdateResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            EmailUpdateResults emailUpdateResults = (EmailUpdateResults)x$1;
            scala.collection.immutable.Seq<EmailUpdateResult> seq = this.results();
            scala.collection.immutable.Seq<EmailUpdateResult> seq2 = emailUpdateResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!emailUpdateResults.canEqual(this)) return false;
            return true;
        }

        public EmailUpdateResults(scala.collection.immutable.Seq<EmailUpdateResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class EmailUpdateSuccess
    implements EmailUpdateResult,
    Product,
    Serializable {
        private final MessageId messageId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public MessageId messageId() {
            return this.messageId;
        }

        public EmailUpdateSuccess copy(MessageId messageId) {
            return new EmailUpdateSuccess(messageId);
        }

        public MessageId copy$default$1() {
            return this.messageId();
        }

        public String productPrefix() {
            return "EmailUpdateSuccess";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.messageId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EmailUpdateSuccess;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "messageId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EmailUpdateSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            EmailUpdateSuccess emailUpdateSuccess = (EmailUpdateSuccess)x$1;
            MessageId messageId = this.messageId();
            MessageId messageId2 = emailUpdateSuccess.messageId();
            if (messageId == null) {
                if (messageId2 != null) {
                    return false;
                }
            } else if (!messageId.equals(messageId2)) return false;
            if (!emailUpdateSuccess.canEqual(this)) return false;
            return true;
        }

        public EmailUpdateSuccess(MessageId messageId) {
            this.messageId = messageId;
            Product.$init$((Product)this);
        }
    }
}

