/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.event;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.jmap.api.projections.MessageFastViewPrecomputedProperties;
import org.apache.james.jmap.api.projections.MessageFastViewProjection;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ComputeMessageFastViewProjectionListener
implements EventListener.ReactiveGroupEventListener {
    static final Group GROUP = new ComputeMessageFastViewProjectionListenerGroup();
    private final MessageIdManager messageIdManager;
    private final MessageFastViewProjection messageFastViewProjection;
    private final SessionProvider sessionProvider;
    private final MessageFastViewPrecomputedProperties.Factory messageFastViewPrecomputedPropertiesFactory;

    @Inject
    public ComputeMessageFastViewProjectionListener(SessionProvider sessionProvider, MessageIdManager messageIdManager, MessageFastViewProjection messageFastViewProjection, MessageFastViewPrecomputedProperties.Factory messageFastViewPrecomputedPropertiesFactory) {
        this.sessionProvider = sessionProvider;
        this.messageIdManager = messageIdManager;
        this.messageFastViewProjection = messageFastViewProjection;
        this.messageFastViewPrecomputedPropertiesFactory = messageFastViewPrecomputedPropertiesFactory;
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public Mono<Void> reactiveEvent(Event event) {
        if (event instanceof MailboxEvents.Added) {
            MailboxSession session = this.sessionProvider.createSystemSession(event.getUsername());
            return this.handleAddedEvent((MailboxEvents.Added)event, session);
        }
        if (event instanceof MailboxEvents.Expunged) {
            MailboxSession session = this.sessionProvider.createSystemSession(event.getUsername());
            return this.handleExpungedEvent((MailboxEvents.Expunged)event, session);
        }
        return Mono.empty();
    }

    public boolean isHandling(Event event) {
        return event instanceof MailboxEvents.Added || event instanceof MailboxEvents.Expunged;
    }

    private Mono<Void> handleAddedEvent(MailboxEvents.Added addedEvent, MailboxSession session) {
        if (!addedEvent.isAppended()) {
            return Mono.empty();
        }
        return Flux.from((Publisher)this.messageIdManager.getMessagesReactive((Collection)addedEvent.getMessageIds(), FetchGroup.FULL_CONTENT, session)).flatMap((Function)Throwing.function(messageResult -> Mono.fromCallable(() -> Pair.of((Object)messageResult.getMessageId(), (Object)this.computeFastViewPrecomputedProperties((MessageResult)messageResult))).subscribeOn(Schedulers.parallel())), 16).flatMap(message -> this.messageFastViewProjection.store((MessageId)message.getKey(), (MessageFastViewPrecomputedProperties)message.getValue()), 16).then();
    }

    @VisibleForTesting
    MessageFastViewPrecomputedProperties computeFastViewPrecomputedProperties(MessageResult messageResult) throws MailboxException, IOException {
        return this.messageFastViewPrecomputedPropertiesFactory.from(messageResult);
    }

    private Mono<Void> handleExpungedEvent(MailboxEvents.Expunged expunged, MailboxSession session) {
        ImmutableSet expungedMessageIds = expunged.getMessageIds();
        return Mono.from((Publisher)this.messageIdManager.accessibleMessagesReactive((Collection)expungedMessageIds, session)).flatMapIterable(accessibleMessageIds -> CollectionUtils.subtract((Iterable)expungedMessageIds, (Iterable)accessibleMessageIds)).flatMap(arg_0 -> ((MessageFastViewProjection)this.messageFastViewProjection).delete(arg_0), 16).then();
    }

    public static class ComputeMessageFastViewProjectionListenerGroup
    extends Group {
    }
}

