/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.ProvidesIntoSet;
import com.google.inject.name.Named;
import java.io.FileNotFoundException;
import java.time.Clock;
import java.util.Set;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobReferenceSource;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.MetricableBlobStore;
import org.apache.james.blob.api.PlainBlobId;
import org.apache.james.modules.blobstore.server.BlobRoutesModules;
import org.apache.james.server.blob.deduplication.BlobGCTaskAdditionalInformationDTO;
import org.apache.james.server.blob.deduplication.BlobGCTaskDTO;
import org.apache.james.server.blob.deduplication.GenerationAwareBlobId;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.utils.PropertiesProvider;

public class BlobDeduplicationGCModule
extends AbstractModule {
    private static final String NAME = "blob";
    private static final String LEGACY = "blobstore";

    protected void configure() {
        this.bind(PlainBlobId.Factory.class).in(Scopes.SINGLETON);
        this.bind(BlobId.Factory.class).to(GenerationAwareBlobId.Factory.class);
        this.bind(MetricableBlobStore.class).in(Scopes.SINGLETON);
        this.bind(BlobStore.class).to(MetricableBlobStore.class);
        this.install((Module)new BlobRoutesModules());
    }

    @Singleton
    @Provides
    public GenerationAwareBlobId.Factory generationAwareBlobIdFactory(Clock clock, PlainBlobId.Factory delegate, GenerationAwareBlobId.Configuration configuration) {
        return new GenerationAwareBlobId.Factory(clock, (BlobId.Factory)delegate, configuration);
    }

    @Singleton
    @Provides
    public GenerationAwareBlobId.Configuration generationAwareBlobIdConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration properties = propertiesProvider.getConfigurations(new String[]{NAME, LEGACY});
            return GenerationAwareBlobId.Configuration.parse((Configuration)properties);
        }
        catch (FileNotFoundException e) {
            return GenerationAwareBlobId.Configuration.DEFAULT;
        }
    }

    @ProvidesIntoSet
    public TaskDTOModule<? extends Task, ? extends TaskDTO> blobGCTask(BlobStoreDAO blobStoreDAO, GenerationAwareBlobId.Factory generationAwareBlobIdFactory, GenerationAwareBlobId.Configuration generationAwareBlobIdConfiguration, Set<BlobReferenceSource> blobReferenceSources, Clock clock) {
        return BlobGCTaskDTO.module((BlobStoreDAO)blobStoreDAO, (GenerationAwareBlobId.Factory)generationAwareBlobIdFactory, (GenerationAwareBlobId.Configuration)generationAwareBlobIdConfiguration, blobReferenceSources, (Clock)clock);
    }

    @ProvidesIntoSet
    public AdditionalInformationDTOModule<? extends TaskExecutionDetails.AdditionalInformation, ? extends AdditionalInformationDTO> blobGCAdditionalInformation() {
        return BlobGCTaskAdditionalInformationDTO.SERIALIZATION_MODULE;
    }

    @Named(value="webadmin-dto")
    @ProvidesIntoSet
    public AdditionalInformationDTOModule<? extends TaskExecutionDetails.AdditionalInformation, ? extends AdditionalInformationDTO> webAdminBlobGCAdditionalInformation() {
        return BlobGCTaskAdditionalInformationDTO.SERIALIZATION_MODULE;
    }
}

