/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.probe;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.james.core.Username;
import org.apache.james.rrt.lib.Mappings;

public interface DataProbe {
    default public FluentDataProbe fluent() {
        return new FluentDataProbe(this);
    }

    public void addUser(String var1, String var2) throws Exception;

    public void removeUser(String var1) throws Exception;

    public String[] listUsers() throws Exception;

    public void addDomain(String var1) throws Exception;

    public boolean containsDomain(String var1) throws Exception;

    public String getDefaultDomain() throws Exception;

    public void removeDomain(String var1) throws Exception;

    public List<String> listDomains() throws Exception;

    public Map<String, Mappings> listMappings() throws Exception;

    public void addAddressMapping(String var1, String var2, String var3) throws Exception;

    public void addUserAliasMapping(String var1, String var2, String var3) throws Exception;

    public void removeUserAliasMapping(String var1, String var2, String var3) throws Exception;

    public void addDomainAliasMapping(String var1, String var2) throws Exception;

    public void addGroupAliasMapping(String var1, String var2) throws Exception;

    public void addAuthorizedUser(Username var1, Username var2);

    public Collection<Username> listAuthorizedUsers(Username var1);

    public static class FluentDataProbe {
        private final DataProbe dataProbe;

        private FluentDataProbe(DataProbe dataProbe) {
            this.dataProbe = dataProbe;
        }

        public DataProbe getDataProbe() {
            return this.dataProbe;
        }

        public FluentDataProbe addUser(String userName, String password) throws Exception {
            this.dataProbe.addUser(userName, password);
            return this;
        }

        public FluentDataProbe addDomain(String domain) throws Exception {
            this.dataProbe.addDomain(domain);
            return this;
        }
    }
}

