/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.droplists.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.droplists.api.DeniedEntityType;
import org.apache.james.droplists.api.OwnerScope;

public class DropListEntry {
    private final OwnerScope ownerScope;
    private final Optional<String> owner;
    private final DeniedEntityType deniedEntityType;
    private final String deniedEntity;

    public static Builder builder() {
        return new Builder();
    }

    private DropListEntry(OwnerScope ownerScope, Optional<String> owner, DeniedEntityType deniedEntityType, String deniedEntity) {
        this.ownerScope = ownerScope;
        this.owner = owner;
        this.deniedEntityType = deniedEntityType;
        this.deniedEntity = deniedEntity;
    }

    public OwnerScope getOwnerScope() {
        return this.ownerScope;
    }

    public String getOwner() {
        return this.owner.orElse("");
    }

    public DeniedEntityType getDeniedEntityType() {
        return this.deniedEntityType;
    }

    public String getDeniedEntity() {
        return this.deniedEntity;
    }

    public final boolean equals(Object o) {
        if (o instanceof DropListEntry) {
            DropListEntry dropListEntry = (DropListEntry)o;
            return Objects.equals((Object)this.ownerScope, (Object)dropListEntry.ownerScope) && Objects.equals(this.owner, dropListEntry.owner) && Objects.equals((Object)this.deniedEntityType, (Object)dropListEntry.deniedEntityType) && Objects.equals(this.deniedEntity, dropListEntry.deniedEntity);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.ownerScope, this.owner, this.deniedEntityType, this.deniedEntity});
    }

    public String toString() {
        MoreObjects.ToStringHelper result = MoreObjects.toStringHelper((Object)this).add("ownerScope", (Object)this.ownerScope);
        this.owner.ifPresent(o -> result.add("owner", o));
        result.add("deniedType", (Object)this.deniedEntityType).add("deniedEntity", (Object)this.deniedEntity);
        return result.toString();
    }

    public static class Builder {
        private OwnerScope ownerScope;
        private Optional<String> owner = Optional.empty();
        private DeniedEntityType deniedEntityType;
        private String deniedEntity;

        public Builder userOwner(MailAddress mailAddress) {
            Preconditions.checkNotNull((Object)mailAddress);
            this.owner = Optional.of(mailAddress.toString());
            this.ownerScope = OwnerScope.USER;
            return this;
        }

        public Builder domainOwner(Domain domain) {
            Preconditions.checkNotNull((Object)domain);
            this.owner = Optional.of(domain.asString());
            this.ownerScope = OwnerScope.DOMAIN;
            return this;
        }

        public Builder forAll() {
            this.ownerScope = OwnerScope.GLOBAL;
            return this;
        }

        public Builder denyDomain(Domain domain) {
            Preconditions.checkNotNull((Object)domain);
            this.deniedEntity = domain.asString();
            this.deniedEntityType = DeniedEntityType.DOMAIN;
            return this;
        }

        public Builder denyAddress(MailAddress mailAddress) {
            Preconditions.checkNotNull((Object)mailAddress);
            this.deniedEntity = mailAddress.toString();
            this.deniedEntityType = DeniedEntityType.ADDRESS;
            return this;
        }

        public DropListEntry build() {
            Preconditions.checkArgument((this.deniedEntityType != null ? 1 : 0) != 0, (Object)"`deniedEntityType` is mandatory");
            Preconditions.checkArgument((this.ownerScope != null ? 1 : 0) != 0, (Object)"`ownerScope` is mandatory");
            Preconditions.checkArgument((this.deniedEntity != null && !this.deniedEntity.isBlank() ? 1 : 0) != 0, (Object)"`deniedEntity` must not be null, empty, or blank");
            return new DropListEntry(this.ownerScope, this.owner, this.deniedEntityType, this.deniedEntity);
        }
    }
}

