/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.upload;

import jakarta.inject.Inject;
import org.apache.james.backends.cassandra.components.CassandraQuotaCurrentValueDao;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaComponent;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.core.quota.QuotaType;
import org.apache.james.jmap.api.upload.UploadUsageRepository;
import reactor.core.publisher.Mono;

public class CassandraUploadUsageRepository
implements UploadUsageRepository {
    private static final QuotaSizeUsage DEFAULT_QUOTA_SIZE_USAGE = QuotaSizeUsage.size((long)0L);
    private final CassandraQuotaCurrentValueDao cassandraQuotaCurrentValueDao;

    @Inject
    public CassandraUploadUsageRepository(CassandraQuotaCurrentValueDao cassandraQuotaCurrentValueDao) {
        this.cassandraQuotaCurrentValueDao = cassandraQuotaCurrentValueDao;
    }

    public Mono<Void> increaseSpace(Username username, QuotaSizeUsage usage) {
        return this.cassandraQuotaCurrentValueDao.increase(CassandraQuotaCurrentValueDao.QuotaKey.of((QuotaComponent)QuotaComponent.JMAP_UPLOADS, (String)username.asString(), (QuotaType)QuotaType.SIZE), usage.asLong());
    }

    public Mono<Void> decreaseSpace(Username username, QuotaSizeUsage usage) {
        return this.cassandraQuotaCurrentValueDao.decrease(CassandraQuotaCurrentValueDao.QuotaKey.of((QuotaComponent)QuotaComponent.JMAP_UPLOADS, (String)username.asString(), (QuotaType)QuotaType.SIZE), usage.asLong());
    }

    public Mono<QuotaSizeUsage> getSpaceUsage(Username username) {
        return this.cassandraQuotaCurrentValueDao.getQuotaCurrentValue(CassandraQuotaCurrentValueDao.QuotaKey.of((QuotaComponent)QuotaComponent.JMAP_UPLOADS, (String)username.asString(), (QuotaType)QuotaType.SIZE)).map(quotaCurrentValue -> QuotaSizeUsage.size((long)quotaCurrentValue.getCurrentValue())).defaultIfEmpty((Object)DEFAULT_QUOTA_SIZE_USAGE);
    }

    public Mono<Void> resetSpace(Username username, QuotaSizeUsage newUsage) {
        return this.getSpaceUsage(username).switchIfEmpty(Mono.just((Object)QuotaSizeUsage.ZERO)).filter(quotaSizeUsage -> quotaSizeUsage.asLong() != newUsage.asLong()).flatMap(quotaSizeUsage -> this.decreaseSpace(username, QuotaSizeUsage.size((long)(quotaSizeUsage.asLong() - newUsage.asLong()))));
    }
}

