/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.api.SignatureRecord;
import org.apache.james.jdkim.exceptions.FailException;
import org.apache.james.jdkim.mailets.DKIMVerifier;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DKIMHook
implements JamesMessageHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(DKIMHook.class);
    @VisibleForTesting
    private final DKIMVerifier verifier;
    private Config config;
    private SignatureRecordValidation signatureRecordValidation;
    private DKIMCheckNeeded dkimCheckNeeded;

    @Inject
    public DKIMHook(PublicKeyRecordRetriever publicKeyRecordRetriever) {
        this.verifier = new DKIMVerifier(publicKeyRecordRetriever);
    }

    public void init(Configuration configuration) {
        this.config = Config.parse(configuration);
        this.dkimCheckNeeded = this.config.dkimCheckNeeded();
        this.signatureRecordValidation = this.config.signatureRecordValidation();
    }

    public HookResult onMessage(SMTPSession session, Mail mail) {
        if (!this.dkimCheckNeeded.test(mail)) {
            return HookResult.DECLINED;
        }
        try {
            return this.signatureRecordValidation.validate(mail.getMaybeSender(), this.verifier.verify(mail.getMessage(), this.config.forceCRLF));
        }
        catch (MessagingException e) {
            LOGGER.warn("Error while verifying DKIM signatures", (Throwable)e);
            return HookResult.builder().hookReturnCode(HookReturnCode.denySoft()).smtpReturnCode("451").smtpDescription("Failure computing DKIM signature.").build();
        }
        catch (FailException e) {
            LOGGER.warn("DKIM check failed. Invalid signature.", (Throwable)e);
            return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("530").smtpDescription("DKIM check failed. Invalid signature.").build();
        }
    }

    public static class Config {
        private final boolean forceCRLF;
        private final boolean signatureRequired;
        private final Optional<Domain> onlyForSenderDomain;
        private final Optional<String> expectedDToken;

        public static Config parse(Configuration config) {
            return new Config(config.getBoolean("forceCRLF", true), config.getBoolean("signatureRequired", true), Optional.ofNullable(config.getString("onlyForSenderDomain", null)).map(Domain::of), Optional.ofNullable(config.getString("expectedDToken", null)));
        }

        public Config(boolean forceCRLF, boolean signatureRequired, Optional<Domain> onlyForSenderDomain, Optional<String> expectedDToken) {
            this.forceCRLF = forceCRLF;
            this.signatureRequired = signatureRequired;
            this.onlyForSenderDomain = onlyForSenderDomain;
            this.expectedDToken = expectedDToken;
        }

        DKIMCheckNeeded dkimCheckNeeded() {
            return this.onlyForSenderDomain.map(DKIMCheckNeeded::onlyForSenderDomain).orElse(DKIMCheckNeeded.ALL);
        }

        SignatureRecordValidation signatureRecordValidation() {
            return SignatureRecordValidation.and(SignatureRecordValidation.signatureRequired(this.signatureRequired), this.expectedDToken.map(SignatureRecordValidation::expectedDToken).orElse(SignatureRecordValidation.ALLOW_ALL));
        }

        public final boolean equals(Object o) {
            if (o instanceof Config) {
                Config config = (Config)o;
                return this.forceCRLF == config.forceCRLF && this.signatureRequired == config.signatureRequired && Objects.equals(this.onlyForSenderDomain, config.onlyForSenderDomain) && Objects.equals(this.expectedDToken, config.expectedDToken);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.forceCRLF, this.signatureRequired, this.onlyForSenderDomain, this.expectedDToken);
        }
    }

    @FunctionalInterface
    static interface DKIMCheckNeeded
    extends Predicate<Mail> {
        public static final DKIMCheckNeeded ALL = any -> true;

        public static DKIMCheckNeeded onlyForSenderDomain(Domain domain) {
            return mail -> mail.getMaybeSender().asOptional().map(MailAddress::getDomain).map(arg_0 -> ((Domain)domain).equals(arg_0)).orElse(false);
        }
    }

    @FunctionalInterface
    static interface SignatureRecordValidation {
        public static final SignatureRecordValidation ALLOW_ALL = (sender, records) -> HookResult.DECLINED;

        public static SignatureRecordValidation and(SignatureRecordValidation a, SignatureRecordValidation b) {
            return (sender, records) -> {
                HookResult hookResult = a.validate(sender, records);
                if (hookResult.equals((Object)HookResult.DECLINED)) {
                    return b.validate(sender, records);
                }
                return hookResult;
            };
        }

        public static SignatureRecordValidation signatureRequired(boolean required) {
            return (sender, records) -> {
                if (required && (records == null || records.isEmpty())) {
                    LOGGER.warn("DKIM check failed. Expecting DKIM signatures. Got none.");
                    return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("530").smtpDescription("DKIM check failed. Expecting DKIM signatures. Got none.").build();
                }
                return HookResult.DECLINED;
            };
        }

        public static SignatureRecordValidation expectedDToken(String dToken) {
            return (sender, records) -> {
                if (records.stream().anyMatch(record -> record.getDToken().equals(dToken))) {
                    return HookResult.DECLINED;
                }
                LOGGER.warn("DKIM check failed. Wrong d token. Expecting {}. Got {}.", (Object)dToken, records.stream().map(SignatureRecord::getDToken).collect(ImmutableSet.toImmutableSet()));
                return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("530").smtpDescription("DKIM check failed. Wrong d token. Expecting " + dToken).build();
            };
        }

        public HookResult validate(MaybeSender var1, List<SignatureRecord> var2);
    }
}

