/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.Collection;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.transport.mailets.RecipientRewriteTableProcessor;
import org.apache.mailet.Mail;
import org.apache.mailet.ProcessingState;
import org.apache.mailet.base.GenericMailet;

public class RecipientRewriteTable
extends GenericMailet {
    public static final String ERROR_PROCESSOR = "errorProcessor";
    private final org.apache.james.rrt.api.RecipientRewriteTable virtualTableStore;
    private final DomainList domainList;
    private RecipientRewriteTableProcessor processor;
    private ProcessingState errorProcessor;
    private boolean rewriteSenderUponForward = true;
    private boolean forwardAutoSubmittedEmails = false;

    @Inject
    public RecipientRewriteTable(org.apache.james.rrt.api.RecipientRewriteTable virtualTableStore, DomainList domainList) {
        this.virtualTableStore = virtualTableStore;
        this.domainList = domainList;
    }

    public void init() throws MessagingException {
        this.errorProcessor = new ProcessingState(this.getInitParameter(ERROR_PROCESSOR, "error"));
        this.rewriteSenderUponForward = this.getBooleanParameter("rewriteSenderUponForward", true);
        this.forwardAutoSubmittedEmails = this.getBooleanParameter("forwardAutoSubmittedEmails", false);
        this.processor = new RecipientRewriteTableProcessor(this.virtualTableStore, this.domainList, this.getMailetContext(), this.errorProcessor, this.rewriteSenderUponForward, this.forwardAutoSubmittedEmails);
    }

    public void service(Mail mail) throws MessagingException {
        Preconditions.checkNotNull((Object)mail);
        MimeMessage message = mail.getMessage();
        if (message != null) {
            this.processor.processMail(mail);
        }
    }

    public String getMailetInfo() {
        return "RecipientRewriteTable Mailet";
    }

    public Collection<ProcessingState> requiredProcessingState() {
        return ImmutableList.of((Object)this.errorProcessor);
    }
}

