/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.upload;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.InputStream;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.jmap.api.model.Upload;
import org.apache.james.jmap.api.model.UploadId;
import org.apache.james.jmap.api.model.UploadMetaData;
import org.apache.james.jmap.api.upload.JmapUploadQuotaConfiguration;
import org.apache.james.jmap.api.upload.UploadRepository;
import org.apache.james.jmap.api.upload.UploadService;
import org.apache.james.jmap.api.upload.UploadUsageRepository;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.util.FunctionalUtils;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class UploadServiceDefaultImpl
implements UploadService {
    private final UploadRepository uploadRepository;
    private final UploadUsageRepository uploadUsageRepository;
    private final JmapUploadQuotaConfiguration jmapUploadQuotaConfiguration;

    @Inject
    @Singleton
    public UploadServiceDefaultImpl(UploadRepository uploadRepository, UploadUsageRepository uploadUsageRepository, JmapUploadQuotaConfiguration jmapUploadQuotaConfiguration) {
        this.uploadRepository = uploadRepository;
        this.uploadUsageRepository = uploadUsageRepository;
        this.jmapUploadQuotaConfiguration = jmapUploadQuotaConfiguration;
    }

    @Override
    public Publisher<UploadMetaData> upload(InputStream data, ContentType contentType, Username user) {
        return Mono.from(this.uploadRepository.upload(data, contentType, user)).flatMap(upload -> Mono.from(this.uploadUsageRepository.increaseSpace(user, QuotaSizeUsage.size((long)upload.sizeAsLong()))).thenReturn(upload)).doOnSuccess(uploaded -> this.cleanupUploadIfNeeded(user, (UploadMetaData)uploaded).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).subscribe());
    }

    @Override
    public Publisher<Upload> retrieve(UploadId id, Username user) {
        return this.uploadRepository.retrieve(id, user);
    }

    private Mono<Void> cleanupUploadIfNeeded(Username username, UploadMetaData notCleanUpload) {
        return Mono.from(this.uploadUsageRepository.getSpaceUsage(username)).map(QuotaSizeUsage::asLong).filter(this.quotaExceededPredicate()).switchIfEmpty(Mono.empty()).flatMap(quotaExceeded -> this.cleanupUpload(username, (long)quotaExceeded, notCleanUpload));
    }

    private Predicate<Long> quotaExceededPredicate() {
        return currentUploadUsage -> currentUploadUsage > this.jmapUploadQuotaConfiguration.getUploadQuotaLimitInBytes();
    }

    private Mono<Void> cleanupUpload(Username username, long currentUploadUsage, UploadMetaData notCleanUpload) {
        long minimumSpaceToClean = currentUploadUsage - this.jmapUploadQuotaConfiguration.getUploadQuotaLimitInBytes() / 2L;
        AtomicLong cleanedSpace = new AtomicLong(0L);
        return Flux.from(this.uploadRepository.listUploads(username)).filter(upload -> !upload.equals(notCleanUpload)).sort(Comparator.comparing(UploadMetaData::uploadDate)).concatMap(this.deleteUpload(username, minimumSpaceToClean, cleanedSpace)).map(UploadMetaData::sizeAsLong).reduce((Object)notCleanUpload.sizeAsLong(), Long::sum).filter(totalSpaceUsed -> totalSpaceUsed != currentUploadUsage).flatMap(totalSpaceUsed -> Mono.from(this.uploadUsageRepository.resetSpace(username, QuotaSizeUsage.size((long)totalSpaceUsed)))).then();
    }

    private Function<UploadMetaData, Publisher<? extends UploadMetaData>> deleteUpload(Username username, long minimumSpaceToClean, AtomicLong cleanedSpace) {
        return upload -> {
            if (cleanedSpace.get() < minimumSpaceToClean) {
                return Mono.from(this.uploadRepository.delete(upload.uploadId(), username)).filter(FunctionalUtils.identityPredicate()).flatMap(deleted -> Mono.from(this.uploadUsageRepository.decreaseSpace(username, QuotaSizeUsage.size((long)upload.sizeAsLong()))).then(Mono.fromCallable(() -> cleanedSpace.addAndGet(upload.sizeAsLong()))).then(Mono.empty()));
            }
            return Mono.fromCallable(() -> upload);
        };
    }
}

