/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import jakarta.mail.Flags;
import org.apache.james.mailbox.MessageManager;

public class FlagsUpdateCalculator {
    private final Flags providedFlags;
    private final MessageManager.FlagsUpdateMode mode;

    public FlagsUpdateCalculator(Flags providedFlags, MessageManager.FlagsUpdateMode mode) {
        this.providedFlags = providedFlags;
        this.mode = mode;
    }

    public Flags buildNewFlags(Flags oldFlags) {
        Flags updatedFlags = new Flags(oldFlags);
        switch (this.mode) {
            case REPLACE: {
                return new Flags(this.providedFlags);
            }
            case ADD: {
                updatedFlags.add(this.providedFlags);
                break;
            }
            case REMOVE: {
                updatedFlags.remove(this.providedFlags);
            }
        }
        return updatedFlags;
    }
}

