/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.stream.Stream;
import org.apache.james.utils.ClassName;
import org.apache.james.utils.ExtendedClassLoader;
import org.apache.james.utils.ExtensionConfiguration;
import org.apache.james.utils.FullyQualifiedClassName;
import org.apache.james.utils.NamingScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceGenericLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuiceGenericLoader.class);
    private final Injector injector;
    private final ExtendedClassLoader extendedClassLoader;

    @VisibleForTesting
    public static GuiceGenericLoader forTesting(ExtendedClassLoader extendedClassLoader) {
        return new GuiceGenericLoader(Guice.createInjector((Module[])new Module[0]), extendedClassLoader, ExtensionConfiguration.DEFAULT);
    }

    @Inject
    public GuiceGenericLoader(Injector injector, ExtendedClassLoader extendedClassLoader, ExtensionConfiguration extensionConfiguration) {
        this.extendedClassLoader = extendedClassLoader;
        Module additionalExtensionBindings = Modules.combine((Iterable)((Iterable)extensionConfiguration.getAdditionalGuiceModulesForExtensions().stream().map(Throwing.function(className -> (Module)this.instantiateNoChildModule(injector, (ClassName)className))).peek(module -> LOGGER.info("Enabling injects contained in " + module.getClass().getCanonicalName())).collect(ImmutableList.toImmutableList())));
        this.injector = injector.createChildInjector(new Module[]{additionalExtensionBindings});
    }

    private <T> T instantiateNoChildModule(Injector injector, ClassName className) throws ClassNotFoundException {
        return new InvocationPerformer(injector, this.extendedClassLoader, NamingScheme.IDENTITY).instantiate(className);
    }

    public <T> T instantiate(ClassName className) throws ClassNotFoundException {
        return new InvocationPerformer(this.injector, this.extendedClassLoader, NamingScheme.IDENTITY).instantiate(className);
    }

    public <T> InvocationPerformer<T> withNamingSheme(NamingScheme namingSheme) {
        return new InvocationPerformer(this.injector, this.extendedClassLoader, namingSheme);
    }

    public <T> InvocationPerformer<T> withChildModule(Module childModule) {
        return new InvocationPerformer(this.injector.createChildInjector(new Module[]{childModule}), this.extendedClassLoader, NamingScheme.IDENTITY);
    }

    public static class InvocationPerformer<T> {
        private final Injector injector;
        private final ExtendedClassLoader extendedClassLoader;
        private final NamingScheme namingSheme;

        private InvocationPerformer(Injector injector, ExtendedClassLoader extendedClassLoader, NamingScheme namingSheme) {
            this.injector = injector;
            this.extendedClassLoader = extendedClassLoader;
            this.namingSheme = namingSheme;
        }

        public T instantiate(ClassName className) throws ClassNotFoundException {
            Class<T> clazz = this.locateClass(className, this.namingSheme);
            return (T)this.injector.getInstance(clazz);
        }

        private Class<T> locateClass(ClassName className, NamingScheme namingScheme) throws ClassNotFoundException {
            ImmutableList classes = (ImmutableList)namingScheme.toFullyQualifiedClassNames(className).flatMap(this::tryLocateClass).collect(ImmutableList.toImmutableList());
            if (classes.size() == 0) {
                throw new ClassNotFoundException(className.getName());
            }
            if (classes.size() > 1) {
                LOGGER.warn("Ambiguous class name for {}. Corresponding classes are {} and {} will be loaded", new Object[]{className, classes, classes.get(0)});
            }
            return (Class)classes.get(0);
        }

        private Stream<Class<T>> tryLocateClass(FullyQualifiedClassName className) {
            return this.extendedClassLoader.locateClass(className).stream();
        }
    }
}

