/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.ConnectionFactory;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;
import org.apache.james.backends.rabbitmq.RabbitMQConnectionFactory;
import org.apache.james.backends.rabbitmq.ReactorRabbitMQChannelPool;
import org.apache.james.backends.rabbitmq.SimpleConnectionPool;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.NoopGaugeRegistry;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.rabbitmq.ExchangeSpecification;
import reactor.rabbitmq.OutboundMessage;
import reactor.rabbitmq.Sender;

public class AmqpForwardAttribute
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpForwardAttribute.class);
    private static final int MAX_THREE_RETRIES = 3;
    private static final int MIN_DELAY_OF_TEN_MILLISECONDS = 10;
    private static final int CONNECTION_TIMEOUT_OF_ONE_HUNDRED_MILLISECOND = 100;
    private static final int CHANNEL_RPC_TIMEOUT_OF_ONE_HUNDRED_MILLISECOND = 100;
    private static final int HANDSHAKE_TIMEOUT_OF_ONE_HUNDRED_MILLISECOND = 100;
    private static final int SHUTDOWN_TIMEOUT_OF_ONE_HUNDRED_MILLISECOND = 100;
    private static final int NETWORK_RECOVERY_INTERVAL_OF_ONE_HUNDRED_MILLISECOND = 100;
    private static final String DEFAULT_USER = "guest";
    private static final String DEFAULT_PASSWORD_STRING = "guest";
    private static final char[] DEFAULT_PASSWORD = "guest".toCharArray();
    static final RabbitMQConfiguration.ManagementCredentials DEFAULT_MANAGEMENT_CREDENTIAL = new RabbitMQConfiguration.ManagementCredentials("guest", DEFAULT_PASSWORD);
    public static final String URI_PARAMETER_NAME = "uri";
    public static final String EXCHANGE_PARAMETER_NAME = "exchange";
    public static final String ROUTING_KEY_PARAMETER_NAME = "routing_key";
    public static final String ATTRIBUTE_PARAMETER_NAME = "attribute";
    public static final String ROUTING_KEY_DEFAULT_VALUE = "";
    private final MetricFactory metricFactory;
    private String exchange;
    private AttributeName attribute;
    private ConnectionFactory connectionFactory;
    @VisibleForTesting
    String routingKey;
    private SimpleConnectionPool connectionPool;
    private ReactorRabbitMQChannelPool reactorRabbitMQChannelPool;
    private Sender sender;

    @Inject
    public AmqpForwardAttribute(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    public void init() throws MailetException {
        MailetConfig mailetConfig = this.getMailetConfig();
        String uri = this.preInit(mailetConfig);
        try {
            URI amqpUri = new URI(uri);
            RabbitMQConfiguration rabbitMQConfiguration = RabbitMQConfiguration.builder().amqpUri(amqpUri).managementUri(amqpUri).managementCredentials(this.retrieveCredentials(amqpUri)).maxRetries(3).minDelayInMs(10).connectionTimeoutInMs(100).channelRpcTimeoutInMs(100).handshakeTimeoutInMs(100).shutdownTimeoutInMs(100).networkRecoveryIntervalInMs(100).build();
            this.connectionPool = new SimpleConnectionPool(new RabbitMQConnectionFactory(rabbitMQConfiguration), SimpleConnectionPool.Configuration.builder().retries(2).initialDelay(Duration.ofMillis(5L)));
            this.reactorRabbitMQChannelPool = new ReactorRabbitMQChannelPool(this.connectionPool.getResilientConnection(), ReactorRabbitMQChannelPool.Configuration.DEFAULT, this.metricFactory, (GaugeRegistry)new NoopGaugeRegistry());
            this.reactorRabbitMQChannelPool.start();
            this.sender = this.reactorRabbitMQChannelPool.getSender();
            this.sender.declareExchange(ExchangeSpecification.exchange((String)this.exchange));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    RabbitMQConfiguration.ManagementCredentials retrieveCredentials(URI amqpUri) {
        return Optional.ofNullable(amqpUri.getUserInfo()).map(this::parseUserInfo).orElse(DEFAULT_MANAGEMENT_CREDENTIAL);
    }

    private RabbitMQConfiguration.ManagementCredentials parseUserInfo(String userInfo) {
        Preconditions.checkArgument((boolean)userInfo.contains(":"), (Object)"User info needs a password part");
        List parts = Splitter.on((char)':').splitToList((CharSequence)userInfo);
        ImmutableList passwordParts = (ImmutableList)parts.stream().skip(1L).collect(ImmutableList.toImmutableList());
        return new RabbitMQConfiguration.ManagementCredentials((String)parts.get(0), Joiner.on((char)':').join((Iterable)passwordParts).toCharArray());
    }

    @VisibleForTesting
    String preInit(MailetConfig mailetConfig) throws MailetException {
        String uri = mailetConfig.getInitParameter(URI_PARAMETER_NAME);
        if (Strings.isNullOrEmpty((String)uri)) {
            throw new MailetException("No value for uri parameter was provided.");
        }
        this.exchange = mailetConfig.getInitParameter(EXCHANGE_PARAMETER_NAME);
        if (Strings.isNullOrEmpty((String)this.exchange)) {
            throw new MailetException("No value for exchange parameter was provided.");
        }
        this.routingKey = Optional.ofNullable(mailetConfig.getInitParameter(ROUTING_KEY_PARAMETER_NAME)).orElse(ROUTING_KEY_DEFAULT_VALUE);
        String rawAttribute = mailetConfig.getInitParameter(ATTRIBUTE_PARAMETER_NAME);
        if (Strings.isNullOrEmpty((String)rawAttribute)) {
            throw new MailetException("No value for attribute parameter was provided.");
        }
        this.attribute = AttributeName.of((String)rawAttribute);
        this.connectionFactory = new ConnectionFactory();
        try {
            this.connectionFactory.setUri(uri);
        }
        catch (Exception e) {
            throw new MailetException("Invalid uri parameter was provided: " + uri, e);
        }
        return uri;
    }

    @PreDestroy
    public void cleanUp() {
        this.sender.close();
        this.reactorRabbitMQChannelPool.close();
        this.connectionPool.close();
    }

    @VisibleForTesting
    void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void service(Mail mail) throws MailetException {
        mail.getAttribute(this.attribute).map(Throwing.function(this::getAttributeContent).sneakyThrow()).ifPresent(this::sendContent);
    }

    private Stream<byte[]> getAttributeContent(Attribute attribute) throws MailetException {
        return this.extractAttributeValueContent(attribute.getValue().value()).orElseThrow(() -> new MailetException("Invalid attribute found into attribute " + this.attribute.asString() + "class Map or List or String expected but " + attribute.toString() + " found."));
    }

    private Optional<Stream<byte[]>> extractAttributeValueContent(Object attributeContent) {
        if (attributeContent instanceof Map) {
            return Optional.of(((Map)attributeContent).values().stream().map(AttributeValue::getValue));
        }
        if (attributeContent instanceof List) {
            return Optional.of(((List)attributeContent).stream().map(AttributeValue::value));
        }
        if (attributeContent instanceof String) {
            return Optional.of(Stream.of(((String)attributeContent).getBytes(StandardCharsets.UTF_8)));
        }
        return Optional.empty();
    }

    private void sendContent(Stream<byte[]> content) {
        try {
            this.sender.send((Publisher)Flux.fromStream(content).map(bytes -> new OutboundMessage(this.exchange, this.routingKey, bytes))).block();
        }
        catch (AlreadyClosedException e) {
            LOGGER.error("AlreadyClosedException while writing to AMQP: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (Exception e) {
            LOGGER.error("IOException while writing to AMQP: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public String getMailetInfo() {
        return "AmqpForwardAttribute";
    }
}

