/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.lib;

import com.google.common.collect.ImmutableList;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.MailAddress;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.mailetcontainer.api.MailProcessor;
import org.apache.james.mailetcontainer.api.MailetLoader;
import org.apache.james.mailetcontainer.api.MatcherLoader;
import org.apache.james.mailetcontainer.impl.MailetConfigImpl;
import org.apache.james.mailetcontainer.impl.MatcherConfigImpl;
import org.apache.james.mailetcontainer.impl.MatcherMailetPair;
import org.apache.james.mailetcontainer.impl.jmx.JMXStateMailetProcessorListener;
import org.apache.james.mailetcontainer.impl.matchers.CompositeMatcher;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetContext;
import org.apache.mailet.Matcher;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.MatcherInverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStateMailetProcessor
implements MailProcessor,
Configurable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStateMailetProcessor.class);
    private MailetContext mailetContext;
    private MatcherLoader matcherLoader;
    private MailProcessor rootMailProcessor;
    private final Collection<MailetProcessorListener> listeners = new ConcurrentLinkedDeque<MailetProcessorListener>();
    private JMXStateMailetProcessorListener jmxListener;
    private boolean enableJmx = true;
    private HierarchicalConfiguration<ImmutableNode> config;
    private MailetLoader mailetLoader;
    private final List<MatcherMailetPair> pairs = new ArrayList<MatcherMailetPair>();
    private String state;

    public void setMatcherLoader(MatcherLoader matcherLoader) {
        this.matcherLoader = matcherLoader;
    }

    public void setRootMailProcessor(MailProcessor rootMailProcessor) {
        this.rootMailProcessor = rootMailProcessor;
    }

    @Inject
    public void setMailetContext(MailetContext mailetContext) {
        this.mailetContext = mailetContext;
    }

    @Inject
    public void setMailetLoader(MailetLoader mailetLoader) {
        this.mailetLoader = mailetLoader;
    }

    public void configure(HierarchicalConfiguration<ImmutableNode> config) throws ConfigurationException {
        this.state = config.getString("[@state]", null);
        if (this.state == null) {
            throw new ConfigurationException("Processor state attribute must be configured");
        }
        if (this.state.equals("ghost")) {
            throw new ConfigurationException("Processor state of ghost is reserved for internal use, choose a different one");
        }
        this.enableJmx = config.getBoolean("[@enableJmx]", true);
        this.config = config;
    }

    @PostConstruct
    public void init() throws Exception {
        this.parseConfiguration();
        this.setupRouting(this.pairs);
        if (this.enableJmx) {
            this.jmxListener = new JMXStateMailetProcessorListener(this.state, this);
            this.addListener(this.jmxListener);
        }
    }

    @PreDestroy
    public void destroy() {
        this.listeners.clear();
        if (this.enableJmx && this.jmxListener != null) {
            this.jmxListener.dispose();
        }
        for (MatcherMailetPair pair : this.pairs) {
            Mailet mailet = pair.getMailet();
            Matcher matcher = pair.getMatcher();
            LOGGER.debug("Shutdown matcher {}", (Object)matcher.getMatcherInfo());
            matcher.destroy();
            LOGGER.debug("Shutdown mailet {}", (Object)mailet.getMailetInfo());
            mailet.destroy();
        }
    }

    protected void toProcessor(Mail mail) throws MessagingException {
        this.rootMailProcessor.service(mail);
    }

    protected String getState() {
        return this.state;
    }

    public List<Mailet> getMailets() {
        return (List)this.pairs.stream().map(MatcherMailetPair::getMailet).collect(ImmutableList.toImmutableList());
    }

    public List<Matcher> getMatchers() {
        return (List)this.pairs.stream().map(MatcherMailetPair::getMatcher).collect(ImmutableList.toImmutableList());
    }

    public void addListener(MailetProcessorListener listener) {
        this.listeners.add(listener);
    }

    public List<MailetProcessorListener> getListeners() {
        return ImmutableList.copyOf(this.listeners);
    }

    private MailetConfig createMailetConfig(String mailetName, HierarchicalConfiguration<ImmutableNode> configuration) {
        MailetConfigImpl configImpl = new MailetConfigImpl();
        configImpl.setMailetName(mailetName);
        configImpl.setConfiguration((Configuration)configuration);
        configImpl.setMailetContext(this.mailetContext);
        return configImpl;
    }

    private MatcherConfig createMatcherConfig(String matchName) {
        String condition = null;
        int i = matchName.indexOf(61);
        if (i != -1) {
            condition = matchName.substring(i + 1);
            matchName = matchName.substring(0, i);
        }
        MatcherConfigImpl configImpl = new MatcherConfigImpl();
        configImpl.setMatcherName(matchName);
        configImpl.setCondition(condition);
        configImpl.setMailetContext(this.mailetContext);
        return configImpl;
    }

    private List<Matcher> loadCompositeMatchers(String state, Map<String, Matcher> compMap, List<HierarchicalConfiguration<ImmutableNode>> compMatcherConfs) throws ConfigurationException, MessagingException {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (HierarchicalConfiguration<ImmutableNode> c : compMatcherConfs) {
            String compName = c.getString("[@name]", null);
            String matcherName = c.getString("[@match]", null);
            String invertedMatcherName = c.getString("[@notmatch]", null);
            Matcher matcher = null;
            if (matcherName != null && invertedMatcherName != null) {
                throw new ConfigurationException("Please configure only match or nomatch per mailet");
            }
            if (matcherName != null) {
                matcher = this.matcherLoader.getMatcher(this.createMatcherConfig(matcherName));
                if (matcher instanceof CompositeMatcher) {
                    CompositeMatcher compMatcher = (CompositeMatcher)matcher;
                    List<Matcher> childMatcher = this.loadCompositeMatchers(state, compMap, c.configurationsAt("matcher"));
                    for (Matcher aChildMatcher : childMatcher) {
                        compMatcher.add(aChildMatcher);
                    }
                }
            } else if (invertedMatcherName != null) {
                Matcher m = this.matcherLoader.getMatcher(this.createMatcherConfig(invertedMatcherName));
                if (m instanceof CompositeMatcher) {
                    CompositeMatcher compMatcher = (CompositeMatcher)m;
                    List<Matcher> childMatcher = this.loadCompositeMatchers(state, compMap, c.configurationsAt("matcher"));
                    for (Matcher aChildMatcher : childMatcher) {
                        compMatcher.add(aChildMatcher);
                    }
                }
                matcher = new MatcherInverter(m);
            }
            if (matcher == null) {
                throw new ConfigurationException("Unable to load matcher instance");
            }
            matchers.add(matcher);
            if (compName == null) continue;
            if (compMap.containsKey(compName)) {
                throw new ConfigurationException("CompositeMatcher with name " + compName + " is already defined in processor " + state);
            }
            compMap.put(compName, matcher);
        }
        return matchers;
    }

    private void parseConfiguration() throws MessagingException, ConfigurationException {
        HashMap<String, Matcher> compositeMatchers = new HashMap<String, Matcher>();
        this.loadCompositeMatchers(this.getState(), compositeMatchers, this.config.configurationsAt("matcher"));
        List mailetConfs = this.config.configurationsAt("mailet");
        for (HierarchicalConfiguration c : mailetConfs) {
            Mailet mailet;
            Matcher matcher;
            String mailetClassName = c.getString("[@class]");
            String matcherName = c.getString("[@match]", null);
            String invertedMatcherName = c.getString("[@notmatch]", null);
            try {
                if (matcherName != null && invertedMatcherName != null) {
                    throw new ConfigurationException("Please configure only match or nomatch per mailet");
                }
                if (matcherName != null) {
                    matcher = (Matcher)compositeMatchers.get(matcherName);
                    if (matcher == null) {
                        matcher = this.matcherLoader.getMatcher(this.createMatcherConfig(matcherName));
                    }
                } else if (invertedMatcherName != null) {
                    matcher = this.matcherLoader.getMatcher(this.createMatcherConfig(invertedMatcherName));
                    matcher = new MatcherInverter(matcher);
                } else {
                    matcher = this.matcherLoader.getMatcher(this.createMatcherConfig("All"));
                    LOGGER.debug("Mailet {} has no 'match' attribute. Defaulting to match all mails.", (Object)mailetClassName);
                }
                LOGGER.info("Matcher {} instantiated.", (Object)matcherName);
            }
            catch (MessagingException ex) {
                LOGGER.error("Unable to init matcher {}", (Object)matcherName, (Object)ex);
                if (ex.getNextException() != null) {
                    LOGGER.error("Caused by nested exception: ", (Throwable)ex.getNextException());
                }
                throw new ConfigurationException("Unable to init matcher " + matcherName, (Throwable)ex);
            }
            try {
                mailet = this.mailetLoader.getMailet(this.createMailetConfig(mailetClassName, (HierarchicalConfiguration<ImmutableNode>)c));
                LOGGER.info("Mailet {} instantiated.", (Object)mailetClassName);
            }
            catch (MessagingException ex) {
                LOGGER.error("Unable to init mailet {}", (Object)mailetClassName, (Object)ex);
                if (ex.getNextException() != null) {
                    LOGGER.error("Caused by nested exception: ", (Throwable)ex.getNextException());
                }
                throw new ConfigurationException("Unable to init mailet " + mailetClassName, (Throwable)ex);
            }
            if (matcher != null && mailet != null) {
                this.pairs.add(new MatcherMailetPair(matcher, mailet));
                continue;
            }
            throw new ConfigurationException("Unable to load Mailet or Matcher");
        }
    }

    protected abstract void setupRouting(List<MatcherMailetPair> var1) throws MessagingException;

    public static interface MailetProcessorListener {
        public void afterMailet(Mailet var1, String var2, String var3, long var4, Throwable var6);

        public void afterMatcher(Matcher var1, String var2, Collection<MailAddress> var3, Collection<MailAddress> var4, long var5, Throwable var7);
    }
}

