/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Scopes;
import jakarta.mail.Flags;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.SearchConfiguration;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.search.SimpleMessageSearchIndex;
import org.apache.james.modules.mailbox.OpenSearchClientModule;
import org.apache.james.modules.mailbox.OpenSearchDisabledModule;
import org.apache.james.modules.mailbox.OpenSearchMailboxModule;
import org.apache.james.modules.server.ReIndexingModule;
import org.apache.james.quota.search.QuotaSearcher;
import org.apache.james.quota.search.scanning.ScanningQuotaSearcher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SearchModuleChooser {
    public static List<Module> chooseModules(SearchConfiguration searchConfiguration) {
        switch (searchConfiguration.getImplementation()) {
            case OpenSearch: {
                return ImmutableList.of((Object)((Object)new OpenSearchClientModule()), (Object)((Object)new OpenSearchMailboxModule()), (Object)new ReIndexingModule());
            }
            case Scanning: {
                return ImmutableList.of((Object)((Object)new ScanningQuotaSearchModule()), (Object)((Object)new ScanningSearchModule()));
            }
            case OpenSearchDisabled: {
                return ImmutableList.of((Object)((Object)new OpenSearchDisabledModule()), (Object)((Object)new ScanningQuotaSearchModule()));
            }
        }
        throw new RuntimeException("Unsupported search implementation " + String.valueOf((Object)searchConfiguration.getImplementation()));
    }

    private static class ScanningQuotaSearchModule
    extends AbstractModule {
        private ScanningQuotaSearchModule() {
        }

        protected void configure() {
            this.bind(ScanningQuotaSearcher.class).in(Scopes.SINGLETON);
            this.bind(QuotaSearcher.class).to(ScanningQuotaSearcher.class);
        }
    }

    private static class ScanningSearchModule
    extends AbstractModule {
        private ScanningSearchModule() {
        }

        protected void configure() {
            this.bind(MessageSearchIndex.class).to(SimpleMessageSearchIndex.class);
            this.bind(FakeMessageSearchIndex.class).in(Scopes.SINGLETON);
            this.bind(ListeningMessageSearchIndex.class).to(FakeMessageSearchIndex.class);
        }
    }

    private static class FakeMessageSearchIndex
    extends ListeningMessageSearchIndex {
        public FakeMessageSearchIndex() {
            super(null, (Set)ImmutableSet.of(), null);
        }

        public Mono<Void> add(MailboxSession session, Mailbox mailbox, MailboxMessage message) {
            throw new NotImplementedException("not implemented");
        }

        public Mono<Void> delete(MailboxSession session, MailboxId mailboxId, Collection<MessageUid> expungedUids) {
            throw new NotImplementedException("not implemented");
        }

        public Mono<Void> deleteAll(MailboxSession session, MailboxId mailboxId) {
            throw new NotImplementedException("not implemented");
        }

        public Mono<Void> update(MailboxSession session, MailboxId mailboxId, List<UpdatedFlags> updatedFlagsList) {
            throw new NotImplementedException("not implemented");
        }

        public Mono<Flags> retrieveIndexedFlags(Mailbox mailbox, MessageUid uid) {
            throw new NotImplementedException("not implemented");
        }

        public Group getDefaultGroup() {
            throw new NotImplementedException("not implemented");
        }

        public void postReindexing() {
            throw new NotImplementedException("not implemented");
        }

        public Flux<MessageUid> doSearch(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) throws MailboxException {
            throw new NotImplementedException("not implemented");
        }

        public Flux<MessageId> search(MailboxSession session, Collection<MailboxId> mailboxIds, SearchQuery searchQuery, long limit) {
            throw new NotImplementedException("not implemented");
        }

        public EnumSet<MailboxManager.SearchCapabilities> getSupportedCapabilities(EnumSet<MailboxManager.MessageCapabilities> messageCapabilities) {
            throw new NotImplementedException("not implemented");
        }

        public EventListener.ExecutionMode getExecutionMode() {
            throw new NotImplementedException("not implemented");
        }
    }
}

