/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.james.core.Username;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.display.ModifiedUtf7;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.StatusDataItems;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.MailboxType;
import org.apache.james.imap.api.process.MailboxTyper;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.ListRequest;
import org.apache.james.imap.message.response.ListResponse;
import org.apache.james.imap.message.response.MailboxStatusResponse;
import org.apache.james.imap.message.response.MyRightsResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.StatusProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.model.search.PrefixedRegex;
import org.apache.james.mailbox.model.search.Wildcard;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ListProcessor<T extends ListRequest>
extends AbstractMailboxProcessor<T>
implements CapabilityImplementingProcessor {
    public static final boolean RETURN_SUBSCRIBED = true;
    public static final boolean RETURN_NON_EXISTENT = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(ListProcessor.class);
    private static final List<Capability> CAPA = ImmutableList.of((Object)Capability.of("LIST-EXTENDED"), (Object)Capability.of("LIST-STATUS"), (Object)Capability.of("LIST-MYRIGHTS"), (Object)Capability.of("SPECIAL-USE"));
    private final SubscriptionManager subscriptionManager;
    private final StatusProcessor statusProcessor;
    protected final MailboxTyper mailboxTyper;

    @Inject
    public ListProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory, SubscriptionManager subscriptionManager, StatusProcessor statusProcessor, MailboxTyper mailboxTyper) {
        this(ListRequest.class, mailboxManager, factory, metricFactory, subscriptionManager, statusProcessor, mailboxTyper);
    }

    public ListProcessor(Class<T> clazz, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory, SubscriptionManager subscriptionManager, StatusProcessor statusProcessor, MailboxTyper mailboxTyper) {
        super(clazz, mailboxManager, factory, metricFactory);
        this.subscriptionManager = subscriptionManager;
        this.statusProcessor = statusProcessor;
        this.mailboxTyper = mailboxTyper;
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPA;
    }

    @Override
    protected Mono<Void> processRequestReactive(T request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxSession mailboxSession = session.getMailboxSession();
        return this.respond(session, responder, request, mailboxSession).then(Mono.fromRunnable(() -> this.okComplete((ImapRequest)request, responder))).onErrorResume(MailboxException.class, e -> {
            this.no((ImapRequest)request, responder, HumanReadableText.SEARCH_FAILED);
            return ReactorUtils.logAsMono(() -> LOGGER.error("List failed for mailboxName {}", (Object)request.getMailboxPattern(), (Object)e));
        }).then();
    }

    private Mono<Void> respond(ImapSession session, ImapProcessor.Responder responder, T request, MailboxSession mailboxSession) {
        if (((ListRequest)request).getMailboxPattern().length() == 0) {
            return Mono.fromRunnable(() -> this.respondNamespace(request.getBaseReferenceName(), responder, mailboxSession));
        }
        return this.respondMailboxList(request, session, responder, mailboxSession);
    }

    protected ImapResponseMessage createResponse(MailboxMetaData.Children children, MailboxMetaData.Selectability selectability, String name, char hierarchyDelimiter, MailboxType type, boolean isSubscribed) {
        return new ListResponse(children, selectability, name, hierarchyDelimiter, isSubscribed, false, EnumSet.noneOf(ListResponse.ChildInfo.class), type);
    }

    private void respondNamespace(String referenceName, ImapProcessor.Responder responder, MailboxSession mailboxSession) {
        String referenceRoot = ModifiedUtf7.decodeModifiedUTF7(this.computeReferenceRoot(referenceName, mailboxSession));
        responder.respond(this.createResponse(MailboxMetaData.Children.CHILDREN_ALLOWED_BUT_UNKNOWN, MailboxMetaData.Selectability.NOSELECT, referenceRoot, mailboxSession.getPathDelimiter(), MailboxType.OTHER, false));
    }

    private String computeReferenceRoot(String referenceName, MailboxSession mailboxSession) {
        if (referenceName.length() > 0 && referenceName.charAt(0) == '#') {
            int firstDelimiter = referenceName.indexOf(mailboxSession.getPathDelimiter());
            if (firstDelimiter == -1) {
                return referenceName;
            }
            return referenceName.substring(0, firstDelimiter);
        }
        return "";
    }

    private Mono<Void> respondMailboxList(T request, ImapSession session, ImapProcessor.Responder responder, MailboxSession mailboxSession) {
        if (((ListRequest)request).selectRemote()) {
            return Mono.empty();
        }
        String finalReferencename = ((ListRequest)request).getBaseReferenceName();
        if (((ListRequest)request).getMailboxPattern().charAt(0) == '#') {
            finalReferencename = "";
        }
        boolean isRelative = (finalReferencename + ((ListRequest)request).getMailboxPattern()).charAt(0) != '#';
        MailboxQuery mailboxQuery = this.mailboxQuery(this.computeBasePath(session, finalReferencename, isRelative), ((ListRequest)request).getMailboxPattern(), mailboxSession);
        if (((ListRequest)request).selectSubscribed()) {
            return this.processWithSubscribed(session, request, responder, mailboxSession, isRelative, mailboxQuery);
        }
        if (((ListRequest)request).getReturnOptions().contains((Object)ListRequest.ListReturnOption.SUBSCRIBED)) {
            return Flux.from((Publisher)((Publisher)Throwing.supplier(() -> this.subscriptionManager.subscriptionsReactive(mailboxSession)).get())).collect(ImmutableMap.toImmutableMap(path -> path, path -> path)).flatMap(subscribed -> this.processWithoutSubscribed(session, request, responder, mailboxSession, isRelative, mailboxQuery, arg_0 -> ((ImmutableMap)subscribed).containsKey(arg_0)));
        }
        return this.processWithoutSubscribed(session, request, responder, mailboxSession, isRelative, mailboxQuery, any -> false);
    }

    private Mono<Void> processWithoutSubscribed(ImapSession session, T request, ImapProcessor.Responder responder, MailboxSession mailboxSession, boolean isRelative, MailboxQuery mailboxQuery, Predicate<MailboxPath> isSubscribed) {
        return this.getMailboxManager().search(mailboxQuery, MailboxManager.MailboxSearchFetchType.Minimal, mailboxSession).doOnNext(metaData -> {
            MailboxType mailboxType = this.getMailboxType((ListRequest)request, session, metaData.getPath());
            if (!request.getSelectOptions().contains((Object)ListRequest.ListSelectOption.SPECIAL_USE) || mailboxType.getRfc6154attributeName() != null) {
                responder.respond(this.createResponse(metaData.inferiors(), metaData.getSelectability(), this.mailboxName(isRelative, metaData.getPath(), metaData.getHierarchyDelimiter()), metaData.getHierarchyDelimiter(), mailboxType, isSubscribed.test(metaData.getPath())));
            }
        }).doOnNext(metaData -> this.respondMyRights(request, responder, mailboxSession, (MailboxMetaData)metaData)).concatMap(metaData -> (Publisher)request.getStatusDataItems().map(statusDataItems -> this.statusProcessor.sendStatus(this.retrieveMessageManager((MailboxMetaData)metaData, mailboxSession), (StatusDataItems)statusDataItems, responder, session, mailboxSession)).orElse(Mono.empty())).then();
    }

    private MessageManager retrieveMessageManager(MailboxMetaData metaData, MailboxSession mailboxSession) {
        try {
            return this.getMailboxManager().getMailbox(metaData.getMailbox(), mailboxSession);
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
    }

    private Mono<Void> processWithSubscribed(ImapSession session, T request, ImapProcessor.Responder responder, MailboxSession mailboxSession, boolean isRelative, MailboxQuery mailboxQuery) {
        return Mono.zip((Mono)this.getMailboxManager().search(mailboxQuery, MailboxManager.MailboxSearchFetchType.Minimal, mailboxSession).collectList().map(searchedResultList -> searchedResultList.stream().collect(Collectors.toMap(MailboxMetaData::getPath, Function.identity()))), (Mono)Flux.from((Publisher)((Publisher)Throwing.supplier(() -> this.subscriptionManager.subscriptionsReactive(mailboxSession)).get())).collectList()).map(tuple -> this.getListResponseForSelectSubscribed(session, (Map)tuple.getT1(), (List)tuple.getT2(), (ListRequest)request, mailboxSession, isRelative, mailboxQuery)).flatMapIterable(list -> list).doOnNext(pathAndResponse -> responder.respond((ImapResponseMessage)pathAndResponse.getMiddle())).doOnNext(pathAndResponse -> ((Optional)pathAndResponse.getRight()).ifPresent(mailboxMetaData -> this.respondMyRights(request, responder, mailboxSession, (MailboxMetaData)mailboxMetaData))).concatMap(pathAndResponse -> this.sendStatusWhenSubscribed(session, request, responder, mailboxSession, (Triple<MailboxPath, ListResponse, Optional<MailboxMetaData>>)pathAndResponse)).then();
    }

    private Mono<MailboxStatusResponse> sendStatusWhenSubscribed(ImapSession session, T request, ImapProcessor.Responder responder, MailboxSession mailboxSession, Triple<MailboxPath, ListResponse, Optional<MailboxMetaData>> pathAndResponse) {
        return ((Optional)pathAndResponse.getRight()).map(metaData -> this.retrieveMessageManager((MailboxMetaData)metaData, mailboxSession)).flatMap(messageManager -> request.getStatusDataItems().map(statusDataItems -> this.statusProcessor.sendStatus((MessageManager)messageManager, (StatusDataItems)statusDataItems, responder, session, mailboxSession))).orElse(Mono.empty());
    }

    private List<Triple<MailboxPath, ListResponse, Optional<MailboxMetaData>>> getListResponseForSelectSubscribed(ImapSession session, Map<MailboxPath, MailboxMetaData> searchedResultMap, List<MailboxPath> allSubscribedSearch, ListRequest listRequest, MailboxSession mailboxSession, boolean relative, MailboxQuery mailboxQuery) {
        ImmutableList.Builder responseBuilders = ImmutableList.builder();
        List<Pair<MailboxPath, ListResponse>> listRecursiveMatch = this.listRecursiveMatch(session, searchedResultMap, allSubscribedSearch, mailboxSession, relative, listRequest);
        listRecursiveMatch.forEach(pair -> responseBuilders.add((Object)Triple.of((Object)((MailboxPath)pair.getLeft()), (Object)((ListResponse)pair.getRight()), Optional.ofNullable((MailboxMetaData)searchedResultMap.get(pair.getLeft())))));
        Set listRecursiveMatchPath = listRecursiveMatch.stream().map(Pair::getKey).collect(Collectors.toUnmodifiableSet());
        allSubscribedSearch.stream().filter(subscribed -> !listRecursiveMatchPath.contains(subscribed)).filter(arg_0 -> ((MailboxQuery)mailboxQuery).isPathMatch(arg_0)).map(subscribed -> this.buildListResponse(listRequest, searchedResultMap, session, relative, (MailboxPath)subscribed)).filter(pair -> !listRequest.getSelectOptions().contains((Object)ListRequest.ListSelectOption.SPECIAL_USE) || this.mailboxTyper.getMailboxType(session, (MailboxPath)pair.getKey()).getRfc6154attributeName() != null).forEach(pair -> responseBuilders.add((Object)Triple.of((Object)((MailboxPath)pair.getLeft()), (Object)((ListResponse)pair.getRight()), Optional.ofNullable((MailboxMetaData)searchedResultMap.get(pair.getLeft())))));
        return responseBuilders.build();
    }

    private Pair<MailboxPath, ListResponse> buildListResponse(ListRequest listRequest, Map<MailboxPath, MailboxMetaData> searchedResultMap, ImapSession session, boolean relative, MailboxPath subscribed) {
        return Pair.of((Object)subscribed, (Object)Optional.ofNullable(searchedResultMap.get(subscribed)).map(mailboxMetaData -> ListResponse.builder().returnSubscribed(true).forMetaData((MailboxMetaData)mailboxMetaData).name(this.mailboxName(relative, subscribed, mailboxMetaData.getHierarchyDelimiter())).returnNonExistent(false).mailboxType(this.getMailboxType(listRequest, session, mailboxMetaData.getPath()))).orElseGet(() -> ListResponse.builder().nonExitingSubscribedMailbox(subscribed)).build());
    }

    private List<Pair<MailboxPath, ListResponse>> listRecursiveMatch(ImapSession session, Map<MailboxPath, MailboxMetaData> searchedResultMap, List<MailboxPath> allSubscribedSearch, MailboxSession mailboxSession, boolean relative, ListRequest listRequest) {
        if (!listRequest.getSelectOptions().contains((Object)ListRequest.ListSelectOption.RECURSIVEMATCH)) {
            return List.of();
        }
        Set allSubscribedSearchParent = allSubscribedSearch.stream().flatMap(mailboxPath -> mailboxPath.getParents(mailboxSession.getPathDelimiter()).stream()).collect(Collectors.toSet());
        return searchedResultMap.entrySet().stream().filter(pair -> allSubscribedSearchParent.contains(pair.getKey())).map(pair -> {
            MailboxMetaData metaData = (MailboxMetaData)pair.getValue();
            ListResponse listResponse = ListResponse.builder().forMetaData(metaData).name(this.mailboxName(relative, metaData.getPath(), metaData.getHierarchyDelimiter())).childInfos(ListResponse.ChildInfo.SUBSCRIBED).returnSubscribed(allSubscribedSearch.contains(pair.getKey())).mailboxType(this.getMailboxType(listRequest, session, metaData.getPath())).build();
            return Pair.of((Object)((MailboxPath)pair.getKey()), (Object)listResponse);
        }).collect(Collectors.toList());
    }

    private void respondMyRights(T request, ImapProcessor.Responder responder, MailboxSession mailboxSession, MailboxMetaData metaData) {
        if (((ListRequest)request).getReturnOptions().contains((Object)ListRequest.ListReturnOption.MYRIGHTS)) {
            MyRightsResponse myRightsResponse = new MyRightsResponse(metaData.getPath().getName(), this.getRfc4314Rights(mailboxSession, metaData));
            responder.respond(myRightsResponse);
        }
    }

    private MailboxACL.Rfc4314Rights getRfc4314Rights(MailboxSession mailboxSession, MailboxMetaData metaData) {
        if (metaData.getPath().belongsTo(mailboxSession)) {
            return MailboxACL.FULL_RIGHTS;
        }
        MailboxACL.EntryKey entryKey = MailboxACL.EntryKey.createUserEntryKey((Username)mailboxSession.getUser());
        return (MailboxACL.Rfc4314Rights)metaData.getResolvedAcls().getEntries().get(entryKey);
    }

    private MailboxQuery mailboxQuery(MailboxPath basePath, String mailboxName, MailboxSession mailboxSession) {
        if (basePath.getNamespace().equals("#private") && basePath.getUser().equals((Object)mailboxSession.getUser()) && basePath.getName().isEmpty() && mailboxName.equals("*")) {
            return MailboxQuery.builder().userAndNamespaceFrom(basePath).expression((MailboxNameExpression)Wildcard.INSTANCE).build();
        }
        return MailboxQuery.builder().userAndNamespaceFrom(basePath).expression((MailboxNameExpression)new PrefixedRegex(basePath.getName(), ModifiedUtf7.decodeModifiedUTF7(mailboxName), mailboxSession.getPathDelimiter())).build();
    }

    private MailboxPath computeBasePath(ImapSession session, String finalReferencename, boolean isRelative) {
        String decodedName = ModifiedUtf7.decodeModifiedUTF7(finalReferencename);
        if (isRelative) {
            return MailboxPath.forUser((Username)session.getUserName(), (String)decodedName);
        }
        return PathConverter.forSession(session).buildFullPath(decodedName);
    }

    protected MailboxType getMailboxType(ListRequest listRequest, ImapSession session, MailboxPath path) {
        if (listRequest.getReturnOptions().contains((Object)ListRequest.ListReturnOption.SPECIAL_USE)) {
            return this.mailboxTyper.getMailboxType(session, path);
        }
        return MailboxType.OTHER;
    }

    @Override
    protected MDCBuilder mdc(T request) {
        return MDCBuilder.create().addToContext("action", "LIST").addToContext("base", ((ListRequest)request).getBaseReferenceName()).addToContext("pattern", ((ListRequest)request).getMailboxPattern()).addToContext("returnOptions", ((ListRequest)request).getReturnOptions().toString()).addToContext("selectOptions", ((ListRequest)request).getSelectOptions().toString()).addToContextIfPresent("statusItems", ((ListRequest)request).getStatusDataItems().map(StatusDataItems::toString));
    }
}

