/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.imap.api.ImapConfiguration;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.IdleRequest;
import org.apache.james.imap.message.response.ContinuationResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class IdleProcessor
extends AbstractMailboxProcessor<IdleRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdleProcessor.class);
    private static final List<Capability> CAPS = ImmutableList.of((Object)ImapConstants.SUPPORTS_IDLE);
    private static final String DONE = "DONE";
    private Duration heartbeatInterval;
    private boolean enableIdle;

    @Inject
    public IdleProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(IdleRequest.class, mailboxManager, factory, metricFactory);
    }

    @Override
    public void configure(ImapConfiguration imapConfiguration) {
        super.configure(imapConfiguration);
        this.heartbeatInterval = imapConfiguration.idleTimeIntervalAsDuration();
        this.enableIdle = imapConfiguration.isEnableIdle();
    }

    @Override
    protected Mono<Void> processRequestReactive(IdleRequest request, final ImapSession session, final ImapProcessor.Responder responder) {
        SelectedMailbox sm = session.getSelected();
        if (sm != null) {
            sm.registerIdle(new IdleMailboxListener(session, responder));
        }
        final AtomicBoolean idleActive = new AtomicBoolean(true);
        session.pushLineHandler((session1, data) -> Mono.fromRunnable(() -> {
            String line = data.length > 2 ? new String(data, 0, data.length - 2) : "";
            if (sm != null) {
                sm.unregisterIdle();
            }
            if (!DONE.equals(line.toUpperCase(Locale.US))) {
                String message = String.format("Continuation for IMAP IDLE was not understood. Expected 'DONE', got '%s'.", line);
                StatusResponse response = this.getStatusResponseFactory().taggedBad(request.getTag(), request.getCommand(), new HumanReadableText("org.apache.james.imap.INVALID_CONTINUATION", "failed. " + message));
                LOGGER.info(message);
                responder.respond(response);
                responder.flush();
            } else {
                this.okComplete(request, responder);
                responder.flush();
            }
            session1.popLineHandler();
            idleActive.set(false);
        }));
        if (this.enableIdle) {
            session.schedule(new Runnable(){

                @Override
                public void run() {
                    if (session.getState() != ImapSessionState.LOGOUT && idleActive.get()) {
                        StatusResponse response = IdleProcessor.this.getStatusResponseFactory().untaggedOk(HumanReadableText.HEARTBEAT);
                        responder.respond(response);
                        session.schedule(this, IdleProcessor.this.heartbeatInterval);
                    }
                }
            }, this.heartbeatInterval);
        }
        responder.respond(new ContinuationResponse(HumanReadableText.IDLING));
        return this.unsolicitedResponses(session, responder, false);
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }

    @Override
    protected MDCBuilder mdc(IdleRequest message) {
        return MDCBuilder.create().addToContext("action", "IDLE");
    }

    private class IdleMailboxListener
    implements EventListener.ReactiveEventListener {
        private final ImapProcessor.Responder responder;
        private final ImapSession session;

        public IdleMailboxListener(ImapSession session, ImapProcessor.Responder responder) {
            this.session = session;
            this.responder = responder;
        }

        public boolean isHandling(Event event) {
            return event instanceof MailboxEvents.Added || event instanceof MailboxEvents.Expunged || event instanceof MailboxEvents.FlagsUpdated;
        }

        public Publisher<Void> reactiveEvent(Event event) {
            return IdleProcessor.this.unsolicitedResponses(this.session, this.responder, false).then(Mono.fromRunnable(this.responder::flush));
        }

        public EventListener.ExecutionMode getExecutionMode() {
            return EventListener.ExecutionMode.ASYNCHRONOUS;
        }
    }
}

