/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import org.apache.james.core.Username;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.ExpungeRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.EnableProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.AuditTrail;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ExpungeProcessor
extends AbstractMailboxProcessor<ExpungeRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpungeProcessor.class);
    private static final List<Capability> UIDPLUS = ImmutableList.of((Object)ImapConstants.SUPPORTS_UIDPLUS);

    @Inject
    public ExpungeProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(ExpungeRequest.class, mailboxManager, factory, metricFactory);
    }

    @Override
    protected Mono<Void> processRequestReactive(ExpungeRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxSession mailboxSession = session.getMailboxSession();
        return this.getSelectedMailboxReactive(session).flatMap((Function)Throwing.function(mailbox -> {
            if (!this.getMailboxManager().hasRight(mailbox.getMailboxEntity(), MailboxACL.Right.PerformExpunge, mailboxSession)) {
                this.no(request, responder, HumanReadableText.MAILBOX_IS_READ_ONLY);
                return Mono.empty();
            }
            return this.expunge(request, session, (MessageManager)mailbox, mailboxSession).flatMap(expunged -> this.unsolicitedResponses(session, responder, false).thenReturn(expunged)).flatMap((Function)Throwing.function(expunged -> this.respondOk(request, session, responder, (MessageManager)mailbox, mailboxSession, (int)expunged)));
        })).onErrorResume(MessageRangeException.class, e -> {
            this.taggedBad(request, responder, HumanReadableText.INVALID_MESSAGESET);
            return ReactorUtils.logAsMono(() -> LOGGER.debug("Expunge failed", (Throwable)e));
        }).onErrorResume(MailboxException.class, e -> {
            this.no(request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
            return ReactorUtils.logAsMono(() -> LOGGER.error("Expunge failed for mailbox {}", (Object)session.getSelected().getMailboxId(), e));
        });
    }

    private Mono<Integer> expunge(ExpungeRequest request, ImapSession session, MessageManager mailbox, MailboxSession mailboxSession) {
        Object[] ranges = request.getUidSet();
        if (ranges == null) {
            return this.expunge(mailbox, MessageRange.all(), session, mailboxSession);
        }
        return Flux.fromIterable((Iterable)ImmutableList.copyOf((Object[])ranges)).map(Throwing.function(range -> this.messageRange(session.getSelected(), (IdRange)range, true).orElseThrow(() -> new MessageRangeException(range.getFormattedString() + " is an invalid range"))).sneakyThrow()).concatMap(range -> this.expunge(mailbox, (MessageRange)range, session, mailboxSession)).reduce(Integer::sum);
    }

    private Mono<Void> respondOk(ExpungeRequest request, ImapSession session, ImapProcessor.Responder responder, MessageManager mailbox, MailboxSession mailboxSession, int expunged) throws MailboxException {
        if (EnableProcessor.getEnabledCapabilities(session).contains(ImapConstants.SUPPORTS_QRESYNC) && expunged > 0) {
            return mailbox.getMetaDataReactive(MessageManager.MailboxMetaData.RecentMode.IGNORE, mailboxSession, EnumSet.of(MessageManager.MailboxMetaData.Item.HighestModSeq)).doOnNext(metaData -> this.okComplete(request, StatusResponse.ResponseCode.highestModSeq(metaData.getHighestModSeq()), responder)).then();
        }
        return Mono.fromRunnable(() -> this.okComplete(request, responder));
    }

    private Mono<Integer> expunge(MessageManager mailbox, MessageRange range, ImapSession session, MailboxSession mailboxSession) {
        SelectedMailbox selected = session.getSelected();
        return mailbox.expungeReactive(range, mailboxSession).doOnNext(selected::removeRecent).count().map(Long::intValue).doOnSuccess(count -> AuditTrail.entry().username(() -> mailboxSession.getUser().asString()).sessionId(() -> session.sessionId().asString()).protocol("IMAP").action("EXPUNGE").parameters(() -> ImmutableMap.of((Object)"loggedInUser", (Object)mailboxSession.getLoggedInUser().map(Username::asString).orElse(""), (Object)"mailboxId", (Object)mailbox.getId().serialize(), (Object)"messageUids", (Object)range.toString())).log(String.format("IMAP EXPUNGE succeeded. %d message deleted.", count)));
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return UIDPLUS;
    }

    @Override
    protected MDCBuilder mdc(ExpungeRequest request) {
        return MDCBuilder.create().addToContext("action", "EXPUNGE").addToContext("uidSet", IdRange.toString(request.getUidSet()));
    }
}

