/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.request.IDRequest;

public class IDCommandParser
extends AbstractImapCommandParser {
    @Inject
    public IDCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapConstants.ID_COMMAND, statusResponseFactory);
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, ImapSession session) throws DecodingException {
        String s;
        char c = request.nextWordChar();
        if (c != '(' && (s = request.consumeWord(ImapRequestLineReader.NoopCharValidator.INSTANCE)).equalsIgnoreCase("NIL")) {
            request.eol();
            return new IDRequest(tag, Optional.empty());
        }
        request.consumeChar('(');
        ImmutableMap.Builder parameters = ImmutableMap.builder();
        boolean first = true;
        while (c != ')') {
            if (first) {
                first = false;
            } else if (request.nextWordChar() == ',') {
                request.consumeChar(',');
            }
            request.nextWordChar();
            String field = request.consumeQuoted();
            if (request.nextWordChar() == ',') {
                request.consumeChar(',');
            }
            request.nextWordChar();
            String value = request.consumeQuoted();
            parameters.put((Object)field, (Object)value);
            c = request.nextWordChar();
        }
        request.consumeChar(')');
        request.eol();
        return new IDRequest(tag, Optional.of(parameters.build()));
    }
}

