/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import org.apache.james.DefaultVacationService;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.apache.james.vacation.api.NotificationRegistry;
import org.apache.james.vacation.api.VacationDeleteUserTaskStep;
import org.apache.james.vacation.api.VacationRepository;
import org.apache.james.vacation.api.VacationService;
import org.apache.james.vacation.cassandra.CassandraNotificationRegistry;
import org.apache.james.vacation.cassandra.CassandraNotificationRegistryModule;
import org.apache.james.vacation.cassandra.CassandraVacationRepository;

public class CassandraVacationModule
extends AbstractModule {
    public void configure() {
        this.bind(DefaultVacationService.class).in(Scopes.SINGLETON);
        this.bind(VacationService.class).to(DefaultVacationService.class);
        this.bind(CassandraVacationRepository.class).in(Scopes.SINGLETON);
        this.bind(VacationRepository.class).to(CassandraVacationRepository.class);
        this.bind(CassandraNotificationRegistry.class).in(Scopes.SINGLETON);
        this.bind(NotificationRegistry.class).to(CassandraNotificationRegistry.class);
        Multibinder cassandraVacationDefinitions = Multibinder.newSetBinder((Binder)this.binder(), CassandraModule.class);
        cassandraVacationDefinitions.addBinding().toInstance((Object)org.apache.james.vacation.cassandra.CassandraVacationModule.MODULE);
        cassandraVacationDefinitions.addBinding().toInstance((Object)CassandraNotificationRegistryModule.MODULE);
        Multibinder deleteUserDataTaskSteps = Multibinder.newSetBinder((Binder)this.binder(), DeleteUserDataTaskStep.class);
        deleteUserDataTaskSteps.addBinding().to(VacationDeleteUserTaskStep.class);
    }
}

