/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.cluster.PutClusterSettingsResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class PutClusterSettingsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean flatSettings;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Time clusterManagerTimeout;
    private final Map<String, JsonData> persistent;
    @Nullable
    private final Time timeout;
    private final Map<String, JsonData> transient_;
    public static final JsonpDeserializer<PutClusterSettingsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutClusterSettingsRequest::setupPutClusterSettingsRequestDeserializer);
    public static final Endpoint<PutClusterSettingsRequest, PutClusterSettingsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutClusterSettingsRequest, PutClusterSettingsResponse>(request -> "PUT", request -> "/_cluster/settings", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", request.clusterManagerTimeout._toJsonString());
        }
        if (request.flatSettings != null) {
            params.put("flat_settings", String.valueOf(request.flatSettings));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutClusterSettingsResponse._DESERIALIZER);

    private PutClusterSettingsRequest(Builder builder) {
        this.flatSettings = builder.flatSettings;
        this.masterTimeout = builder.masterTimeout;
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.persistent = ApiTypeHelper.unmodifiable(builder.persistent);
        this.timeout = builder.timeout;
        this.transient_ = ApiTypeHelper.unmodifiable(builder.transient_);
    }

    public static PutClusterSettingsRequest of(Function<Builder, ObjectBuilder<PutClusterSettingsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean flatSettings() {
        return this.flatSettings;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    public final Map<String, JsonData> persistent() {
        return this.persistent;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public final Map<String, JsonData> transient_() {
        return this.transient_;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.persistent)) {
            generator.writeKey("persistent");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.persistent.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.transient_)) {
            generator.writeKey("transient");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.transient_.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutClusterSettingsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::persistent, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "persistent");
        op.add(Builder::transient_, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "transient");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<PutClusterSettingsRequest> {
        @Nullable
        private Boolean flatSettings;
        @Deprecated
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private Map<String, JsonData> persistent;
        @Nullable
        private Time timeout;
        @Nullable
        private Map<String, JsonData> transient_;

        public final Builder flatSettings(@Nullable Boolean value) {
            this.flatSettings = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder persistent(Map<String, JsonData> map) {
            this.persistent = Builder._mapPutAll(this.persistent, map);
            return this;
        }

        public final Builder persistent(String key, JsonData value) {
            this.persistent = Builder._mapPut(this.persistent, key, value);
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder transient_(Map<String, JsonData> map) {
            this.transient_ = Builder._mapPutAll(this.transient_, map);
            return this;
        }

        public final Builder transient_(String key, JsonData value) {
            this.transient_ = Builder._mapPut(this.transient_, key, value);
            return this;
        }

        @Override
        public PutClusterSettingsRequest build() {
            this._checkSingleUse();
            return new PutClusterSettingsRequest(this);
        }
    }
}

