/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.CharFilterBase;
import org.opensearch.client.opensearch._types.analysis.CharFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.CharFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class MappingCharFilter
extends CharFilterBase
implements CharFilterDefinitionVariant {
    private final List<String> mappings;
    @Nullable
    private final String mappingsPath;
    public static final JsonpDeserializer<MappingCharFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MappingCharFilter::setupMappingCharFilterDeserializer);

    private MappingCharFilter(Builder builder) {
        super(builder);
        this.mappings = ApiTypeHelper.unmodifiableRequired(builder.mappings, (Object)this, "mappings");
        this.mappingsPath = builder.mappingsPath;
    }

    public static MappingCharFilter of(Function<Builder, ObjectBuilder<MappingCharFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public CharFilterDefinition.Kind _charFilterDefinitionKind() {
        return CharFilterDefinition.Kind.Mapping;
    }

    public final List<String> mappings() {
        return this.mappings;
    }

    @Nullable
    public final String mappingsPath() {
        return this.mappingsPath;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "mapping");
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.mappings)) {
            generator.writeKey("mappings");
            generator.writeStartArray();
            for (String item0 : this.mappings) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.mappingsPath != null) {
            generator.writeKey("mappings_path");
            generator.write(this.mappingsPath);
        }
    }

    protected static void setupMappingCharFilterDeserializer(ObjectDeserializer<Builder> op) {
        MappingCharFilter.setupCharFilterBaseDeserializer(op);
        op.add(Builder::mappings, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "mappings");
        op.add(Builder::mappingsPath, JsonpDeserializer.stringDeserializer(), "mappings_path");
        op.ignore("type");
    }

    public static class Builder
    extends CharFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MappingCharFilter> {
        private List<String> mappings;
        @Nullable
        private String mappingsPath;

        public final Builder mappings(List<String> list) {
            this.mappings = Builder._listAddAll(this.mappings, list);
            return this;
        }

        public final Builder mappings(String value, String ... values) {
            this.mappings = Builder._listAdd(this.mappings, value, values);
            return this;
        }

        public final Builder mappingsPath(@Nullable String value) {
            this.mappingsPath = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MappingCharFilter build() {
            this._checkSingleUse();
            return new MappingCharFilter(this);
        }
    }
}

