/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.opensearch.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.fge.lambdas.Throwing;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.extractor.ParsedContent;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mailbox.opensearch.json.HeaderCollection;
import org.apache.james.mailbox.opensearch.json.MimePartContainerBuilder;
import org.apache.james.mime4j.stream.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MimePart {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimePart.class);
    private final HeaderCollection headerCollection;
    private final Optional<String> bodyTextContent;
    private final Optional<ContentType.MediaType> mediaType;
    private final Optional<ContentType.SubType> subType;
    private final Optional<String> fileName;
    private final Optional<String> fileExtension;
    private final Optional<String> contentDisposition;
    private final List<MimePart> attachments;

    public static Builder builder(Predicate<ContentType> shouldCaryOverContent) {
        return new Builder(shouldCaryOverContent);
    }

    private MimePart(HeaderCollection headerCollection, Optional<String> bodyTextContent, Optional<ContentType.MediaType> mediaType, Optional<ContentType.SubType> subType, Optional<String> fileName, Optional<String> fileExtension, Optional<String> contentDisposition, List<MimePart> attachments) {
        this.headerCollection = headerCollection;
        this.mediaType = mediaType;
        this.subType = subType;
        this.fileName = fileName;
        this.fileExtension = fileExtension;
        this.contentDisposition = contentDisposition;
        this.attachments = attachments;
        this.bodyTextContent = bodyTextContent;
    }

    @JsonIgnore
    public List<MimePart> getAttachments() {
        return this.attachments;
    }

    @JsonIgnore
    public HeaderCollection getHeaderCollection() {
        return this.headerCollection;
    }

    @JsonProperty(value="fileName")
    public Optional<String> getFileName() {
        return this.fileName;
    }

    @JsonProperty(value="fileExtension")
    public Optional<String> getFileExtension() {
        return this.fileExtension;
    }

    @JsonProperty(value="mediaType")
    public Optional<String> getMediaType() {
        return this.mediaType.map(ContentType.MediaType::asString);
    }

    @JsonProperty(value="subtype")
    public Optional<String> getSubType() {
        return this.subType.map(ContentType.SubType::asString);
    }

    @JsonProperty(value="contentDisposition")
    public Optional<String> getContentDisposition() {
        return this.contentDisposition;
    }

    @JsonProperty(value="textContent")
    public Optional<String> getTextualBody() {
        return this.bodyTextContent;
    }

    @JsonIgnore
    public Optional<String> locateFirstTextBody() {
        return this.firstBody(this.textAttachments().filter(this::isPlainSubType));
    }

    @JsonIgnore
    public Optional<String> locateFirstHtmlBody() {
        if (this.locateFirstTextBody().isEmpty()) {
            return this.firstBody(this.textAttachments().filter(this::isHtmlSubType));
        }
        return Optional.empty();
    }

    private Optional<String> firstBody(Stream<MimePart> mimeParts) {
        return mimeParts.map(mimePart -> mimePart.bodyTextContent).flatMap(Optional::stream).findFirst();
    }

    private Stream<MimePart> textAttachments() {
        return this.allAttachments().filter(this::isTextMediaType);
    }

    private Stream<MimePart> allAttachments() {
        return Stream.concat(Stream.of(this), this.attachments.stream().flatMap(MimePart::allAttachments));
    }

    private boolean isTextMediaType(MimePart mimePart) {
        return mimePart.getMediaType().filter("text"::equals).isPresent();
    }

    private boolean isPlainSubType(MimePart mimePart) {
        return mimePart.getSubType().filter("plain"::equals).isPresent();
    }

    private boolean isHtmlSubType(MimePart mimePart) {
        return mimePart.getSubType().filter("html"::equals).isPresent();
    }

    @JsonIgnore
    public Stream<MimePart> getAttachmentsStream() {
        return this.attachments.stream().flatMap(mimePart -> Stream.concat(Stream.of(mimePart), mimePart.getAttachmentsStream())).filter(mimePart -> mimePart.contentDisposition.isPresent());
    }

    public static class Builder
    implements MimePartContainerBuilder {
        private final HeaderCollection.Builder headerCollectionBuilder;
        private Optional<InputStream> bodyContent;
        private final List<ParsedMimePart> children;
        private Optional<ContentType.MediaType> mediaType;
        private Optional<ContentType.SubType> subType;
        private Optional<String> fileName;
        private Optional<String> fileExtension;
        private Optional<String> contentDisposition;
        private Optional<Charset> charset;
        private Predicate<ContentType> shouldCaryOverContent;

        private Builder(Predicate<ContentType> shouldCaryOverContent) {
            this.shouldCaryOverContent = shouldCaryOverContent;
            this.children = Lists.newArrayList();
            this.headerCollectionBuilder = HeaderCollection.builder();
            this.bodyContent = Optional.empty();
            this.mediaType = Optional.empty();
            this.subType = Optional.empty();
            this.fileName = Optional.empty();
            this.fileExtension = Optional.empty();
            this.contentDisposition = Optional.empty();
            this.charset = Optional.empty();
        }

        @Override
        public Builder addToHeaders(Field field) {
            this.headerCollectionBuilder.add(field);
            return this;
        }

        @Override
        public Builder addBodyContent(InputStream bodyContent) {
            this.bodyContent = Optional.of(bodyContent);
            return this;
        }

        @Override
        public Builder addChild(ParsedMimePart mimePart) {
            this.children.add(mimePart);
            return this;
        }

        @Override
        public Builder addFileName(String fileName) {
            this.fileName = Optional.ofNullable(fileName);
            this.fileExtension = this.fileName.map(FilenameUtils::getExtension);
            return this;
        }

        @Override
        public Builder addMediaType(ContentType.MediaType mediaType) {
            this.mediaType = Optional.ofNullable(mediaType);
            return this;
        }

        @Override
        public Builder addSubType(ContentType.SubType subType) {
            this.subType = Optional.of(subType);
            return this;
        }

        @Override
        public Builder addContentDisposition(String contentDisposition) {
            this.contentDisposition = Optional.ofNullable(contentDisposition);
            return this;
        }

        @Override
        public MimePartContainerBuilder charset(Charset charset) {
            this.charset = Optional.of(charset);
            return this;
        }

        private Optional<ContentType> computeContentType() {
            if (this.mediaType.isPresent() && this.subType.isPresent()) {
                return Optional.of(ContentType.of((ContentType.MimeType)ContentType.MimeType.of((ContentType.MediaType)this.mediaType.get(), (ContentType.SubType)this.subType.get()), this.charset));
            }
            return Optional.empty();
        }

        @Override
        public ParsedMimePart build() {
            Optional<ContentType> contentType = this.computeContentType();
            return new ParsedMimePart(this.headerCollectionBuilder.build(), this.bodyContent.filter(any -> this.shouldCaryOverContent.test(contentType.orElse(null))), this.charset, this.mediaType, this.subType, contentType, this.fileName, this.fileExtension, this.contentDisposition, this.children);
        }
    }

    public static class ParsedMimePart {
        private final HeaderCollection headerCollection;
        private final Optional<byte[]> bodyContent;
        private final Optional<Charset> charset;
        private final Optional<ContentType.MediaType> mediaType;
        private final Optional<ContentType.SubType> subType;
        private Optional<ContentType> contentType;
        private final Optional<String> fileName;
        private final Optional<String> fileExtension;
        private final Optional<String> contentDisposition;
        private final List<ParsedMimePart> attachments;

        public ParsedMimePart(HeaderCollection headerCollection, Optional<InputStream> bodyContent, Optional<Charset> charset, Optional<ContentType.MediaType> mediaType, Optional<ContentType.SubType> subType, Optional<ContentType> contentType, Optional<String> fileName, Optional<String> fileExtension, Optional<String> contentDisposition, List<ParsedMimePart> attachments) {
            this.headerCollection = headerCollection;
            this.mediaType = mediaType;
            this.subType = subType;
            this.contentType = contentType;
            this.fileName = fileName;
            this.fileExtension = fileExtension;
            this.contentDisposition = contentDisposition;
            this.attachments = attachments;
            this.charset = charset;
            this.bodyContent = bodyContent.map(Throwing.function(IOUtils::toByteArray));
        }

        public Mono<MimePart> asMimePart(TextExtractor textExtractor) {
            return Flux.fromIterable(this.attachments).concatMap(attachment -> attachment.asMimePart(textExtractor)).collectList().flatMap(attachments -> this.extractText(textExtractor).map(Optional::ofNullable).switchIfEmpty(Mono.just(Optional.empty())).onErrorResume(e -> {
                LOGGER.warn("Failure extracting text message for some attachments", e);
                return Mono.just(Optional.empty());
            }).map(text -> new MimePart(this.headerCollection, text.flatMap(ParsedContent::getTextualContent), this.mediaType, this.subType, this.fileName, this.fileExtension, this.contentDisposition, (List<MimePart>)attachments)));
        }

        private Mono<ParsedContent> extractText(TextExtractor textExtractor) {
            return Mono.justOrEmpty(this.bodyContent).flatMap(content -> {
                if (this.shouldPerformTextExtraction()) {
                    return textExtractor.extractContentReactive((InputStream)new ByteArrayInputStream((byte[])content), (ContentType)this.contentType.orElse(null));
                }
                return Mono.fromCallable(() -> ParsedContent.of((String)new String((byte[])content, this.charset.orElse(StandardCharsets.UTF_8))));
            });
        }

        private boolean shouldPerformTextExtraction() {
            return this.isTextBody() == false || this.isHtml() != false;
        }

        private Boolean isTextBody() {
            return this.mediaType.map(arg_0 -> ((ContentType.MediaType)ContentType.MediaType.of((String)"text")).equals(arg_0)).orElse(false);
        }

        /*
         * Enabled aggressive block sorting
         */
        private Boolean isHtml() {
            boolean bl;
            if (this.isTextBody().booleanValue()) {
                if (this.subType.map(arg_0 -> ((ContentType.SubType)ContentType.SubType.of((String)"html")).equals(arg_0)).orElse(false).booleanValue()) {
                    bl = true;
                    return bl;
                }
            }
            bl = false;
            return bl;
        }
    }
}

