/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.opensearch.events;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.mail.Flags;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.james.backends.opensearch.DocumentId;
import org.apache.james.backends.opensearch.OpenSearchIndexer;
import org.apache.james.backends.opensearch.RoutingKey;
import org.apache.james.backends.opensearch.UpdatedRepresentation;
import org.apache.james.events.Event;
import org.apache.james.events.Group;
import org.apache.james.mailbox.FlagsBuilder;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.opensearch.IndexBody;
import org.apache.james.mailbox.opensearch.OpenSearchMailboxConfiguration;
import org.apache.james.mailbox.opensearch.json.MessageToOpenSearchJson;
import org.apache.james.mailbox.opensearch.search.OpenSearchSearcher;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.TermQuery;
import org.opensearch.client.opensearch.core.get.GetResult;
import org.opensearch.client.opensearch.core.search.Hit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scheduler.Schedulers;

public class OpenSearchListeningMessageSearchIndex
extends ListeningMessageSearchIndex {
    private static final int FLAGS_UPDATE_PROCESSING_WINDOW_SIZE = 32;
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSearchListeningMessageSearchIndex.class);
    private static final String ID_SEPARATOR = ":";
    private static final Group GROUP = new OpenSearchListeningMessageSearchIndexGroup();
    private static final ImmutableList<String> MESSAGE_ID_FIELD = ImmutableList.of((Object)"messageId");
    private static final ImmutableList<String> UID_FIELD = ImmutableList.of((Object)"uid");
    private final OpenSearchIndexer openSearchIndexer;
    private final OpenSearchSearcher searcher;
    private final MessageToOpenSearchJson messageToOpenSearchJson;
    private final RoutingKey.Factory<MailboxId> routingKeyFactory;
    private final MessageId.Factory messageIdFactory;
    private final SessionProvider sessionProvider;
    private final MailboxSessionMapperFactory factory;
    private final Metric reIndexNotFoundMetric;
    private final IndexingStrategy indexingStrategy;
    private final IndexBody indexBody;

    @Inject
    public OpenSearchListeningMessageSearchIndex(MailboxSessionMapperFactory factory, Set<ListeningMessageSearchIndex.SearchOverride> searchOverrides, @Named(value="mailbox") OpenSearchIndexer indexer, OpenSearchSearcher searcher, MessageToOpenSearchJson messageToOpenSearchJson, SessionProvider sessionProvider, RoutingKey.Factory<MailboxId> routingKeyFactory, MessageId.Factory messageIdFactory, OpenSearchMailboxConfiguration configuration, MetricFactory metricFactory) {
        super(factory, searchOverrides, sessionProvider);
        this.sessionProvider = sessionProvider;
        this.factory = factory;
        this.openSearchIndexer = indexer;
        this.messageToOpenSearchJson = messageToOpenSearchJson;
        this.searcher = searcher;
        this.routingKeyFactory = routingKeyFactory;
        this.messageIdFactory = messageIdFactory;
        this.indexingStrategy = configuration.isOptimiseMoves() ? new OptimizedIndexingStrategy() : new NaiveIndexingStrategy();
        this.indexBody = configuration.getIndexBody();
        this.reIndexNotFoundMetric = metricFactory.generate("opensearch_reindex_not_found");
        LOGGER.info("OpenSearchMessageSearchIndex activated with index strategy: {}", (Object)this.indexingStrategy.getClass().getSimpleName());
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public EnumSet<MailboxManager.SearchCapabilities> getSupportedCapabilities(EnumSet<MailboxManager.MessageCapabilities> messageCapabilities) {
        return EnumSet.of(MailboxManager.SearchCapabilities.MultimailboxSearch, new MailboxManager.SearchCapabilities[]{MailboxManager.SearchCapabilities.Text, MailboxManager.SearchCapabilities.FullText, MailboxManager.SearchCapabilities.Attachment, MailboxManager.SearchCapabilities.AttachmentFileName, MailboxManager.SearchCapabilities.PartialEmailMatch});
    }

    public void postReindexing() {
    }

    public Mono<Void> reactiveEvent(Event event) {
        MailboxSession systemSession = this.sessionProvider.createSystemSession(event.getUsername());
        return this.handleMailboxEvent(event, systemSession, (MailboxEvents.MailboxEvent)event).then(Mono.fromRunnable(() -> this.factory.endProcessingRequest(systemSession)));
    }

    private Mono<Void> handleMailboxEvent(Event event, MailboxSession session, MailboxEvents.MailboxEvent mailboxEvent) {
        MailboxId mailboxId = mailboxEvent.getMailboxId();
        if (event instanceof MailboxEvents.Added) {
            return this.indexingStrategy.handleAddedEvent(session, (MailboxEvents.Added)event, mailboxId);
        }
        if (event instanceof MailboxEvents.Expunged) {
            return this.indexingStrategy.handleExpungedEvent((MailboxEvents.Expunged)event, session, mailboxId);
        }
        if (event instanceof MailboxEvents.FlagsUpdated) {
            MailboxEvents.FlagsUpdated flagsUpdated = (MailboxEvents.FlagsUpdated)event;
            return this.update(session, mailboxId, flagsUpdated.getUpdatedFlags());
        }
        if (event instanceof MailboxEvents.MailboxDeletion) {
            return this.deleteAll(session, mailboxId);
        }
        return Mono.empty();
    }

    private Mono<Void> processAddedEvent(MailboxSession session, MailboxEvents.Added addedEvent, MailboxId mailboxId) {
        return this.factory.getMailboxMapper(session).findMailboxById(mailboxId).flatMap(mailbox -> this.handleAdded(session, (Mailbox)mailbox, addedEvent, this.chooseFetchType())).onErrorResume(MailboxNotFoundException.class, e -> {
            LOGGER.info("Added event skipped for deleted mailbox {}", (Object)mailboxId.serialize());
            return Mono.empty();
        });
    }

    private MessageMapper.FetchType chooseFetchType() {
        if (this.indexBody == IndexBody.YES) {
            return MessageMapper.FetchType.FULL;
        }
        return MessageMapper.FetchType.HEADERS;
    }

    protected Flux<MessageUid> doSearch(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"'session' is mandatory");
        Optional<Integer> noLimit = Optional.empty();
        return this.searcher.search((Collection<MailboxId>)ImmutableList.of((Object)mailbox.getMailboxId()), searchQuery, noLimit, (List<String>)UID_FIELD).handle(this::extractUidFromHit);
    }

    public Flux<MessageId> search(MailboxSession session, Collection<MailboxId> mailboxIds, SearchQuery searchQuery, long limit) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"'session' is mandatory");
        if (mailboxIds.isEmpty()) {
            return Flux.empty();
        }
        return this.searcher.search(mailboxIds, searchQuery, Optional.empty(), (List<String>)MESSAGE_ID_FIELD).handle(this::extractMessageIdFromHit).distinct().take(limit);
    }

    public Mono<Void> add(MailboxSession session, Mailbox mailbox, MailboxMessage message) {
        LOGGER.info("Indexing mailbox {}-{} of user {} on message {}", new Object[]{mailbox.getName(), mailbox.getMailboxId().serialize(), session.getUser().asString(), message.getUid().asLong()});
        return this.generateIndexedJson(mailbox, message, session).flatMap(jsonContent -> this.add(mailbox.getMailboxId(), message.getUid(), (String)jsonContent));
    }

    private Mono<Void> add(MailboxId mailboxId, MessageUid messageUid, String jsonContent) {
        RoutingKey from = this.routingKeyFactory.from((Object)mailboxId);
        DocumentId id = this.indexIdFor(mailboxId, messageUid);
        return this.openSearchIndexer.index(id, jsonContent, from).then();
    }

    private Mono<String> generateIndexedJson(Mailbox mailbox, MailboxMessage message, MailboxSession session) {
        return this.messageToOpenSearchJson.convertToJson(message, session).onErrorResume(e -> {
            LOGGER.warn("Indexing mailbox {}-{} of user {} on message {} without attachments ", new Object[]{mailbox.getName(), mailbox.getMailboxId().serialize(), session.getUser().asString(), message.getUid(), e});
            return this.messageToOpenSearchJson.convertToJsonWithoutAttachment(message, session);
        });
    }

    public Mono<Void> delete(MailboxSession session, MailboxId mailboxId, Collection<MessageUid> expungedUids) {
        return this.openSearchIndexer.delete((List)expungedUids.stream().map(uid -> this.indexIdFor(mailboxId, (MessageUid)uid)).collect(ImmutableList.toImmutableList()), this.routingKeyFactory.from((Object)mailboxId)).then();
    }

    public Mono<Void> deleteAll(MailboxSession session, MailboxId mailboxId) {
        Query query = TermQuery.of(t -> t.field("mailboxId").value((FieldValue)new FieldValue.Builder().stringValue(mailboxId.serialize()).build())).toQuery();
        return this.openSearchIndexer.deleteAllMatchingQuery(query, this.routingKeyFactory.from((Object)mailboxId));
    }

    public Mono<Void> update(MailboxSession session, MailboxId mailboxId, List<UpdatedFlags> updatedFlagsList) {
        RoutingKey routingKey = this.routingKeyFactory.from((Object)mailboxId);
        return Flux.fromIterable(updatedFlagsList).map(Throwing.function(updatedFlags -> this.createUpdatedDocumentPartFromUpdatedFlags(mailboxId, (UpdatedFlags)updatedFlags)).sneakyThrow()).window(32).concatMap(flux -> flux.collect(ImmutableList.toImmutableList()).flatMap(updates -> this.openSearchIndexer.update((List)updates, routingKey))).then();
    }

    private UpdatedRepresentation createUpdatedDocumentPartFromUpdatedFlags(MailboxId mailboxId, UpdatedFlags updatedFlags) throws JsonProcessingException {
        return new UpdatedRepresentation(this.indexIdFor(mailboxId, updatedFlags.getUid()), this.messageToOpenSearchJson.getUpdatedJsonMessagePart(updatedFlags.getNewFlags(), updatedFlags.getModSeq()));
    }

    private DocumentId indexIdFor(MailboxId mailboxId, MessageUid uid) {
        return DocumentId.fromString((String)(mailboxId.serialize() + ID_SEPARATOR + uid.asLong()));
    }

    public Mono<Flags> retrieveIndexedFlags(Mailbox mailbox, MessageUid uid) {
        RoutingKey routingKey = this.routingKeyFactory.from((Object)mailbox.getMailboxId());
        return this.openSearchIndexer.get(this.indexIdFor(mailbox.getMailboxId(), uid), routingKey).filter(GetResult::found).mapNotNull(GetResult::source).map(this::extractFlags);
    }

    private Flags extractFlags(ObjectNode source) {
        FlagsBuilder flagsBuilder = FlagsBuilder.builder().isAnswered(this.extractFlag(source, "isAnswered")).isDeleted(this.extractFlag(source, "isDeleted")).isDraft(this.extractFlag(source, "isDraft")).isFlagged(this.extractFlag(source, "isFlagged")).isRecent(this.extractFlag(source, "isRecent")).isSeen(!this.extractFlag(source, "isUnread"));
        for (JsonNode userFlag : this.extractUserFlags(source)) {
            flagsBuilder.add(new String[]{userFlag.textValue()});
        }
        return flagsBuilder.build();
    }

    private boolean extractFlag(ObjectNode source, String flag) {
        return source.get(flag).asBoolean();
    }

    private ArrayNode extractUserFlags(ObjectNode source) {
        return source.withArray("userFlags");
    }

    private void extractMessageIdFromHit(Hit<ObjectNode> hit, SynchronousSink<MessageId> sink) {
        JsonData messageId = (JsonData)hit.fields().get("messageId");
        if (messageId != null) {
            String messageIdAsString = messageId.toJson().asJsonArray().getString(0);
            sink.next((Object)this.messageIdFactory.fromString(messageIdAsString));
        } else {
            LOGGER.warn("Can not extract UID, MessageID and/or MailboxId for search result {}", (Object)hit.id());
        }
    }

    private void extractUidFromHit(Hit<ObjectNode> hit, SynchronousSink<MessageUid> sink) {
        JsonData uid = (JsonData)hit.fields().get("uid");
        if (uid != null) {
            int uidAsInt = uid.toJson().asJsonArray().getInt(0);
            sink.next((Object)MessageUid.of((long)uidAsInt));
        } else {
            LOGGER.warn("Can not extract UID, MessageID and/or MailboxId for search result {}", (Object)hit.id());
        }
    }

    class OptimizedIndexingStrategy
    implements IndexingStrategy {
        OptimizedIndexingStrategy() {
        }

        @Override
        public Mono<Void> handleExpungedEvent(MailboxEvents.Expunged expunged, MailboxSession session, MailboxId mailboxId) {
            return Mono.just((Object)expunged).filter(MailboxEvents.Expunged::isMoved).flatMap(expungedEvent -> this.processExpunged(session, mailboxId, (MailboxEvents.Expunged)expungedEvent).thenReturn((Object)expunged)).switchIfEmpty(Mono.defer(() -> OpenSearchListeningMessageSearchIndex.this.delete(session, mailboxId, expunged.getUids())).thenReturn((Object)expunged)).then();
        }

        @Override
        public Mono<Void> handleAddedEvent(MailboxSession session, MailboxEvents.Added addedEvent, MailboxId mailboxId) {
            return Mono.just((Object)addedEvent).filter(event -> !event.isMoved()).flatMap(added -> OpenSearchListeningMessageSearchIndex.this.processAddedEvent(session, (MailboxEvents.Added)added, mailboxId));
        }

        private Mono<Void> processExpunged(MailboxSession session, MailboxId mailboxId, MailboxEvents.Expunged expungedEvent) {
            return Mono.justOrEmpty((Optional)expungedEvent.movedToMailboxId()).flatMap(movedToMailboxId -> Flux.fromIterable(expungedEvent.getExpunged().values()).concatMap(oldMessageData -> this.handleExpungedMessage((MessageMetaData)oldMessageData, mailboxId, (MailboxId)movedToMailboxId, session)).then(Mono.defer(() -> OpenSearchListeningMessageSearchIndex.this.delete(session, mailboxId, expungedEvent.getUids()))));
        }

        private Mono<Void> handleExpungedMessage(MessageMetaData expungedMessageMetaData, MailboxId movedFromMailboxId, MailboxId movedToMailboxId, MailboxSession session) {
            return this.newIndexByIndexedDocument(expungedMessageMetaData.getUid(), movedFromMailboxId, movedToMailboxId, session, expungedMessageMetaData.getMessageId()).onErrorResume(OpenSearchNotFoundException.class, notFoundException -> {
                LOGGER.warn("Can not find message {} in mailbox {} for reindexing", (Object)expungedMessageMetaData.getUid(), (Object)movedFromMailboxId.serialize());
                return this.notFoundHandleFallBack(expungedMessageMetaData, movedToMailboxId, session);
            });
        }

        private Mono<Void> newIndexByIndexedDocument(MessageUid oldMessageUid, MailboxId movedFromMailboxId, MailboxId movedToMailboxId, MailboxSession session, MessageId messageId) {
            RoutingKey movedFromRoutingKey = OpenSearchListeningMessageSearchIndex.this.routingKeyFactory.from((Object)movedFromMailboxId);
            return OpenSearchListeningMessageSearchIndex.this.openSearchIndexer.get(OpenSearchListeningMessageSearchIndex.this.indexIdFor(movedFromMailboxId, oldMessageUid), movedFromRoutingKey).filter(GetResult::found).switchIfEmpty(Mono.error(() -> new OpenSearchNotFoundException("Can not find message " + String.valueOf(oldMessageUid) + " in mailbox " + movedFromMailboxId.serialize()))).mapNotNull(GetResult::source).flatMap(document -> this.updateDocumentThenIndex(messageId, movedToMailboxId, (ObjectNode)document, session));
        }

        private Mono<Void> notFoundHandleFallBack(MessageMetaData expungedMessageMetaData, MailboxId movedToMailboxId, MailboxSession session) {
            return this.retrieveMailboxMessage(session, expungedMessageMetaData.getMessageId(), movedToMailboxId, MessageMapper.FetchType.FULL).publishOn(Schedulers.parallel()).flatMap(mailboxMessage -> OpenSearchListeningMessageSearchIndex.this.factory.getMailboxMapper(session).findMailboxById(movedToMailboxId).flatMap(mailbox -> OpenSearchListeningMessageSearchIndex.this.add(session, (Mailbox)mailbox, (MailboxMessage)mailboxMessage)).doOnSuccess(any -> OpenSearchListeningMessageSearchIndex.this.reIndexNotFoundMetric.increment()));
        }

        private Mono<Void> updateDocumentThenIndex(MessageId messageId, MailboxId movedToMailboxId, ObjectNode origin, MailboxSession session) {
            return this.retrieveMailboxMessage(session, messageId, movedToMailboxId, MessageMapper.FetchType.METADATA).flatMap(mailboxMessage -> Mono.fromCallable(() -> {
                OpenSearchListeningMessageSearchIndex.this.messageToOpenSearchJson.updateMessageUid(origin, mailboxMessage.getUid());
                OpenSearchListeningMessageSearchIndex.this.messageToOpenSearchJson.updateMailboxId(origin, movedToMailboxId);
                mailboxMessage.getSaveDate().ifPresent(newSaveDate -> OpenSearchListeningMessageSearchIndex.this.messageToOpenSearchJson.updateSaveDate(origin, (Date)newSaveDate));
                return origin;
            }).map(OpenSearchListeningMessageSearchIndex.this.messageToOpenSearchJson::toString).flatMap(jsonContent -> OpenSearchListeningMessageSearchIndex.this.add(movedToMailboxId, mailboxMessage.getUid(), (String)jsonContent)));
        }

        private Mono<MailboxMessage> retrieveMailboxMessage(MailboxSession session, MessageId messageId, MailboxId movedToMailboxId, MessageMapper.FetchType fetchType) {
            return OpenSearchListeningMessageSearchIndex.this.factory.getMessageIdMapper(session).findReactive(List.of(messageId), fetchType).filter(mailboxMessage -> mailboxMessage.getMailboxId().equals((Object)movedToMailboxId)).next();
        }
    }

    static interface IndexingStrategy {
        public Mono<Void> handleExpungedEvent(MailboxEvents.Expunged var1, MailboxSession var2, MailboxId var3);

        public Mono<Void> handleAddedEvent(MailboxSession var1, MailboxEvents.Added var2, MailboxId var3);
    }

    class NaiveIndexingStrategy
    implements IndexingStrategy {
        NaiveIndexingStrategy() {
        }

        @Override
        public Mono<Void> handleExpungedEvent(MailboxEvents.Expunged expunged, MailboxSession session, MailboxId mailboxId) {
            return OpenSearchListeningMessageSearchIndex.this.delete(session, expunged.getMailboxId(), expunged.getUids());
        }

        @Override
        public Mono<Void> handleAddedEvent(MailboxSession session, MailboxEvents.Added addedEvent, MailboxId mailboxId) {
            return OpenSearchListeningMessageSearchIndex.this.processAddedEvent(session, addedEvent, mailboxId);
        }
    }

    public static class OpenSearchListeningMessageSearchIndexGroup
    extends Group {
    }

    static class OpenSearchNotFoundException
    extends RuntimeException {
        public OpenSearchNotFoundException(String message) {
            super(message);
        }
    }
}

