/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.inject.Module;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraJamesServerConfiguration;
import org.apache.james.CassandraJamesServerMain;
import org.apache.james.DockerOpenSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.StartUpChecksPerformer;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionDAO;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionManager;
import org.apache.james.backends.cassandra.versions.SchemaVersion;
import org.apache.james.modules.protocols.ImapGuiceProbe;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;
import reactor.core.publisher.Mono;

class CassandraSchemaVersionStartUpCheckTest {
    private static final String LOCAL_HOST = "127.0.0.1";
    private static final String EXPECTED_SERVER_CONNECTED_MESSAGE = "* OK JAMES IMAP4rev1 Server";
    private static final SchemaVersion MIN_VERSION = new SchemaVersion(2);
    private static final SchemaVersion MAX_VERSION = new SchemaVersion(4);
    private static CassandraSchemaVersionDAO versionDAO = (CassandraSchemaVersionDAO)Mockito.mock(CassandraSchemaVersionDAO.class);
    @RegisterExtension
    static JamesServerExtension testExtension = new JamesServerBuilder(tmpDir -> CassandraJamesServerConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().searchConfiguration(SearchConfiguration.openSearch()).build()).extension((GuiceModuleTestExtension)new DockerOpenSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).server(configuration -> CassandraJamesServerMain.createServer((CassandraJamesServerConfiguration)configuration).overrideWith(new Module[]{binder -> binder.bind(CassandraSchemaVersionDAO.class).toInstance((Object)versionDAO)}).overrideWith(new Module[]{binder -> binder.bind(CassandraSchemaVersionManager.class).toInstance((Object)new CassandraSchemaVersionManager(versionDAO, MIN_VERSION, MAX_VERSION))})).disableAutoStart().build();
    private SocketChannel socketChannel;

    CassandraSchemaVersionStartUpCheckTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.socketChannel = SocketChannel.open();
    }

    @AfterEach
    void tearDown() throws IOException {
        this.socketChannel.close();
    }

    @Test
    void serverShouldStartSuccessfullyWhenMaxVersion(GuiceJamesServer server) throws Exception {
        Mockito.when((Object)versionDAO.getCurrentSchemaVersion()).thenReturn((Object)Mono.just(Optional.of(MAX_VERSION)));
        server.start();
        Assertions.assertThat((String)this.responseAfterConnectTo(server)).startsWith((CharSequence)EXPECTED_SERVER_CONNECTED_MESSAGE);
    }

    @Test
    void serverShouldStartSuccessfullyWhenBetweenMinAndMaxVersion(GuiceJamesServer server) throws Exception {
        Mockito.when((Object)versionDAO.getCurrentSchemaVersion()).thenReturn((Object)Mono.just(Optional.of(MIN_VERSION.next())));
        server.start();
        Assertions.assertThat((String)this.responseAfterConnectTo(server)).startsWith((CharSequence)EXPECTED_SERVER_CONNECTED_MESSAGE);
    }

    @Test
    void serverShouldStartSuccessfullyWhenMinVersion(GuiceJamesServer server) throws Exception {
        Mockito.when((Object)versionDAO.getCurrentSchemaVersion()).thenReturn((Object)Mono.just(Optional.of(MIN_VERSION)));
        server.start();
        Assertions.assertThat((String)this.responseAfterConnectTo(server)).startsWith((CharSequence)EXPECTED_SERVER_CONNECTED_MESSAGE);
    }

    @Test
    void serverShouldNotStartWhenUnderMinVersion(GuiceJamesServer server) {
        Mockito.when((Object)versionDAO.getCurrentSchemaVersion()).thenReturn((Object)Mono.just(Optional.of(MIN_VERSION.previous())));
        Assertions.assertThatThrownBy(() -> ((GuiceJamesServer)server).start()).isInstanceOfSatisfying(StartUpChecksPerformer.StartUpChecksException.class, exception -> Assertions.assertThat((List)exception.badCheckNames()).containsOnly((Object[])new String[]{"CassandraSchemaVersionStartUpCheck"}));
    }

    @Test
    void serverShouldNotStartWhenAboveMaxVersion(GuiceJamesServer server) {
        Mockito.when((Object)versionDAO.getCurrentSchemaVersion()).thenReturn((Object)Mono.just(Optional.of(MAX_VERSION.next())));
        Assertions.assertThatThrownBy(() -> ((GuiceJamesServer)server).start()).isInstanceOfSatisfying(StartUpChecksPerformer.StartUpChecksException.class, exception -> Assertions.assertThat((List)exception.badCheckNames()).containsOnly((Object[])new String[]{"CassandraSchemaVersionStartUpCheck"}));
    }

    private String responseAfterConnectTo(GuiceJamesServer server) throws IOException {
        this.socketChannel.connect(new InetSocketAddress(LOCAL_HOST, ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()));
        ByteBuffer byteBuffer = ByteBuffer.allocate(1000);
        this.socketChannel.read(byteBuffer);
        byte[] bytes = byteBuffer.array();
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

