/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import org.apache.james.CleanupTasksPerformer;
import org.apache.james.backends.opensearch.DockerOpenSearch;
import org.apache.james.backends.opensearch.OpenSearchConfiguration;
import org.apache.james.task.Task;

public class TestDockerOpenSearchModule
extends AbstractModule {
    private final DockerOpenSearch elasticSearch;

    public TestDockerOpenSearchModule(DockerOpenSearch elasticSearch) {
        this.elasticSearch = elasticSearch;
    }

    protected void configure() {
        this.bind(OpenSearchConfiguration.class).toInstance((Object)this.elasticSearch.configuration());
        Multibinder.newSetBinder((Binder)this.binder(), CleanupTasksPerformer.CleanupTask.class).addBinding().toInstance((Object)new ESContainerCleanUp(this.elasticSearch));
    }

    private static class ESContainerCleanUp
    implements CleanupTasksPerformer.CleanupTask {
        private final DockerOpenSearch elasticSearch;

        private ESContainerCleanUp(DockerOpenSearch elasticSearch) {
            this.elasticSearch = elasticSearch;
        }

        public Task.Result run() {
            this.elasticSearch.cleanUpData();
            return Task.Result.COMPLETED;
        }
    }
}

