/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import org.apache.james.CassandraExtension;
import org.apache.james.CassandraJamesServerMain;
import org.apache.james.DockerOpenSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.TestingDistributedJamesServerBuilder;
import org.apache.james.backends.cassandra.DockerCassandraSingleton;
import org.apache.james.backends.cassandra.init.configuration.ClusterConfiguration;
import org.apache.james.modules.mailbox.KeyspacesConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class KeyspaceCreationTest {
    KeyspaceCreationTest() {
    }

    @Nested
    class StartWhenKeyspaceDoesNotExist {
        @RegisterExtension
        JamesServerExtension testExtension = TestingDistributedJamesServerBuilder.withSearchConfiguration(SearchConfiguration.openSearch()).extension((GuiceModuleTestExtension)new DockerOpenSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).server(CassandraJamesServerMain::createServer).overrideServerModule(binder -> binder.bind(ClusterConfiguration.class).toInstance((Object)DockerCassandraSingleton.singleton.configurationBuilder().build())).overrideServerModule(binder -> binder.bind(KeyspacesConfiguration.class).toInstance((Object)KeyspacesConfiguration.builder().keyspace("non_existing_keyspace").cacheKeyspace("cache_non_existing_keyspace").replicationFactor(1).disableDurableWrites().build())).disableAutoStart().build();

        StartWhenKeyspaceDoesNotExist() {
        }

        @Test
        void startShouldThrowWhenAttemptToUseANonExistingKeyspace(GuiceJamesServer jamesServer) {
            Assertions.assertThatThrownBy(() -> ((GuiceJamesServer)jamesServer).start()).isInstanceOf(Exception.class);
        }
    }

    @Nested
    class CreateWhenDoesNotExistAndDoNotHaveRights {
        @RegisterExtension
        JamesServerExtension testExtension = TestingDistributedJamesServerBuilder.withSearchConfiguration(SearchConfiguration.openSearch()).extension((GuiceModuleTestExtension)new DockerOpenSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).server(CassandraJamesServerMain::createServer).overrideServerModule(binder -> binder.bind(ClusterConfiguration.class).toInstance((Object)DockerCassandraSingleton.singleton.configurationBuilder().createKeyspace().build())).overrideServerModule(binder -> binder.bind(KeyspacesConfiguration.class).toInstance((Object)KeyspacesConfiguration.builder().keyspace("non_existing_keyspace").cacheKeyspace("cache_non_existing_keyspace").replicationFactor(1).disableDurableWrites().build())).disableAutoStart().build();

        CreateWhenDoesNotExistAndDoNotHaveRights() {
        }

        @Test
        void startShouldThrowWhenAttemptToCreateAKeyspace(GuiceJamesServer jamesServer) {
            Assertions.assertThatThrownBy(() -> ((GuiceJamesServer)jamesServer).start()).isInstanceOf(Exception.class);
        }
    }

    @Nested
    class CreateWhenDoesNotExistAndHasRights {
        @RegisterExtension
        JamesServerExtension testExtension = TestingDistributedJamesServerBuilder.withSearchConfiguration(SearchConfiguration.openSearch()).extension((GuiceModuleTestExtension)new DockerOpenSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).server(CassandraJamesServerMain::createServer).overrideServerModule(binder -> binder.bind(KeyspacesConfiguration.class).toInstance((Object)KeyspacesConfiguration.builder().keyspace("non_existing_keyspace").cacheKeyspace("cache_non_existing_keyspace").replicationFactor(1).disableDurableWrites().build())).overrideServerModule(binder -> binder.bind(ClusterConfiguration.class).toInstance((Object)DockerCassandraSingleton.singleton.superUserConfigurationBuilder().createKeyspace().build())).disableAutoStart().build();

        CreateWhenDoesNotExistAndHasRights() {
        }

        @Test
        void startShouldNotThrowWhenCreateAKeyspaceWithAuthorizedSession(GuiceJamesServer jamesServer) {
            Assertions.assertThatCode(() -> ((GuiceJamesServer)jamesServer).start()).doesNotThrowAnyException();
        }
    }

    @Nested
    class CreateWhenKeyspaceExists {
        @RegisterExtension
        JamesServerExtension testExtension = TestingDistributedJamesServerBuilder.withSearchConfiguration(SearchConfiguration.openSearch()).extension((GuiceModuleTestExtension)new DockerOpenSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).server(CassandraJamesServerMain::createServer).overrideServerModule(binder -> binder.bind(ClusterConfiguration.class).toInstance((Object)DockerCassandraSingleton.singleton.configurationBuilder().createKeyspace().build())).disableAutoStart().build();

        CreateWhenKeyspaceExists() {
        }

        @Test
        void startShouldNotThrowWhenKeyspaceExists(GuiceJamesServer jamesServer) {
            Assertions.assertThatCode(() -> ((GuiceJamesServer)jamesServer).start()).doesNotThrowAnyException();
        }
    }
}

