/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.Module;
import java.util.List;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraJamesServerConfiguration;
import org.apache.james.CassandraJamesServerMain;
import org.apache.james.DockerOpenSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.StartUpChecksPerformer;
import org.apache.james.TestingDistributedJamesServerBuilder;
import org.apache.james.backends.opensearch.DockerOpenSearch;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.apache.james.modules.TestJMAPServerModule;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class JamesWithNonCompatibleElasticSearchServerTest {
    static DockerOpenSearch dockerES6 = new DockerOpenSearch.NoAuth("docker.elastic.co/elasticsearch/elasticsearch:6.3.2");
    @RegisterExtension
    static JamesServerExtension testExtension = TestingDistributedJamesServerBuilder.withSearchConfiguration(SearchConfiguration.openSearch()).extension((GuiceModuleTestExtension)new DockerOpenSearchExtension(dockerES6)).extension((GuiceModuleTestExtension)new CassandraExtension()).server(configuration -> CassandraJamesServerMain.createServer((CassandraJamesServerConfiguration)configuration).overrideWith(new Module[]{new TestJMAPServerModule()})).disableAutoStart().build();

    JamesWithNonCompatibleElasticSearchServerTest() {
    }

    @AfterAll
    static void afterAll() {
        dockerES6.stop();
    }

    @Test
    void jamesShouldStopWhenStartingWithANonCompatibleElasticSearchServer(GuiceJamesServer server) throws Exception {
        Assertions.assertThatThrownBy(() -> ((GuiceJamesServer)server).start()).isInstanceOfSatisfying(StartUpChecksPerformer.StartUpChecksException.class, ex -> Assertions.assertThat((List)ex.getBadChecks()).containsOnly((Object[])new StartUpCheck.CheckResult[]{StartUpCheck.CheckResult.builder().checkName("OpenSearchStartUpCheck").resultType(StartUpCheck.ResultType.BAD).description("Error when checking ES version: Missing required property 'OpenSearchVersionInfo.distribution'").build()}));
        Assertions.assertThat((boolean)server.isStarted()).isFalse();
    }
}

